/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.DirectScannable;
import com.apple.foundationdb.relational.recordlayer.RecordLayerIterator;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.ResumableIterator;
import com.apple.foundationdb.relational.recordlayer.TupleUtils;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RecordTypeScannable<CursorT>
implements DirectScannable {
    @Override
    public final ResumableIterator<Row> openScan(@Nullable Row keyPrefix, @Nonnull Options options) throws RelationalException {
        TupleRange range = TupleRange.allOf(TupleUtils.toFDBTuple(keyPrefix));
        BackingStore store = this.getSchema().loadStore();
        RecordCursor<CursorT> cursor = this.openScan(store, range, (Continuation)options.getOption(Options.Name.CONTINUATION), options);
        return RecordLayerIterator.create(cursor, this.keyValueTransform());
    }

    protected abstract RecordCursor<CursorT> openScan(BackingStore var1, TupleRange var2, @Nullable Continuation var3, Options var4) throws RelationalException;

    protected abstract RecordLayerSchema getSchema();

    protected abstract Function<CursorT, Row> keyValueTransform();

    protected abstract boolean supportsMessageParsing();

    protected abstract boolean hasConstantValueForPrimaryKey(Options var1) throws RelationalException;
}

