/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.ImmutableRowStruct;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.Index;
import com.apple.foundationdb.relational.recordlayer.KeyBuilder;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.RecordStoreIndex;
import com.apple.foundationdb.relational.recordlayer.RecordTypeScannable;
import com.apple.foundationdb.relational.recordlayer.Table;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.NullableArrayUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordTypeTable
extends RecordTypeScannable<FDBStoredRecord<Message>>
implements Table {
    private final RecordLayerSchema schema;
    private final String tableName;
    private final EmbeddedRelationalConnection conn;
    private RecordType currentTypeRef;

    public RecordTypeTable(@Nonnull RecordLayerSchema schema, @Nonnull String tableName) {
        this.schema = schema;
        this.tableName = tableName;
        this.conn = schema.conn;
    }

    @Override
    public void validate(Options scanOptions) throws RelationalException {
        this.loadRecordType(scanOptions);
    }

    @Override
    @Nonnull
    public RecordLayerSchema getSchema() {
        return this.schema;
    }

    @Override
    public Row get(@Nonnull Transaction t2, @Nonnull Row key, @Nonnull Options options) throws RelationalException {
        this.loadRecordType(options);
        BackingStore store = this.schema.loadStore();
        return store.get(key, options);
    }

    @Override
    @Nonnull
    public StructMetaData getMetaData() throws RelationalException {
        RecordType type = this.loadRecordType(Options.NONE);
        Map descriptorLookupMap = type.getDescriptor().getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Function.identity()));
        TreeMap<String, Descriptors.FieldDescriptor> orderedFieldMap = new TreeMap<String, Descriptors.FieldDescriptor>((o1, o2) -> {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Descriptors.FieldDescriptor field1 = (Descriptors.FieldDescriptor)descriptorLookupMap.get(o1);
            Descriptors.FieldDescriptor field2 = (Descriptors.FieldDescriptor)descriptorLookupMap.get(o2);
            return Integer.compare(field1.getIndex(), field2.getIndex());
        });
        orderedFieldMap.putAll(descriptorLookupMap);
        Type.Record record = Type.Record.fromFieldDescriptorsMap(orderedFieldMap);
        return RelationalStructMetaData.of((DataType.StructType)DataTypeUtils.toRelationalType(record));
    }

    @Override
    public KeyBuilder getKeyBuilder() throws RelationalException {
        RecordType typeForKey = this.loadRecordType(Options.NONE);
        return new KeyBuilder(typeForKey, typeForKey.getPrimaryKey(), "primary key of <" + this.tableName + ">");
    }

    @Override
    public boolean deleteRecord(@Nonnull Row key) throws RelationalException {
        BackingStore store = this.schema.loadStore();
        return store.delete(key);
    }

    @Override
    public void deleteRange(Map<String, Object> prefix) throws RelationalException {
        String tableNameForDelete = this.loadRecordType(Options.NONE).primaryKeyHasRecordTypePrefix() ? this.tableName : null;
        BackingStore store = this.schema.loadStore();
        store.deleteRange(prefix, tableNameForDelete);
    }

    @Override
    @Deprecated
    public boolean insertRecord(@Nonnull Message message, boolean replaceOnDuplicate) throws RelationalException {
        BackingStore store = this.schema.loadStore();
        return store.insert(this.tableName, message, replaceOnDuplicate);
    }

    @Override
    @Deprecated
    public boolean insertRecord(@Nonnull RelationalStruct insert, boolean replaceOnDuplicate) throws RelationalException {
        BackingStore store = this.schema.loadStore();
        try {
            RecordType recordType = store.getRecordMetaData().getRecordType(this.tableName);
            Message message = RecordTypeTable.toDynamicMessage(insert, recordType.getDescriptor());
            return this.insertRecord(message, replaceOnDuplicate);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Nonnull
    public static Message toDynamicMessage(RelationalStruct struct, Descriptors.Descriptor descriptor) throws RelationalException {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder(descriptor);
        try {
            DataType.StructType type = struct.getMetaData().getRelationalDataType();
            List<DataType.StructType.Field> fields = type.getFields();
            block9: for (int i = 0; i < fields.size(); ++i) {
                DataType.StructType.Field field = fields.get(i);
                String columnName = fields.get(i).getName();
                Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(columnName);
                Assert.thatUnchecked(fd != null, ErrorCode.INVALID_PARAMETER, "Cannot find column name: " + columnName);
                if (fd.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                    String maybeEnumValue = struct.getString(i + 1);
                    if (maybeEnumValue == null) continue;
                    Descriptors.EnumValueDescriptor valueDescriptor = fd.getEnumType().findValueByName(maybeEnumValue);
                    Assert.thatUnchecked(valueDescriptor != null, ErrorCode.CANNOT_CONVERT_TYPE, "Invalid enum value: %s", maybeEnumValue);
                    builder.setField(fd, valueDescriptor);
                    continue;
                }
                switch (field.getType().getCode()) {
                    case BOOLEAN: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INTEGER: 
                    case LONG: 
                    case STRING: {
                        Object obj = struct.getObject(i + 1);
                        if (obj == null) continue block9;
                        builder.setField(fd, obj);
                        continue block9;
                    }
                    case BYTES: {
                        byte[] bytes = struct.getBytes(i + 1);
                        if (bytes == null) continue block9;
                        builder.setField(fd, ByteString.copyFrom(bytes));
                        continue block9;
                    }
                    case STRUCT: {
                        RelationalStruct subStruct = struct.getStruct(i + 1);
                        if (subStruct == null) continue block9;
                        builder.setField(fd, RecordTypeTable.toDynamicMessage(subStruct, fd.getMessageType()));
                        continue block9;
                    }
                    case ARRAY: {
                        RelationalArray array = struct.getArray(i + 1);
                        if (fd.isRepeated()) {
                            Object arrayItems;
                            for (Object arrayItem : arrayItems = array == null ? new Object[]{} : array.getArray()) {
                                if (arrayItem instanceof RelationalStruct) {
                                    builder.addRepeatedField(fd, RecordTypeTable.toDynamicMessage((RelationalStruct)arrayItem, fd.getMessageType()));
                                    continue;
                                }
                                builder.addRepeatedField(fd, arrayItem);
                            }
                            continue block9;
                        }
                        if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                            Assert.thatUnchecked(NullableArrayUtils.isWrappedArrayDescriptor(fd.getMessageType()));
                            ImmutableRowStruct wrapper = new ImmutableRowStruct(new ArrayRow(array), RelationalStructMetaData.of(DataType.StructType.from("STRUCT", List.of(DataType.StructType.Field.from("values", array.getMetaData().asRelationalType(), 0)), true)));
                            builder.setField(fd, RecordTypeTable.toDynamicMessage(wrapper, fd.getMessageType()));
                            continue block9;
                        }
                        Assert.failUnchecked("Field Type expected to be of Type ARRAY but is actually " + String.valueOf((Object)fd.getType()));
                        continue block9;
                    }
                    case NULL: {
                        continue block9;
                    }
                    default: {
                        Assert.failUnchecked(ErrorCode.INTERNAL_ERROR, String.format(Locale.ROOT, "Unexpected Column type <%s> for column <%s>", struct.getMetaData().getColumnType(i), columnName));
                    }
                }
            }
        }
        catch (SQLException sqle) {
            throw new RelationalException(sqle);
        }
        return builder.build();
    }

    @Override
    public Set<Index> getAvailableIndexes() throws RelationalException {
        return this.loadRecordType(Options.NONE).getIndexes().stream().map(index -> new RecordStoreIndex((com.apple.foundationdb.record.metadata.Index)index, this)).collect(Collectors.toSet());
    }

    @Override
    public void close() throws RelationalException {
        this.currentTypeRef = null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.tableName;
    }

    @Override
    public void validateTable(@Nonnull Options options) throws RelationalException {
        this.loadRecordType(options);
    }

    @Override
    protected RecordCursor<FDBStoredRecord<Message>> openScan(BackingStore store, TupleRange range, @Nullable Continuation continuation, Options options) throws RelationalException {
        RecordType type = this.loadRecordType(options);
        return store.scanType(type, range, continuation, options);
    }

    @Override
    protected Function<FDBStoredRecord<Message>, Row> keyValueTransform() {
        return record -> new MessageTuple((Message)record.getRecord());
    }

    @Override
    protected boolean supportsMessageParsing() {
        return true;
    }

    @Override
    protected boolean hasConstantValueForPrimaryKey(Options options) throws RelationalException {
        return this.loadRecordType(options).getPrimaryKey() instanceof RecordTypeKeyExpression;
    }

    RecordType loadRecordType(Options options) throws RelationalException {
        BackingStore store = this.schema.loadStore();
        RecordMetaData metaData = store.getRecordMetaData();
        if (this.currentTypeRef == null) {
            try {
                this.currentTypeRef = store.getRecordMetaData().getRecordType(this.tableName);
                this.validateRecordType(this.currentTypeRef, metaData, options);
                this.conn.addCloseListener(() -> {
                    this.currentTypeRef = null;
                });
            }
            catch (MetaDataException mde) {
                throw new RelationalException(mde.getMessage(), ErrorCode.UNDEFINED_SCHEMA, mde);
            }
        } else {
            this.validateRecordType(this.currentTypeRef, metaData, options);
        }
        return this.currentTypeRef;
    }

    private void validateRecordType(RecordType recordType, RecordMetaData metaData, Options options) throws RelationalException {
        Integer requiredVersion = (Integer)options.getOption(Options.Name.REQUIRED_METADATA_TABLE_VERSION);
        if (requiredVersion != null) {
            Integer tableMetaDataVersion = recordType.getSinceVersion();
            int metaDataVersion = metaData.getVersion();
            if (tableMetaDataVersion == null) {
                String errMsg = String.format(Locale.ROOT, "table <%s> is not available, creation version is missing from metadata(version <%s>)", recordType.getName(), metaDataVersion);
                throw new RelationalException(errMsg, ErrorCode.INCORRECT_METADATA_TABLE_VERSION).addContext("metadataVersion", metaDataVersion).addContext("recordType", recordType.getName());
            }
            if (requiredVersion != -1 && requiredVersion < tableMetaDataVersion) {
                String errMsg = String.format(Locale.ROOT, "table <%s> is not available, creation version is invalid for metadata(version <%s>); Required creation version <%s>", recordType.getName(), metaDataVersion, requiredVersion);
                throw new RelationalException(errMsg, ErrorCode.INCORRECT_METADATA_TABLE_VERSION).addContext("metadataVersion", metaDataVersion).addContext("recordType", recordType.getName());
            }
        }
    }
}

