/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.DirectoryLayerDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePathWrapper;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverCreateHooks;
import com.apple.foundationdb.record.provider.foundationdb.layers.interning.ScopedInterningLayer;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.KeySpaceUtils;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalKeyspaceProvider {
    public static final String SYS = "__SYS";
    public static final String CATALOG = "CATALOG";
    public static final String DB_NAME_DIR = "dbName";
    public static final String SCHEMA_DIR = "schema";
    public static final String INTERNING_LAYER = "__internedStrings";
    public static final String INTERNING_LAYER_VALUE = "IL";
    private static final RelationalKeyspaceProvider INSTANCE = new RelationalKeyspaceProvider();
    private final KeySpace keyspace = new KeySpace(RelationalKeyspaceProvider.getSystemDirectory());

    private RelationalKeyspaceProvider() {
    }

    private static KeySpaceDirectory getSystemDirectory() {
        return new KeySpaceDirectory(SYS, KeySpaceDirectory.KeyType.NULL, RelationalSystemDomainPath::new).addSubdirectory(new KeySpaceDirectory(SYS, KeySpaceDirectory.KeyType.NULL, RelationalSystemDatabasePath::new).addSubdirectory(new KeySpaceDirectory(CATALOG, KeySpaceDirectory.KeyType.LONG, 0L, RelationalSchemaPath::new))).addSubdirectory(new KeySpaceDirectory(INTERNING_LAYER, KeySpaceDirectory.KeyType.STRING, INTERNING_LAYER_VALUE));
    }

    public void registerDomainIfNotExists(@Nonnull String domainName) {
        KeySpaceDirectory keySpaceRoot = this.getKeySpace().getRoot();
        boolean exists = keySpaceRoot.getSubdirectories().stream().map(KeySpaceDirectory::getName).anyMatch(dirName -> dirName.equals(domainName));
        if (exists) {
            return;
        }
        KeySpaceDirectory domainDirectory = new DirectoryLayerDirectory(domainName, domainName, RelationalDomainPath::new).addSubdirectory(new KeySpaceDirectory(INTERNING_LAYER, KeySpaceDirectory.KeyType.STRING, INTERNING_LAYER_VALUE));
        keySpaceRoot.addSubdirectory(domainDirectory);
        RelationalDomainPath domainPath = (RelationalDomainPath)this.getKeySpace().path(domainName);
        domainDirectory.addSubdirectory(new DirectoryLayerDirectory(DB_NAME_DIR, RelationalDatabasePath::new, domainPath::generateScopeAsync, ResolverCreateHooks.getDefault()).addSubdirectory(new DirectoryLayerDirectory(SCHEMA_DIR, RelationalSchemaPath::new, domainPath::generateScopeAsync, ResolverCreateHooks.getDefault())));
    }

    public KeySpace getKeySpace() {
        return this.keyspace;
    }

    public RelationalDatabasePath toDatabasePath(@Nonnull URI url) throws RelationalException {
        return RelationalKeyspaceProvider.toDatabasePath(url, this.getKeySpace());
    }

    public static RelationalDatabasePath toDatabasePath(@Nonnull URI url, KeySpace keyspace) throws RelationalException {
        KeySpacePath keySpacePath = KeySpaceUtils.toKeySpacePath(url, keyspace);
        if (keySpacePath instanceof RelationalSystemDatabasePath) {
            return (RelationalSystemDatabasePath)keySpacePath;
        }
        if (DB_NAME_DIR.equals(keySpacePath.getDirectoryName())) {
            return (RelationalDatabasePath)keySpacePath;
        }
        throw new RelationalException("<" + String.valueOf(url) + "> is an invalid database path", ErrorCode.INVALID_PATH);
    }

    @Nonnull
    public static RelationalKeyspaceProvider instance() {
        return INSTANCE;
    }

    @Nonnull
    @VisibleForTesting
    public static RelationalKeyspaceProvider newInstanceForTesting() {
        return new RelationalKeyspaceProvider();
    }

    public static class RelationalDomainPath
    extends KeySpacePathWrapper {
        public RelationalDomainPath(@Nonnull KeySpacePath inner) {
            super(inner);
        }

        @Nonnull
        public String getDomainName() {
            return this.inner.getDirectoryName();
        }

        @Nonnull
        public RelationalDatabasePath database(@Nonnull String dbName) {
            Assert.thatUnchecked(RelationalKeyspaceProvider.INTERNING_LAYER.equals(dbName), ErrorCode.INVALID_DATABASE, () -> "Invalid database name: " + dbName);
            return (RelationalDatabasePath)this.inner.add(RelationalKeyspaceProvider.DB_NAME_DIR, dbName);
        }

        @Nonnull
        public KeySpacePath internedStrings() {
            return this.inner.add(RelationalKeyspaceProvider.INTERNING_LAYER);
        }

        @Nonnull
        public CompletableFuture<LocatableResolver> generateScopeAsync(@Nonnull FDBRecordContext context) {
            return this.internedStrings().toResolvedPathAsync(context).thenApply(resolvedPath -> new ScopedInterningLayer(context.getDatabase(), (ResolvedKeySpacePath)resolvedPath));
        }
    }

    public static class RelationalDatabasePath
    extends KeySpacePathWrapper {
        public RelationalDatabasePath(KeySpacePath inner) {
            super(inner);
        }

        @Nonnull
        public RelationalSchemaPath schemaPath(String schemaName) {
            return (RelationalSchemaPath)this.inner.add(RelationalKeyspaceProvider.SCHEMA_DIR, schemaName);
        }

        @Nonnull
        public URI toUri() {
            return KeySpaceUtils.pathToUri(this.inner);
        }
    }

    public static class RelationalSystemDatabasePath
    extends RelationalDatabasePath {
        public RelationalSystemDatabasePath(KeySpacePath inner) {
            super(inner);
        }

        @Override
        @Nonnull
        public RelationalSchemaPath schemaPath(String schemaName) {
            Assert.thatUnchecked(RelationalKeyspaceProvider.CATALOG.equals(schemaName), ErrorCode.UNDEFINED_SCHEMA, "Unknown system schema name: " + schemaName);
            return (RelationalSchemaPath)this.inner.add(RelationalKeyspaceProvider.CATALOG);
        }

        @Override
        @Nonnull
        public URI toUri() {
            return URI.create("/__SYS");
        }
    }

    public static class RelationalSchemaPath
    extends KeySpacePathWrapper {
        public RelationalSchemaPath(KeySpacePath inner) {
            super(inner);
        }

        public String getSchemaName() {
            String directoryName = this.getDirectoryName();
            if (RelationalKeyspaceProvider.SCHEMA_DIR.equals(directoryName)) {
                return (String)this.getValue();
            }
            return directoryName;
        }
    }

    public static class RelationalSystemDomainPath
    extends RelationalDomainPath {
        public RelationalSystemDomainPath(KeySpacePath inner) {
            super(inner);
        }

        @Override
        @Nonnull
        public String getDomainName() {
            return RelationalKeyspaceProvider.SYS;
        }

        @Override
        @Nonnull
        public RelationalSystemDatabasePath database(@Nonnull String dbName) {
            Assert.thatUnchecked(RelationalKeyspaceProvider.SYS.equals(dbName), ErrorCode.UNDEFINED_DATABASE, "Unknown system database name: " + dbName);
            return (RelationalSystemDatabasePath)super.database(dbName);
        }
    }
}

