/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordMetaDataStore;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@API(value=API.Status.EXPERIMENTAL)
public class CachedMetaDataStore
implements RecordMetaDataStore {
    private final Map<String, CacheCell> cachedProviders = new HashMap<String, CacheCell>();
    private final RecordMetaDataStore backingStore;

    public CachedMetaDataStore(RecordMetaDataStore backingStore) {
        this.backingStore = backingStore;
    }

    @Override
    public RecordMetaDataProvider loadMetaData(@Nonnull Transaction txn, @Nonnull URI dbUri, @Nonnull String schemaName) throws RelationalException {
        String key = (dbUri.getPath() + "/" + schemaName).toUpperCase(Locale.ROOT);
        CacheCell cacheCell = this.cachedProviders.get(key);
        if (cacheCell == null) {
            RecordMetaDataProvider rmdp = this.backingStore.loadMetaData(txn, dbUri, schemaName);
            cacheCell = new CacheCell(rmdp);
            this.cachedProviders.put(key, cacheCell);
        }
        if (cacheCell.checkVersion) {
            RecordMetaData recordMetaData = this.backingStore.loadMetaData(txn, dbUri, schemaName).getRecordMetaData();
            int version = recordMetaData.getVersion();
            if (cacheCell.value.getRecordMetaData().getVersion() != version) {
                cacheCell = new CacheCell(recordMetaData);
                this.cachedProviders.put(key, cacheCell);
            } else {
                cacheCell.checkVersion = false;
            }
        }
        CacheCell theCell = cacheCell;
        txn.unwrap(RecordContextTransaction.class).addTerminationListener(() -> {
            theCell.checkVersion = true;
        });
        return theCell.value;
    }

    private static class CacheCell {
        private final RecordMetaDataProvider value;
        private boolean checkVersion;

        public CacheCell(RecordMetaDataProvider value) {
            this.value = value;
        }
    }
}

