/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.Schema;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.util.Assert;
import java.net.URI;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class CatalogMetaDataProvider
implements RecordMetaDataProvider {
    private final StoreCatalog storeCatalog;
    private final URI dbUri;
    private final String schemaName;
    private final Transaction txn;
    private volatile RecordMetaData cachedMetaData;

    public CatalogMetaDataProvider(@Nonnull StoreCatalog storeCatalog, @Nonnull URI dbUri, @Nonnull String schemaName, @Nonnull Transaction txn) {
        this.storeCatalog = storeCatalog;
        this.dbUri = dbUri;
        this.schemaName = schemaName;
        this.txn = txn;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        RecordMetaData metaData = this.cachedMetaData;
        if (metaData == null) {
            try {
                Schema recLayerSchema = this.storeCatalog.loadSchema(this.txn, this.dbUri, this.schemaName);
                Assert.thatUnchecked(recLayerSchema instanceof RecordLayerSchema);
                RecordMetaDataProto.MetaData schema = recLayerSchema.getSchemaTemplate().unwrap(RecordLayerSchemaTemplate.class).toRecordMetadata().toProto();
                this.cachedMetaData = metaData = RecordMetaData.build(schema);
            }
            catch (RelationalException e) {
                throw new RecordCoreException(e);
            }
        }
        return metaData;
    }
}

