/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog;

import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataOptionsProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.ProtobufDataBuilder;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.CatalogValidator;
import com.apple.foundationdb.relational.api.catalog.SchemaTemplateCatalog;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ProtobufDdlUtil;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.Schema;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.RecordLayerIterator;
import com.apple.foundationdb.relational.recordlayer.RecordLayerResultSet;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordLayerStoreSchemaTemplateCatalog;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordLayerStoreUtils;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.SystemTableRegistry;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import java.net.URI;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RecordLayerStoreCatalog
implements StoreCatalog {
    private static final URI DASH_DASH_SYS = URI.create("/__SYS");
    private static final String CATALOG_TEMPLATE = "CATALOG_TEMPLATE";
    private static final int CATALOG_TEMPLATE_VERSION = 1;
    private final RelationalKeyspaceProvider.RelationalSchemaPath catalogSchemaPath;
    private final RecordMetaDataProvider catalogRecordMetaDataProvider;
    private SchemaTemplateCatalog schemaTemplateCatalog;
    private final RecordLayerSchemaTemplate catalogSchemaTemplate;
    private final RecordLayerSchema catalogSchema;

    @SpotBugsSuppressWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Hard to remove exception with current inheritance")
    RecordLayerStoreCatalog(@Nonnull KeySpace keySpace) throws RelationalException {
        this.catalogSchemaPath = RelationalKeyspaceProvider.toDatabasePath(DASH_DASH_SYS, keySpace).schemaPath("CATALOG");
        RecordLayerSchemaTemplate.Builder schemaBuilder = RecordLayerSchemaTemplate.newBuilder();
        SystemTableRegistry.getSystemTable("SCHEMAS").addDefinition(schemaBuilder);
        SystemTableRegistry.getSystemTable("DATABASES").addDefinition(schemaBuilder);
        SystemTableRegistry.getSystemTable("TEMPLATES").addDefinition(schemaBuilder);
        this.catalogSchemaTemplate = schemaBuilder.setName(CATALOG_TEMPLATE).setVersion(1).build();
        this.catalogSchema = this.catalogSchemaTemplate.generateSchema(DASH_DASH_SYS.getPath(), "CATALOG");
        this.catalogRecordMetaDataProvider = RecordMetaData.build(this.catalogSchema.getSchemaTemplate().unwrap(RecordLayerSchemaTemplate.class).toRecordMetadata().toProto());
    }

    StoreCatalog initialize(@Nonnull Transaction createTxn) throws RelationalException {
        return this.initialize(createTxn, new RecordLayerStoreSchemaTemplateCatalog(this.catalogSchema, this.catalogSchemaPath));
    }

    StoreCatalog initialize(@Nonnull Transaction createTxn, @Nonnull SchemaTemplateCatalog schemaTemplateCatalog) throws RelationalException {
        try {
            FDBRecordStore store = (FDBRecordStore)FDBRecordStore.newBuilder().setKeySpacePath(this.catalogSchemaPath).setContext(createTxn.unwrap(FDBRecordContext.class)).setMetaDataProvider(this.catalogRecordMetaDataProvider).createOrOpen(FDBRecordStoreBase.StoreExistenceCheck.NONE);
            store.setStateCacheability(true);
            if (!schemaTemplateCatalog.doesSchemaTemplateExist(createTxn, this.catalogSchemaTemplate.getName())) {
                schemaTemplateCatalog.createTemplate(createTxn, this.catalogSchemaTemplate);
            }
            this.schemaTemplateCatalog = schemaTemplateCatalog;
            this.saveSchema(createTxn, this.catalogSchema, true);
        }
        catch (RecordCoreStorageException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
        return this;
    }

    @Override
    public SchemaTemplateCatalog getSchemaTemplateCatalog() {
        return this.schemaTemplateCatalog;
    }

    @Override
    @Nonnull
    public RecordLayerSchema loadSchema(@Nonnull Transaction txn, @Nonnull URI databaseId, @Nonnull String schemaName) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        Assert.notNull(recordStore);
        Tuple primaryKey = Tuple.from(0L, databaseId.getPath(), schemaName);
        try {
            FDBStoredRecord<Message> record = recordStore.loadRecord(primaryKey);
            if (record == null) {
                throw new RelationalException("Schema <" + databaseId.getPath() + "/" + schemaName + "> does not exist in the catalog!", ErrorCode.UNDEFINED_SCHEMA);
            }
            Message m4 = record.getRecord();
            return this.parseSchemaTable(m4, txn);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public void saveSchema(@Nonnull Transaction txn, @Nonnull Schema schema, boolean createDatabaseIfNecessary) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        CatalogValidator.validateSchema(schema);
        if (!this.doesDatabaseExist(recordStore, URI.create(schema.getDatabaseName()))) {
            if (createDatabaseIfNecessary) {
                this.createDatabase(recordStore, URI.create(schema.getDatabaseName()));
            } else {
                throw new RelationalException(String.format(Locale.ROOT, "Cannot create schema %s because database %s does not exist.", schema.getName(), schema.getDatabaseName()), ErrorCode.UNDEFINED_DATABASE);
            }
        }
        Assert.that(schema instanceof RecordLayerSchema, ErrorCode.UNDEFINED_SCHEMA, "Unexpected schema type %s", schema.getClass());
        Assert.that(this.schemaTemplateCatalog.doesSchemaTemplateExist(txn, schema.getSchemaTemplate().getName(), schema.getSchemaTemplate().getVersion()), ErrorCode.UNKNOWN_SCHEMA_TEMPLATE, () -> String.format(Locale.ROOT, "Cannot create schema %s because schema template %s version %d does not exist.", schema.getName(), schema.getSchemaTemplate().getName(), schema.getSchemaTemplate().getVersion()));
        try {
            this.putSchema((RecordLayerSchema)schema, recordStore);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public void repairSchema(@Nonnull Transaction txn, @Nonnull String databaseId, @Nonnull String schemaName) throws RelationalException {
        RecordLayerSchema schema = this.loadSchema(txn, URI.create(databaseId), schemaName);
        SchemaTemplate template = this.schemaTemplateCatalog.loadSchemaTemplate(txn, schema.getSchemaTemplate().getName());
        Schema newSchema = template.generateSchema(databaseId, schemaName);
        this.saveSchema(txn, newSchema, false);
    }

    @Override
    public void createDatabase(@Nonnull Transaction txn, URI dbUri) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        try {
            this.createDatabase(recordStore, dbUri);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    private void createDatabase(@Nonnull FDBRecordStoreBase<Message> recordStore, URI dbUri) throws RelationalException {
        try {
            ProtobufDataBuilder pmd = new ProtobufDataBuilder(this.catalogRecordMetaDataProvider.getRecordMetaData().getRecordType("DATABASES").getDescriptor());
            Message m4 = pmd.setField("DATABASE_ID", (Object)dbUri.getPath()).build();
            recordStore.saveRecord(m4);
        }
        catch (RecordCoreException | SQLException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public RelationalResultSet listDatabases(@Nonnull Transaction txn, @Nonnull Continuation continuation) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        Tuple key = Tuple.from(1L);
        RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), continuation.getExecutionState(), ScanProperties.FORWARD_SCAN);
        Descriptors.Descriptor d = recordStore.getRecordMetaData().getRecordMetaData().getRecordType("DATABASES").getDescriptor();
        return new RecordLayerResultSet(RecordLayerStoreCatalog.getMetaData(d), RecordLayerIterator.create(cursor, this::transformDatabaseInfo), null);
    }

    @Override
    public RelationalResultSet listSchemas(@Nonnull Transaction txn, @Nonnull Continuation continuation) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        Tuple key = Tuple.from(0L);
        RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), continuation.getExecutionState(), ScanProperties.FORWARD_SCAN);
        Descriptors.Descriptor schemaDesc = recordStore.getRecordMetaData().getRecordMetaData().getRecordType("SCHEMAS").getDescriptor();
        return new RecordLayerResultSet(RecordLayerStoreCatalog.getMetaData(schemaDesc), RecordLayerIterator.create(cursor, this::transformSchema), null);
    }

    @Override
    public RelationalResultSet listSchemas(@Nonnull Transaction txn, @Nonnull URI databaseId, @Nonnull Continuation continuation) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        Tuple key = Tuple.from(0L, databaseId.getPath());
        RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), continuation.getExecutionState(), ScanProperties.FORWARD_SCAN);
        Descriptors.Descriptor schemaDesc = recordStore.getRecordMetaData().getRecordMetaData().getRecordType("SCHEMAS").getDescriptor();
        return new RecordLayerResultSet(RecordLayerStoreCatalog.getMetaData(schemaDesc), RecordLayerIterator.create(cursor, this::transformSchema), null);
    }

    @Override
    public void deleteSchema(@Nonnull Transaction txn, @Nonnull URI dbUri, @Nonnull String schemaName) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        try {
            Tuple primaryKey = this.getSchemaKey(dbUri, schemaName);
            Assert.that(recordStore.deleteRecord(primaryKey), ErrorCode.UNDEFINED_SCHEMA, "Schema " + dbUri.getPath() + "/" + schemaName + " does not exist");
        }
        catch (RecordCoreException rce) {
            throw ExceptionUtil.toRelationalException(rce);
        }
    }

    @Override
    public boolean doesDatabaseExist(@Nonnull Transaction txn, @Nonnull URI databaseId) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        return this.doesDatabaseExist(recordStore, databaseId);
    }

    private boolean doesDatabaseExist(@Nonnull FDBRecordStoreBase<Message> recordStore, @Nonnull URI databaseId) throws RelationalException {
        try {
            String dbId = databaseId.getPath();
            return recordStore.loadRecord(Tuple.from(1L, dbId)) != null;
        }
        catch (RecordCoreException rce) {
            throw ExceptionUtil.toRelationalException(rce);
        }
    }

    @Override
    public boolean doesSchemaExist(@Nonnull Transaction txn, @Nonnull URI dbUri, @Nonnull String schemaName) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        try {
            Tuple primaryKey = this.getSchemaKey(dbUri, schemaName);
            return recordStore.loadRecord(primaryKey) != null;
        }
        catch (RecordCoreException rce) {
            throw ExceptionUtil.toRelationalException(rce);
        }
    }

    @Override
    public boolean deleteDatabase(@Nonnull Transaction txn, @Nonnull URI dbUrl, boolean throwIfDoesNotExist) throws RelationalException {
        block5: {
            FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
            try {
                String dbId = dbUrl.getPath();
                boolean allSchemasDeleted = this.deleteSchemas(recordStore, URI.create(dbId));
                if (allSchemasDeleted) {
                    if (!recordStore.deleteRecord(Tuple.from(1L, dbId)) && throwIfDoesNotExist) {
                        throw new RelationalException("Cannot delete unknown database: " + String.valueOf(dbUrl), ErrorCode.UNKNOWN_DATABASE);
                    }
                    break block5;
                }
                return false;
            }
            catch (RecordCoreException rce) {
                RelationalException relationalException = ExceptionUtil.toRelationalException(rce);
                if (relationalException.getErrorCode() == ErrorCode.TRANSACTION_INACTIVE || relationalException.getErrorCode() == ErrorCode.TRANSACTION_TIMEOUT) {
                    return false;
                }
                throw ExceptionUtil.toRelationalException(rce);
            }
        }
        return true;
    }

    private boolean deleteSchemas(@Nonnull FDBRecordStoreBase<Message> recordStore, @Nonnull URI dbUri) throws RelationalException {
        Tuple key = Tuple.from(0L, dbUri.getPath());
        try (RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), ContinuationImpl.BEGIN.getExecutionState(), ScanProperties.FORWARD_SCAN);){
            RecordCursorResult<FDBStoredRecord<Message>> cursorResult;
            do {
                if ((cursorResult = cursor.getNext()).getContinuation().isEnd()) {
                    break;
                }
                Tuple primaryKey = Objects.requireNonNull(cursorResult.get()).getPrimaryKey();
                recordStore.deleteRecord(primaryKey);
            } while (cursorResult.hasNext());
        }
        catch (RecordCoreStorageException ex) {
            RelationalException relationalException = ExceptionUtil.toRelationalException(ex);
            if (relationalException.getErrorCode() == ErrorCode.TRANSACTION_INACTIVE || relationalException.getErrorCode() == ErrorCode.TRANSACTION_TIMEOUT) {
                return false;
            }
            throw ExceptionUtil.toRelationalException(ex);
        }
        return true;
    }

    private void putSchema(@Nonnull RecordLayerSchema schema, @Nonnull FDBRecordStoreBase<Message> recordStore) throws RelationalException {
        try {
            ProtobufDataBuilder pmd = new ProtobufDataBuilder(this.catalogRecordMetaDataProvider.getRecordMetaData().getRecordType("SCHEMAS").getDescriptor());
            Message m4 = pmd.setField("DATABASE_ID", (Object)schema.getDatabaseName()).setField("SCHEMA_NAME", (Object)schema.getName()).setField("TEMPLATE_NAME", (Object)schema.getSchemaTemplate().getName()).setField("TEMPLATE_VERSION", (Object)schema.getSchemaTemplate().getVersion()).build();
            recordStore.saveRecord(m4);
        }
        catch (RecordCoreException | SQLException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    private static StructMetaData getMetaData(Descriptors.Descriptor descriptor) throws RelationalException {
        return RelationalStructMetaData.of((DataType.StructType)DataTypeUtils.toRelationalType(ProtobufDdlUtil.recordFromDescriptor(descriptor)));
    }

    @Nonnull
    private Tuple getSchemaKey(@Nonnull URI databaseId, @Nonnull String schemaName) {
        return Tuple.from(0L, databaseId.getPath(), schemaName);
    }

    @Nullable
    private Row transformSchema(@Nullable FDBStoredRecord<Message> record) {
        if (record == null) {
            return null;
        }
        Message m4 = record.getRecord();
        RecordMetaData recordMetaData = this.catalogRecordMetaDataProvider.getRecordMetaData();
        RecordType schemaTableMD = recordMetaData.getRecordType("SCHEMAS");
        Descriptors.Descriptor descriptor = schemaTableMD.getDescriptor();
        String dbId = (String)m4.getField(descriptor.findFieldByName("DATABASE_ID"));
        String schemaName = (String)m4.getField(descriptor.findFieldByName("SCHEMA_NAME"));
        String templateName = (String)m4.getField(descriptor.findFieldByName("TEMPLATE_NAME"));
        Integer version = (Integer)m4.getField(descriptor.findFieldByName("TEMPLATE_VERSION"));
        return new ArrayRow(dbId, schemaName, templateName, version);
    }

    private Row transformDatabaseInfo(FDBStoredRecord<Message> record) {
        return new MessageTuple(record.getRecord());
    }

    private RecordLayerSchema parseSchemaTable(Message m4, Transaction txn) throws RelationalException {
        RecordMetaData recordMetaData = this.catalogRecordMetaDataProvider.getRecordMetaData();
        RecordType schemaTableMD = recordMetaData.getRecordType("SCHEMAS");
        Descriptors.Descriptor descriptor = schemaTableMD.getDescriptor();
        String dbId = (String)m4.getField(descriptor.findFieldByName("DATABASE_ID"));
        String schemaName = (String)m4.getField(descriptor.findFieldByName("SCHEMA_NAME"));
        String templateName = (String)m4.getField(descriptor.findFieldByName("TEMPLATE_NAME"));
        Integer version = (Integer)m4.getField(descriptor.findFieldByName("TEMPLATE_VERSION"));
        SchemaTemplate template = this.schemaTemplateCatalog.loadSchemaTemplate(txn, templateName, version);
        return (RecordLayerSchema)template.generateSchema(dbId, schemaName);
    }

    static {
        ExtensionRegistry defaultExtensionRegistry = ExtensionRegistry.newInstance();
        RecordMetaDataOptionsProto.registerAllExtensions(defaultExtensionRegistry);
    }
}

