/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog;

import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.RecordAlreadyExistsException;
import com.apple.foundationdb.relational.api.ProtobufDataBuilder;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.SchemaTemplateCatalog;
import com.apple.foundationdb.relational.api.ddl.ProtobufDdlUtil;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.RecordLayerIterator;
import com.apple.foundationdb.relational.recordlayer.RecordLayerResultSet;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordLayerStoreUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RecordLayerStoreSchemaTemplateCatalog
implements SchemaTemplateCatalog {
    @Nonnull
    private final RecordLayerSchema catalogSchema;
    @Nonnull
    private final RelationalKeyspaceProvider.RelationalSchemaPath catalogSchemaPath;
    @Nonnull
    private final RecordMetaDataProvider catalogRecordMetaDataProvider;

    @SpotBugsSuppressWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Hard to remove exception with current inheritance")
    RecordLayerStoreSchemaTemplateCatalog(@Nonnull RecordLayerSchema catalogSchema, @Nonnull RelationalKeyspaceProvider.RelationalSchemaPath catalogSchemaPath) throws RelationalException {
        this.catalogSchema = catalogSchema;
        this.catalogSchemaPath = catalogSchemaPath;
        this.catalogRecordMetaDataProvider = RecordMetaData.build(this.catalogSchema.getSchemaTemplate().unwrap(RecordLayerSchemaTemplate.class).toRecordMetadata().toProto());
    }

    @Override
    public boolean doesSchemaTemplateExist(@Nonnull Transaction txn, @Nonnull String schemaTemplateName) throws RelationalException {
        Tuple key = RecordLayerStoreSchemaTemplateCatalog.getSchemaTemplatePrimaryKey(schemaTemplateName);
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), ContinuationImpl.BEGIN.getExecutionState(), ScanProperties.REVERSE_SCAN);
        try {
            boolean bl;
            RecordCursorResult<FDBStoredRecord<Message>> cursorResult = cursor.getNext();
            boolean bl2 = bl = cursorResult != null && !cursorResult.getContinuation().isEnd() && cursorResult.get() != null;
            if (cursor != null) {
                cursor.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RecordCoreStorageException e) {
                throw new UncheckedRelationalException(ExceptionUtil.toRelationalException(e));
            }
        }
    }

    @Override
    public boolean doesSchemaTemplateExist(@Nonnull Transaction txn, @Nonnull String schemaTemplateName, int version) throws RelationalException {
        if (schemaTemplateName.equals(this.catalogSchema.getSchemaTemplate().getName()) && version == this.catalogSchema.getSchemaTemplate().getVersion()) {
            return true;
        }
        try {
            FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
            return recordStore.loadRecord(RecordLayerStoreSchemaTemplateCatalog.getSchemaTemplatePrimaryKey(schemaTemplateName, version)) != null;
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    private static Tuple getSchemaTemplatePrimaryKey(String schemaTemplateName, int version) {
        return Tuple.from(2L, schemaTemplateName, version);
    }

    private static Tuple getSchemaTemplatePrimaryKey(String schemaTemplateName) {
        return Tuple.from(2L, schemaTemplateName);
    }

    @Override
    @Nonnull
    public SchemaTemplate loadSchemaTemplate(@Nonnull Transaction txn, @Nonnull String templateName) throws RelationalException {
        Tuple key = RecordLayerStoreSchemaTemplateCatalog.getSchemaTemplatePrimaryKey(templateName);
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        TupleRange tupleRange = new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE);
        RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(tupleRange, ContinuationImpl.BEGIN.getExecutionState(), ScanProperties.REVERSE_SCAN);
        try {
            RecordCursorResult<FDBStoredRecord<Message>> cursorResult = cursor.getNext();
            boolean schemaExists = !cursorResult.getContinuation().isEnd() && cursorResult.get() != null;
            Assert.thatUnchecked(schemaExists, ErrorCode.UNKNOWN_SCHEMA_TEMPLATE, "SchemaTemplate '" + templateName + "' is not in catalog");
            SchemaTemplate schemaTemplate = RecordLayerStoreSchemaTemplateCatalog.toSchemaTemplate(Assert.notNullUnchecked(cursorResult.get()).getRecord());
            if (cursor != null) {
                cursor.close();
            }
            return schemaTemplate;
        }
        catch (Throwable throwable) {
            try {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RecordCoreStorageException | InvalidProtocolBufferException e) {
                throw new UncheckedRelationalException(ExceptionUtil.toRelationalException(e));
            }
        }
    }

    @Override
    @Nonnull
    public SchemaTemplate loadSchemaTemplate(@Nonnull Transaction txn, @Nonnull String templateName, int version) throws RelationalException {
        try {
            FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
            FDBStoredRecord<Message> fdbSR = recordStore.loadRecord(RecordLayerStoreSchemaTemplateCatalog.getSchemaTemplatePrimaryKey(templateName, version));
            if (fdbSR == null) {
                throw new RelationalException("SchemaTemplate=" + templateName + ", version=" + version + " is not in catalog", ErrorCode.UNKNOWN_SCHEMA_TEMPLATE);
            }
            return RecordLayerStoreSchemaTemplateCatalog.toSchemaTemplate(fdbSR.getRecord());
        }
        catch (RecordCoreException | InvalidProtocolBufferException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    @Nonnull
    private static SchemaTemplate toSchemaTemplate(@Nonnull Message message) throws InvalidProtocolBufferException {
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        ByteString bs = Assert.castUnchecked(message.getField(descriptor.findFieldByName("META_DATA")), ByteString.class);
        RecordMetaData metaData = RecordMetaData.build(RecordMetaDataProto.MetaData.parseFrom(bs.toByteArray()));
        String name = message.getField(descriptor.findFieldByName("TEMPLATE_NAME")).toString();
        int templateVersion = (Integer)message.getField(descriptor.findFieldByName("TEMPLATE_VERSION"));
        return RecordLayerSchemaTemplate.fromRecordMetadata(metaData, name, templateVersion);
    }

    @Override
    public void createTemplate(@Nonnull Transaction txn, @Nonnull SchemaTemplate newTemplate) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        Assert.notNull(recordStore);
        try {
            ProtobufDataBuilder pmd = new ProtobufDataBuilder(this.catalogRecordMetaDataProvider.getRecordMetaData().getRecordType("TEMPLATES").getDescriptor());
            pmd.setField("TEMPLATE_NAME", (Object)newTemplate.getName());
            pmd.setField("TEMPLATE_VERSION", (Object)newTemplate.getVersion());
            RecordMetaData metaData = newTemplate.unwrap(RecordLayerSchemaTemplate.class).toRecordMetadata();
            pmd.setField("META_DATA", (Object)metaData.toProto().toByteString());
            recordStore.saveRecord(pmd.build(), FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_EXISTS);
        }
        catch (RecordAlreadyExistsException e) {
            throw new RelationalException("Schema template already exists: " + newTemplate.getName(), ErrorCode.DUPLICATE_SCHEMA_TEMPLATE, e);
        }
        catch (RecordCoreException | SQLException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    @Override
    public RelationalResultSet listTemplates(@Nonnull Transaction txn) {
        Tuple key = Tuple.from(2L);
        try {
            FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
            RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), ContinuationImpl.BEGIN.getExecutionState(), ScanProperties.FORWARD_SCAN);
            Descriptors.Descriptor d = recordStore.getRecordMetaData().getRecordMetaData().getRecordType("TEMPLATES").getDescriptor();
            RelationalStructMetaData structMetaData = RelationalStructMetaData.of((DataType.StructType)DataTypeUtils.toRelationalType(ProtobufDdlUtil.recordFromDescriptor(d)));
            return new RecordLayerResultSet(structMetaData, RecordLayerIterator.create(cursor, this::transformSchemaTemplates), null);
        }
        catch (RecordCoreStorageException | RelationalException e) {
            throw new UncheckedRelationalException(ExceptionUtil.toRelationalException(e));
        }
    }

    private Row transformSchemaTemplates(@Nullable FDBStoredRecord<Message> record) {
        if (record == null) {
            return null;
        }
        Message m4 = record.getRecord();
        RecordMetaData recordMetaData = this.catalogRecordMetaDataProvider.getRecordMetaData();
        RecordType recordType = recordMetaData.getRecordType("TEMPLATES");
        Descriptors.Descriptor descriptor = recordType.getDescriptor();
        String name = (String)m4.getField(descriptor.findFieldByName("TEMPLATE_NAME"));
        Integer version = (Integer)m4.getField(descriptor.findFieldByName("TEMPLATE_VERSION"));
        ByteString metaData = (ByteString)m4.getField(descriptor.findFieldByName("META_DATA"));
        return new ArrayRow(name, version, metaData.toByteArray());
    }

    @Override
    public void deleteTemplate(@Nonnull Transaction txn, @Nonnull String templateName, boolean throwIfDoesNotExist) throws RelationalException {
        Tuple key = RecordLayerStoreSchemaTemplateCatalog.getSchemaTemplatePrimaryKey(templateName);
        try {
            FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
            try (RecordCursor<FDBStoredRecord<Message>> cursor = recordStore.scanRecords(new TupleRange(key, key, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE), ContinuationImpl.BEGIN.getExecutionState(), ScanProperties.FORWARD_SCAN);){
                RecordCursorResult<FDBStoredRecord<Message>> cursorResult;
                boolean deletedSomething = false;
                while (!(cursorResult = cursor.getNext()).getContinuation().isEnd()) {
                    Tuple primaryKey = Objects.requireNonNull(cursorResult.get()).getPrimaryKey();
                    if (!recordStore.deleteRecord(primaryKey)) {
                        throw new RelationalException("Schema template record should exist but didn't when trying to delete it", ErrorCode.INTERNAL_ERROR);
                    }
                    deletedSomething = true;
                    if (cursorResult.hasNext()) continue;
                }
                if (!deletedSomething && throwIfDoesNotExist) {
                    throw new RelationalException("Could not delete unknown schema template " + templateName, ErrorCode.UNKNOWN_SCHEMA_TEMPLATE);
                }
            }
        }
        catch (RecordCoreStorageException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    @Override
    public void deleteTemplate(@Nonnull Transaction txn, @Nonnull String templateName, int version, boolean throwIfDoesNotExist) throws RelationalException {
        FDBRecordStoreBase<Message> recordStore = RecordLayerStoreUtils.openRecordStore(txn, this.catalogSchemaPath, this.catalogRecordMetaDataProvider);
        if (!recordStore.deleteRecord(RecordLayerStoreSchemaTemplateCatalog.getSchemaTemplatePrimaryKey(templateName, version)) && throwIfDoesNotExist) {
            throw new RelationalException("Could not delete unknown schema template " + templateName, ErrorCode.UNKNOWN_SCHEMA_TEMPLATE);
        }
    }
}

