/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.NoOpSchemaTemplateCatalog;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.exceptions.OperationUnsupportedException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordLayerStoreCatalog;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class StoreCatalogProvider {
    public static StoreCatalog getCatalog(@Nonnull Transaction txn, @Nonnull KeySpace keySpace) throws RelationalException {
        return new RecordLayerStoreCatalog(keySpace).initialize(txn);
    }

    public static StoreCatalog getCatalogWithNoTemplateOperations(Transaction txn) throws RelationalException {
        RecordLayerStoreCatalog storeCatalog = new RecordLayerStoreCatalog(RelationalKeyspaceProvider.instance().getKeySpace()){

            @Override
            public void repairSchema(@Nonnull Transaction txn, @Nonnull String databaseId, @Nonnull String schemaName) throws RelationalException {
                throw new OperationUnsupportedException("This store catalog does not support repairing schema.");
            }
        };
        return storeCatalog.initialize(txn, new NoOpSchemaTemplateCatalog());
    }
}

