/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.ddl.NoOpQueryFactory;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.AbstractDatabase;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.HollowTransactionManager;
import com.apple.foundationdb.relational.recordlayer.RecordStoreAndRecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.ddl.AbstractMetadataOperationsFactory;
import com.apple.foundationdb.relational.recordlayer.ddl.CreateTemporaryFunctionConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.DropTemporaryFunctionConstantAction;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.recordlayer.storage.BackingRecordStore;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import com.apple.foundationdb.relational.transactionbound.catalog.HollowStoreCatalog;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TransactionBoundDatabase
extends AbstractDatabase {
    BackingStore store;
    URI uri;
    private static final MetadataOperationsFactory onlyTemporaryFunctionOperationsFactory = new AbstractMetadataOperationsFactory(){

        @Override
        @Nonnull
        public ConstantAction getCreateTemporaryFunctionConstantAction(@Nonnull SchemaTemplate template, boolean throwIfExists, @Nonnull RecordLayerInvokedRoutine invokedRoutine, @Nonnull PreparedParams preparedParams) {
            return new CreateTemporaryFunctionConstantAction(template, throwIfExists, invokedRoutine, preparedParams);
        }

        @Override
        @Nonnull
        public ConstantAction getDropTemporaryFunctionConstantAction(boolean throwIfNotExists, @Nonnull String temporaryFunctionName) {
            return new DropTemporaryFunctionConstantAction(throwIfNotExists, temporaryFunctionName);
        }
    };

    public TransactionBoundDatabase(URI uri, @Nonnull Options options, @Nullable RelationalPlanCache planCache) {
        super(onlyTemporaryFunctionOperationsFactory, NoOpQueryFactory.INSTANCE, planCache, options);
        this.uri = uri;
    }

    @Override
    public RelationalConnection connect(@Nullable Transaction transaction) throws RelationalException {
        if (!(transaction instanceof RecordStoreAndRecordContextTransaction)) {
            throw new RelationalException("TransactionBoundDatabase.connect expects a RecordStoreAndRecordContextTransaction", ErrorCode.UNABLE_TO_ESTABLISH_SQL_CONNECTION);
        }
        RecordStoreAndRecordContextTransaction recordStoreAndRecordContextTx = transaction.unwrap(RecordStoreAndRecordContextTransaction.class);
        this.store = BackingRecordStore.fromTransactionWithStore(recordStoreAndRecordContextTx);
        SchemaTemplate boundSchemaTemplate = recordStoreAndRecordContextTx.getBoundSchemaTemplate();
        EmbeddedRelationalConnection connection = new EmbeddedRelationalConnection(this, new HollowStoreCatalog(boundSchemaTemplate), ((RecordStoreAndRecordContextTransaction)transaction).getRecordContextTransaction(), this.options);
        this.setConnection(connection);
        return connection;
    }

    @Override
    public BackingStore loadRecordStore(@Nonnull String schemaId, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        return this.store;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return HollowTransactionManager.INSTANCE;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void close() throws RelationalException {
    }
}

