/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog.systables;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.SystemTable;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerColumn;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class SchemaSystemTable
implements SystemTable {
    public static final String TABLE_NAME = "SCHEMAS";
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    private static final RecordLayerIndex TEMPLATES_COUNT_INDEX = RecordLayerIndex.newBuilder().setName("TEMPLATES_COUNT_INDEX").setTableName("SCHEMAS").setIndexType("count").setKeyExpression(new GroupingKeyExpression(Key.Expressions.concat(Key.Expressions.field("TEMPLATE_NAME"), Key.Expressions.field("TEMPLATE_VERSION"), new KeyExpression[0]), 0)).build();
    private static final RecordLayerIndex TEMPLATES_VALUE_INDEX = RecordLayerIndex.newBuilder().setName("TEMPLATES_VALUE_INDEX").setTableName("SCHEMAS").setIndexType("value").setKeyExpression(Key.Expressions.concat(Key.Expressions.field("TEMPLATE_NAME"), Key.Expressions.field("TEMPLATE_VERSION"), Key.Expressions.field("DATABASE_ID"), Key.Expressions.field("SCHEMA_NAME"))).build();

    @Override
    @Nonnull
    public String getName() {
        return TABLE_NAME;
    }

    @Override
    public void addDefinition(@Nonnull RecordLayerSchemaTemplate.Builder schemaBuilder) {
        schemaBuilder.addTable(this.getType());
    }

    @Override
    public RecordLayerTable getType() {
        return RecordLayerTable.newBuilder(false).setName(TABLE_NAME).addColumn(RecordLayerColumn.newBuilder().setName("DATABASE_ID").setDataType(DataType.Primitives.STRING.type()).build()).addColumn(RecordLayerColumn.newBuilder().setName(SCHEMA_NAME).setDataType(DataType.Primitives.STRING.type()).build()).addColumn(RecordLayerColumn.newBuilder().setName("TEMPLATE_NAME").setDataType(DataType.Primitives.STRING.type()).build()).addColumn(RecordLayerColumn.newBuilder().setName("TEMPLATE_VERSION").setDataType(DataType.Primitives.INTEGER.type()).build()).addPrimaryKeyPart(List.of("DATABASE_ID")).addPrimaryKeyPart(List.of(SCHEMA_NAME)).addIndex(TEMPLATES_COUNT_INDEX).addIndex(TEMPLATES_VALUE_INDEX).build();
    }

    @Override
    @Nonnull
    public KeyExpression getPrimaryKeyDefinition() {
        return Key.Expressions.concat(Key.Expressions.recordType(), Key.Expressions.concatenateFields("DATABASE_ID", SCHEMA_NAME, new String[0]), new KeyExpression[0]);
    }
}

