/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.catalog.systables;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.DatabaseInfoSystemTable;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.SchemaSystemTable;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.SchemaTemplateSystemTable;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.SystemTable;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class SystemTableRegistry {
    public static final long SCHEMA_RECORD_TYPE_KEY = 0L;
    public static final long DATABASE_INFO_RECORD_TYPE_KEY = 1L;
    public static final long SCHEMA_TEMPLATE_RECORD_TYPE_KEY = 2L;
    public static final String SCHEMAS_TABLE_NAME = "SCHEMAS";
    public static final String DATABASE_TABLE_NAME = "DATABASES";
    public static final String SCHEMA_TEMPLATE_TABLE_NAME = "TEMPLATES";
    @Nonnull
    private static final Map<String, SystemTable> tablesMap = Map.of("SCHEMAS", new SchemaSystemTable(), "DATABASES", new DatabaseInfoSystemTable(), "TEMPLATES", new SchemaTemplateSystemTable());

    @Nonnull
    public static SystemTable getSystemTable(String key) {
        SystemTable systemTable = tablesMap.get(key);
        if (systemTable == null) {
            throw new IllegalStateException("Programmer error: missing system table named <" + key + ">");
        }
        return systemTable;
    }

    private SystemTableRegistry() {
    }
}

