/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import java.net.URI;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class CreateDatabaseConstantAction
implements ConstantAction {
    private final URI dbUrl;
    private final StoreCatalog storeCatalog;
    private final KeySpace keySpace;

    public CreateDatabaseConstantAction(@Nonnull URI dbUrl, @Nonnull StoreCatalog storeCatalog, @Nonnull KeySpace keySpace) {
        this.dbUrl = dbUrl;
        this.storeCatalog = storeCatalog;
        this.keySpace = keySpace;
    }

    @Override
    public void execute(Transaction txn) throws RelationalException {
        RelationalKeyspaceProvider.toDatabasePath(this.dbUrl, this.keySpace);
        if (this.storeCatalog.doesDatabaseExist(txn, this.dbUrl)) {
            throw new RelationalException("Database " + String.valueOf(this.dbUrl) + " already exists", ErrorCode.DATABASE_ALREADY_EXISTS);
        }
        this.storeCatalog.createDatabase(txn, this.dbUrl);
    }
}

