/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.serde.RoutineParser;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.util.Assert;
import javax.annotation.Nonnull;

public class CreateTemporaryFunctionConstantAction
implements ConstantAction {
    @Nonnull
    private final RecordLayerInvokedRoutine invokedRoutine;
    private final boolean throwIfExists;
    @Nonnull
    private final SchemaTemplate template;
    @Nonnull
    private final PreparedParams preparedParams;

    public CreateTemporaryFunctionConstantAction(@Nonnull SchemaTemplate template, boolean throwIfExists, @Nonnull RecordLayerInvokedRoutine invokedRoutine, @Nonnull PreparedParams preparedParams) {
        this.template = template;
        this.throwIfExists = throwIfExists;
        this.invokedRoutine = invokedRoutine;
        this.preparedParams = preparedParams;
    }

    @Override
    public void execute(@Nonnull Transaction txn) throws RelationalException {
        RecordLayerSchemaTemplate transactionBoundSchemaTemplate = Assert.castUnchecked(txn.getBoundSchemaTemplateMaybe().orElse(this.template), RecordLayerSchemaTemplate.class);
        if (this.throwIfExists) {
            Assert.thatUnchecked(transactionBoundSchemaTemplate.getInvokedRoutines().stream().noneMatch(r -> r.getName().equals(this.invokedRoutine.getName())), ErrorCode.DUPLICATE_FUNCTION, () -> "function '" + this.invokedRoutine.getName() + "' already exists");
        }
        RecordLayerInvokedRoutine.Builder routineBuilder = this.invokedRoutine.toBuilder();
        routineBuilder.withCompilableRoutine(isCaseSensitive -> RoutineParser.sqlFunctionParser(transactionBoundSchemaTemplate).parseTemporaryFunction(this.invokedRoutine.getName(), this.invokedRoutine.getDescription(), PreparedParams.copyOf(this.preparedParams), (boolean)isCaseSensitive));
        RecordLayerSchemaTemplate schemaTemplateWithTempFunction = transactionBoundSchemaTemplate.toBuilder().replaceInvokedRoutine(routineBuilder.build()).build();
        txn.setBoundSchemaTemplate(schemaTemplateWithTempFunction);
    }
}

