/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import java.net.URI;
import java.sql.SQLException;

@API(value=API.Status.EXPERIMENTAL)
public class DropDatabaseConstantAction
implements ConstantAction {
    private final URI dbUrl;
    private final boolean throwIfDoesNotExist;
    private final Options options;
    private final StoreCatalog catalog;
    private final MetadataOperationsFactory metadataOperationsFactory;

    public DropDatabaseConstantAction(URI dbUrl, boolean throwIfDoesNotExist, StoreCatalog catalog, MetadataOperationsFactory metadataOperationsFactory, Options options) {
        this.dbUrl = dbUrl;
        this.throwIfDoesNotExist = throwIfDoesNotExist;
        this.options = options;
        this.metadataOperationsFactory = metadataOperationsFactory;
        this.catalog = catalog;
    }

    @Override
    public void execute(Transaction txn) throws RelationalException {
        if ("/__SYS".equals(this.dbUrl.getPath())) {
            throw new RelationalException("Cannot drop /__SYS database", ErrorCode.INSUFFICIENT_PRIVILEGE);
        }
        try (RelationalResultSet schemas = this.catalog.listSchemas(txn, this.dbUrl, ContinuationImpl.BEGIN);){
            while (schemas.next()) {
                String schemaName = schemas.getString("SCHEMA_NAME");
                this.metadataOperationsFactory.getDropSchemaConstantAction(this.dbUrl, schemaName, this.options).execute(txn);
            }
        }
        catch (SQLException se) {
            ErrorCode ec = ErrorCode.get(se.getSQLState());
            throw new RelationalException(se.getMessage(), ec, se);
        }
        this.catalog.deleteDatabase(txn, this.dbUrl, this.throwIfDoesNotExist);
    }
}

