/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import java.net.URI;

@API(value=API.Status.EXPERIMENTAL)
public class DropSchemaConstantAction
implements ConstantAction {
    private final URI dbUri;
    private final String schemaName;
    private final KeySpace keySpace;
    private final StoreCatalog catalog;

    public DropSchemaConstantAction(URI dbUri, String schemaName, KeySpace keySpace, StoreCatalog storeCatalog) {
        this.dbUri = dbUri;
        this.schemaName = schemaName;
        this.catalog = storeCatalog;
        this.keySpace = keySpace;
    }

    @Override
    public void execute(Transaction txn) throws RelationalException {
        if ("/__SYS".equals(this.dbUri.getPath())) {
            throw new RelationalException("Cannot drop /__SYS schemas", ErrorCode.INSUFFICIENT_PRIVILEGE);
        }
        FDBRecordContext ctx = txn.unwrap(FDBRecordContext.class);
        try {
            FDBRecordStore.deleteStore(ctx, RelationalKeyspaceProvider.toDatabasePath(this.dbUri, this.keySpace).schemaPath(this.schemaName));
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
        this.catalog.deleteSchema(txn, this.dbUri, this.schemaName);
    }
}

