/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.util.Assert;
import java.util.Optional;
import javax.annotation.Nonnull;

public class DropTemporaryFunctionConstantAction
implements ConstantAction {
    private final boolean throwIfNotExists;
    @Nonnull
    private final String temporaryFunctionName;

    public DropTemporaryFunctionConstantAction(boolean throwIfNotExists, @Nonnull String temporaryFunctionName) {
        this.throwIfNotExists = throwIfNotExists;
        this.temporaryFunctionName = temporaryFunctionName;
    }

    @Override
    public void execute(Transaction txn) throws RelationalException {
        RecordLayerSchemaTemplate relationalLayerSchemaTemplate;
        Optional<RecordLayerInvokedRoutine> maybeInvokedRoutine;
        Optional<SchemaTemplate> transactionBoundSchemaTemplate = txn.getBoundSchemaTemplateMaybe();
        if (transactionBoundSchemaTemplate.isPresent() && (maybeInvokedRoutine = (relationalLayerSchemaTemplate = Assert.castUnchecked(transactionBoundSchemaTemplate.orElseThrow(), RecordLayerSchemaTemplate.class)).getInvokedRoutines().stream().filter(r -> r.getName().equals(this.temporaryFunctionName)).findFirst()).isPresent()) {
            Assert.thatUnchecked(maybeInvokedRoutine.orElseThrow().isTemporary(), ErrorCode.INVALID_FUNCTION_DEFINITION, "Attempt to DROP an non-temporary function: " + this.temporaryFunctionName);
            RecordLayerSchemaTemplate schemaTemplateWithoutTempFunction = relationalLayerSchemaTemplate.toBuilder().removeInvokedRoutine(this.temporaryFunctionName).build();
            txn.setBoundSchemaTemplate(schemaTemplateWithoutTempFunction);
            return;
        }
        Assert.thatUnchecked(!this.throwIfNotExists, ErrorCode.UNDEFINED_FUNCTION, "Attempt to DROP an undefined temporary function: " + this.temporaryFunctionName);
    }
}

