/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.ImmutableRowStruct;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.CatalogQueryFactory;
import com.apple.foundationdb.relational.api.ddl.DdlQuery;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.Column;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.Metadata;
import com.apple.foundationdb.relational.api.metadata.Schema;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.IteratorResultSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerCatalogQueryFactory
extends CatalogQueryFactory {
    public RecordLayerCatalogQueryFactory(StoreCatalog catalog) {
        super(catalog);
    }

    @Override
    public DdlQuery getDescribeSchemaQueryAction(final @Nonnull URI dbId, final @Nonnull String schemaId) {
        return new DdlQuery(){

            @Override
            @Nonnull
            public Type getResultSetMetadata() {
                return DdlQuery.constructTypeFrom(List.of("DATABASE_PATH", "SCHEMA_NAME", "TABLES", "INDEXES"));
            }

            @Override
            public RelationalResultSet executeAction(Transaction txn) throws RelationalException {
                Schema schema = RecordLayerCatalogQueryFactory.this.catalog.loadSchema(txn, dbId, schemaId);
                List tableNames = schema.getTables().stream().map(Metadata::getName).collect(Collectors.toList());
                List indexNames = schema.getTables().stream().flatMap(t2 -> t2.getIndexes().stream()).map(Metadata::getName).collect(Collectors.toList());
                ArrayRow tuple = new ArrayRow(schema.getDatabaseName(), schema.getName(), tableNames, indexNames);
                DataType.StructType describeSchemaStructType = DataType.StructType.from("DESCRIBE_SCHEMA", List.of(DataType.StructType.Field.from("DATABASE_PATH", DataType.Primitives.STRING.type(), 0), DataType.StructType.Field.from("SCHEMA_NAME", DataType.Primitives.NULLABLE_STRING.type(), 1), DataType.StructType.Field.from("TABLES", DataType.ArrayType.from(DataType.Primitives.STRING.type()), 2), DataType.StructType.Field.from("INDEXES", DataType.ArrayType.from(DataType.Primitives.STRING.type()), 3)), true);
                return new IteratorResultSet(RelationalStructMetaData.of(describeSchemaStructType), Collections.singleton(tuple).iterator(), 0);
            }
        };
    }

    @Override
    public DdlQuery getDescribeSchemaTemplateQueryAction(final @Nonnull String schemaId) {
        return new DdlQuery(){

            @Override
            @Nonnull
            public Type getResultSetMetadata() {
                return DdlQuery.constructTypeFrom(List.of("TEMPLATE_NAME", "TABLES"));
            }

            @Override
            public RelationalResultSet executeAction(Transaction txn) throws RelationalException {
                SchemaTemplate schemaTemplate = RecordLayerCatalogQueryFactory.this.catalog.getSchemaTemplateCatalog().loadSchemaTemplate(txn, schemaId);
                DataType.StructType columnType = DataType.StructType.from("COLUMN", List.of(DataType.StructType.Field.from("COLUMN_NAME", DataType.Primitives.STRING.type(), 0), DataType.StructType.Field.from("COLUMN_TYPE", DataType.Primitives.INTEGER.type(), 1)), true);
                DataType.StructType tableType = DataType.StructType.from("TABLE", List.of(DataType.StructType.Field.from("TABLE_NAME", DataType.Primitives.STRING.type(), 0), DataType.StructType.Field.from("COLUMNS", DataType.ArrayType.from(columnType, true), 1)), true);
                DataType.StructType describeSchemaType = DataType.StructType.from("DESCRIBE_SCHEMA_TEMPLATE", List.of(DataType.StructType.Field.from("TEMPLATE_NAME", DataType.Primitives.STRING.type(), 0), DataType.StructType.Field.from("TABLES", DataType.ArrayType.from(tableType, true), 1)), true);
                ArrayList<ImmutableRowStruct> tableStructs = new ArrayList<ImmutableRowStruct>();
                for (Table table : schemaTemplate.getTables()) {
                    ArrayList<ImmutableRowStruct> columnStructs = new ArrayList<ImmutableRowStruct>();
                    for (Column column : table.getColumns()) {
                        columnStructs.add(new ImmutableRowStruct(new ArrayRow(column.getName(), column.getDataType().getJdbcSqlCode()), RelationalStructMetaData.of(columnType)));
                    }
                    tableStructs.add(new ImmutableRowStruct(new ArrayRow(table.getName(), columnStructs), RelationalStructMetaData.of(tableType)));
                }
                ArrayRow tuple = new ArrayRow(schemaTemplate.getName(), tableStructs);
                return new IteratorResultSet(RelationalStructMetaData.of(describeSchemaType), Collections.singleton(tuple).iterator(), 0);
            }
        };
    }
}

