/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreAlreadyExistsException;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.Schema;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.CatalogMetaDataProvider;
import com.apple.foundationdb.relational.recordlayer.storage.StoreConfig;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import java.net.URI;
import java.util.Locale;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerCreateSchemaConstantAction
implements ConstantAction {
    private final StoreCatalog catalog;
    private final RecordLayerConfig rlConfig;
    private final URI dbUri;
    private final String schemaName;
    private final String templateName;
    private final KeySpace keySpace;

    public RecordLayerCreateSchemaConstantAction(URI dbUri, String schemaName, String templateName, RecordLayerConfig rlConfig, KeySpace keySpace, StoreCatalog catalog) {
        this.schemaName = schemaName;
        this.templateName = templateName;
        this.catalog = catalog;
        this.dbUri = dbUri;
        this.rlConfig = rlConfig;
        this.keySpace = keySpace;
    }

    @Override
    public void execute(Transaction txn) throws RelationalException {
        if (!this.catalog.doesDatabaseExist(txn, this.dbUri)) {
            throw new RelationalException(String.format(Locale.ROOT, "Database %s does not exist", this.dbUri.getPath()), ErrorCode.UNDEFINED_DATABASE);
        }
        try {
            Schema beforeSchema = this.catalog.loadSchema(txn, this.dbUri, this.schemaName);
            String schemaTemplateName = beforeSchema.getSchemaTemplate().getName();
            throw new RelationalException("Schema " + this.schemaName + " already exists with template " + schemaTemplateName, ErrorCode.SCHEMA_ALREADY_EXISTS);
        }
        catch (RelationalException ve) {
            if (ve.getErrorCode() != ErrorCode.UNDEFINED_SCHEMA) {
                throw ve;
            }
            SchemaTemplate schemaTemplate = this.catalog.getSchemaTemplateCatalog().loadSchemaTemplate(txn, this.templateName);
            Schema schema = schemaTemplate.generateSchema(this.dbUri.getPath(), this.schemaName);
            this.catalog.saveSchema(txn, schema, false);
            RelationalKeyspaceProvider.RelationalSchemaPath databasePath = RelationalKeyspaceProvider.toDatabasePath(this.dbUri, this.keySpace).schemaPath(this.schemaName);
            try {
                ((FDBRecordStore.Builder)FDBRecordStore.newBuilder().setKeySpacePath(databasePath).setSerializer((RecordSerializer)StoreConfig.DEFAULT_RELATIONAL_SERIALIZER)).setMetaDataProvider(new CatalogMetaDataProvider(this.catalog, this.dbUri, this.schemaName, txn)).setUserVersionChecker(this.rlConfig.getUserVersionChecker()).setFormatVersion(this.rlConfig.getFormatVersion()).setContext(txn.unwrap(FDBRecordContext.class)).createOrOpen(FDBRecordStoreBase.StoreExistenceCheck.ERROR_IF_EXISTS);
            }
            catch (RecordStoreAlreadyExistsException rsaee) {
                throw new RelationalException("Schema <" + this.schemaName + "> already exists", ErrorCode.SCHEMA_ALREADY_EXISTS);
            }
            catch (RecordCoreException rce) {
                throw ExceptionUtil.toRelationalException(rce);
            }
            return;
        }
    }
}

