/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.ddl.SaveSchemaTemplateConstantAction;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.ddl.CreateDatabaseConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.CreateTemporaryFunctionConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.DropDatabaseConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.DropSchemaConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.DropTemporaryFunctionConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.RecordLayerCreateSchemaConstantAction;
import com.apple.foundationdb.relational.recordlayer.ddl.RecordLayerSetStoreStateConstantAction;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import java.net.URI;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerMetadataOperationsFactory
implements MetadataOperationsFactory {
    private final RecordLayerConfig rlConfig;
    private final StoreCatalog catalog;
    private final KeySpace baseKeySpace;

    public RecordLayerMetadataOperationsFactory(RecordLayerConfig rlConfig, StoreCatalog catalog, KeySpace baseKeySpace) {
        this.rlConfig = rlConfig;
        this.catalog = catalog;
        this.baseKeySpace = baseKeySpace;
    }

    @Override
    @Nonnull
    public ConstantAction getDropSchemaTemplateConstantAction(@Nonnull String templateId, boolean throwIfDoesNotExist, @Nonnull Options options) {
        return txn -> this.catalog.getSchemaTemplateCatalog().deleteTemplate(txn, templateId, throwIfDoesNotExist);
    }

    @Override
    @Nonnull
    public ConstantAction getSaveSchemaTemplateConstantAction(@Nonnull SchemaTemplate template, @Nonnull Options templateProperties) {
        return new SaveSchemaTemplateConstantAction(template, this.catalog.getSchemaTemplateCatalog());
    }

    @Override
    @Nonnull
    public ConstantAction getCreateDatabaseConstantAction(@Nonnull URI dbPath, @Nonnull Options constantActionOptions) {
        return new CreateDatabaseConstantAction(dbPath, this.catalog, this.baseKeySpace);
    }

    @Override
    @Nonnull
    public ConstantAction getCreateSchemaConstantAction(@Nonnull URI dbUri, @Nonnull String schemaName, @Nonnull String templateId, Options constantActionOptions) {
        return new RecordLayerCreateSchemaConstantAction(dbUri, schemaName, templateId, this.rlConfig, this.baseKeySpace, this.catalog);
    }

    @Override
    @Nonnull
    public ConstantAction getDropDatabaseConstantAction(@Nonnull URI dbUrl, boolean throwIfDoesNotExist, @Nonnull Options options) {
        return new DropDatabaseConstantAction(dbUrl, throwIfDoesNotExist, this.catalog, this, options);
    }

    @Override
    @Nonnull
    public ConstantAction getDropSchemaConstantAction(@Nonnull URI dbPath, @Nonnull String schema, @Nonnull Options options) {
        return new DropSchemaConstantAction(dbPath, schema, this.baseKeySpace, this.catalog);
    }

    @Nonnull
    public ConstantAction getSetStoreStateConstantAction(@Nonnull URI dbUri, @Nonnull String schemaName) {
        return new RecordLayerSetStoreStateConstantAction(dbUri, schemaName, this.rlConfig, this.baseKeySpace, this.catalog);
    }

    @Override
    @Nonnull
    public ConstantAction getCreateTemporaryFunctionConstantAction(@Nonnull SchemaTemplate template, boolean throwIfExists, @Nonnull RecordLayerInvokedRoutine invokedRoutine, @Nonnull PreparedParams preparedParams) {
        return new CreateTemporaryFunctionConstantAction(template, throwIfExists, invokedRoutine, preparedParams);
    }

    @Override
    @Nonnull
    public ConstantAction getDropTemporaryFunctionConstantAction(boolean throwIfNotExists, @Nonnull String temporaryFunctionName) {
        return new DropTemporaryFunctionConstantAction(throwIfNotExists, temporaryFunctionName);
    }

    public static Builder defaultFactory() {
        return new Builder();
    }

    public static class Builder {
        protected StoreCatalog storeCatalog;
        protected RecordLayerConfig rlConfig;
        protected KeySpace baseKeySpace;

        public Builder setStoreCatalog(StoreCatalog storeCatalog) {
            this.storeCatalog = storeCatalog;
            return this;
        }

        public Builder setRlConfig(RecordLayerConfig rlConfig) {
            this.rlConfig = rlConfig;
            return this;
        }

        public Builder setBaseKeySpace(KeySpace baseKeySpace) {
            this.baseKeySpace = baseKeySpace;
            return this;
        }

        public RecordLayerMetadataOperationsFactory build() {
            return new RecordLayerMetadataOperationsFactory(this.rlConfig, this.storeCatalog, this.baseKeySpace);
        }
    }
}

