/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreAlreadyExistsException;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ConstantAction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.CatalogMetaDataProvider;
import com.apple.foundationdb.relational.recordlayer.storage.StoreConfig;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import java.net.URI;
import java.util.Map;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerSetStoreStateConstantAction
implements ConstantAction {
    private final StoreCatalog catalog;
    private final RecordLayerConfig rlConfig;
    private final URI dbUri;
    private final String schemaName;
    private final KeySpace keySpace;

    public RecordLayerSetStoreStateConstantAction(URI dbUri, String schemaName, RecordLayerConfig rlConfig, KeySpace keySpace, StoreCatalog catalog) {
        this.schemaName = schemaName;
        this.catalog = catalog;
        this.dbUri = dbUri;
        this.rlConfig = rlConfig;
        this.keySpace = keySpace;
    }

    @Override
    public void execute(Transaction txn) throws RelationalException {
        RelationalKeyspaceProvider.RelationalSchemaPath databasePath = RelationalKeyspaceProvider.toDatabasePath(this.dbUri, this.keySpace).schemaPath(this.schemaName);
        try {
            FDBRecordStore recordStore = (FDBRecordStore)((FDBRecordStore.Builder)FDBRecordStore.newBuilder().setKeySpacePath(databasePath).setSerializer((RecordSerializer)StoreConfig.DEFAULT_RELATIONAL_SERIALIZER)).setMetaDataProvider(new CatalogMetaDataProvider(this.catalog, this.dbUri, this.schemaName, txn)).setContext(txn.unwrap(FDBRecordContext.class)).open();
            for (Map.Entry<String, IndexState> indexStateEntry : this.rlConfig.getIndexStateMap().entrySet()) {
                Boolean markIndex = false;
                switch (indexStateEntry.getValue()) {
                    case READABLE: {
                        markIndex = recordStore.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_ERROR_CHECK, recordStore.markIndexReadable(indexStateEntry.getKey()));
                        break;
                    }
                    case WRITE_ONLY: {
                        markIndex = recordStore.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_ERROR_CHECK, recordStore.markIndexWriteOnly(indexStateEntry.getKey()));
                        break;
                    }
                    case DISABLED: {
                        markIndex = recordStore.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_ERROR_CHECK, recordStore.markIndexDisabled(indexStateEntry.getKey()));
                        break;
                    }
                    case READABLE_UNIQUE_PENDING: {
                        markIndex = recordStore.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_ERROR_CHECK, recordStore.markIndexReadableOrUniquePending(recordStore.getRecordMetaData().getIndex(indexStateEntry.getKey())));
                        break;
                    }
                }
                assert (Boolean.TRUE.equals(markIndex));
            }
        }
        catch (RecordStoreAlreadyExistsException rsaee) {
            throw new RelationalException("Schema <" + this.schemaName + "> already exists", ErrorCode.SCHEMA_ALREADY_EXISTS);
        }
        catch (RecordCoreException rce) {
            throw ExceptionUtil.toRelationalException(rce);
        }
    }
}

