/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class DataTypeUtils {
    @Nonnull
    private static final BiMap<DataType, Type> primitivesMap = HashBiMap.create();

    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="should never happen, there is failUnchecked directly before that.")
    public static DataType toRelationalType(@Nonnull Type type) {
        if (primitivesMap.containsValue(type)) {
            return (DataType)primitivesMap.inverse().get(type);
        }
        Type.TypeCode typeCode = type.getTypeCode();
        if (typeCode == Type.TypeCode.ANY || typeCode == Type.TypeCode.NONE || typeCode == Type.TypeCode.NULL || typeCode == Type.TypeCode.UNKNOWN) {
            return DataType.UnknownType.instance();
        }
        Assert.thatUnchecked(!type.isPrimitive());
        switch (typeCode) {
            case RECORD: {
                Type.Record record = (Type.Record)type;
                List<DataType.StructType.Field> columns = record.getFields().stream().map(field -> DataType.StructType.Field.from(field.getFieldName(), DataTypeUtils.toRelationalType(field.getFieldType()), field.getFieldIndex())).collect(Collectors.toList());
                return DataType.StructType.from(record.getName() == null ? DataTypeUtils.toProtoBufCompliantName(UUID.randomUUID().toString()) : record.getName(), columns, record.isNullable());
            }
            case ARRAY: {
                Type.Array asArray = (Type.Array)type;
                return DataType.ArrayType.from(DataTypeUtils.toRelationalType(Assert.notNullUnchecked(asArray.getElementType())), asArray.isNullable());
            }
            case ENUM: {
                Type.Enum asEnum = (Type.Enum)type;
                List<DataType.EnumType.EnumValue> enumValues = asEnum.getEnumValues().stream().map(v -> DataType.EnumType.EnumValue.of(v.getName(), v.getNumber())).collect(Collectors.toList());
                return DataType.EnumType.from(asEnum.getName() == null ? DataTypeUtils.toProtoBufCompliantName(UUID.randomUUID().toString()) : asEnum.getName(), enumValues, asEnum.isNullable());
            }
        }
        Assert.failUnchecked(String.format(Locale.ROOT, "unexpected type %s", type));
        return null;
    }

    @Nonnull
    private static String toProtoBufCompliantName(@Nonnull String input) {
        Assert.thatUnchecked(input.length() > 0);
        String modified = input.replace("-", "_");
        char c = input.charAt(0);
        if (c == '_' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            return modified;
        }
        return "id" + modified;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_NONNULL_RETURN_VIOLATION", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="should never happen, there is failUnchecked directly before that.")
    public static Type toRecordLayerType(@Nonnull DataType type) {
        if (primitivesMap.containsKey(type)) {
            return (Type)primitivesMap.get(type);
        }
        switch (type.getCode()) {
            case STRUCT: {
                DataType.StructType struct = (DataType.StructType)type;
                List<Type.Record.Field> fields = struct.getFields().stream().map(field -> Type.Record.Field.of(DataTypeUtils.toRecordLayerType(field.getType()), Optional.of(field.getName()), Optional.of(field.getIndex()))).collect(Collectors.toList());
                return Type.Record.fromFieldsWithName(struct.getName(), struct.isNullable(), fields);
            }
            case ARRAY: {
                DataType.ArrayType asArray = (DataType.ArrayType)type;
                Assert.thatUnchecked(asArray.getElementType().getCode() == DataType.Code.NULL || !asArray.getElementType().isNullable(), ErrorCode.UNSUPPORTED_OPERATION, "No support for nullable array elements.");
                return new Type.Array(asArray.isNullable(), DataTypeUtils.toRecordLayerType(asArray.getElementType()));
            }
            case ENUM: {
                DataType.EnumType asEnum = (DataType.EnumType)type;
                List<Type.Enum.EnumValue> enumValues = asEnum.getValues().stream().map(v -> new Type.Enum.EnumValue(v.getName(), v.getNumber())).collect(Collectors.toList());
                return new Type.Enum(asEnum.isNullable(), enumValues, asEnum.getName());
            }
            case UNKNOWN: {
                return new Type.Any();
            }
        }
        Assert.failUnchecked(String.format(Locale.ROOT, "unexpected type %s", type));
        return null;
    }

    static {
        primitivesMap.put(DataType.Primitives.BOOLEAN.type(), Type.primitiveType(Type.TypeCode.BOOLEAN, false));
        primitivesMap.put(DataType.Primitives.INTEGER.type(), Type.primitiveType(Type.TypeCode.INT, false));
        primitivesMap.put(DataType.Primitives.LONG.type(), Type.primitiveType(Type.TypeCode.LONG, false));
        primitivesMap.put(DataType.Primitives.DOUBLE.type(), Type.primitiveType(Type.TypeCode.DOUBLE, false));
        primitivesMap.put(DataType.Primitives.FLOAT.type(), Type.primitiveType(Type.TypeCode.FLOAT, false));
        primitivesMap.put(DataType.Primitives.BYTES.type(), Type.primitiveType(Type.TypeCode.BYTES, false));
        primitivesMap.put(DataType.Primitives.STRING.type(), Type.primitiveType(Type.TypeCode.STRING, false));
        primitivesMap.put(DataType.Primitives.VERSION.type(), Type.primitiveType(Type.TypeCode.VERSION, false));
        primitivesMap.put(DataType.Primitives.UUID.type(), Type.uuidType(false));
        primitivesMap.put(DataType.Primitives.NULLABLE_BOOLEAN.type(), Type.primitiveType(Type.TypeCode.BOOLEAN, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_INTEGER.type(), Type.primitiveType(Type.TypeCode.INT, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_LONG.type(), Type.primitiveType(Type.TypeCode.LONG, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_DOUBLE.type(), Type.primitiveType(Type.TypeCode.DOUBLE, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_FLOAT.type(), Type.primitiveType(Type.TypeCode.FLOAT, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_BYTES.type(), Type.primitiveType(Type.TypeCode.BYTES, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_STRING.type(), Type.primitiveType(Type.TypeCode.STRING, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_VERSION.type(), Type.primitiveType(Type.TypeCode.VERSION, true));
        primitivesMap.put(DataType.Primitives.NULLABLE_UUID.type(), Type.uuidType(true));
        primitivesMap.put(DataType.Primitives.NULL.type(), Type.nullType());
    }
}

