/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.InvokedRoutine;
import com.apple.foundationdb.relational.api.metadata.Schema;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchema;
import com.google.common.collect.Multimap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class NoOpSchemaTemplate
implements SchemaTemplate {
    @Nonnull
    private final String name;
    private final int version;

    public NoOpSchemaTemplate(@Nonnull String name, int version) {
        this.name = name;
        this.version = version;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isEnableLongRows() {
        return false;
    }

    @Override
    public boolean isStoreRowVersions() {
        return false;
    }

    @Override
    @Nonnull
    public Schema generateSchema(@Nonnull String databaseId, @Nonnull String schemaName) {
        return new RecordLayerSchema(schemaName, databaseId, this);
    }

    @Override
    @Nonnull
    public Set<? extends Table> getTables() throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have tables!", ErrorCode.INVALID_PARAMETER);
    }

    @Override
    @Nonnull
    public Optional<Table> findTableByName(@Nonnull String tableName) throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have tables!", ErrorCode.INVALID_PARAMETER);
    }

    @Override
    @Nonnull
    public Multimap<String, String> getTableIndexMapping() throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have indexes!", ErrorCode.INVALID_PARAMETER);
    }

    @Override
    @Nonnull
    public Set<String> getIndexes() throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have indexes!", ErrorCode.INVALID_PARAMETER);
    }

    @Override
    @Nonnull
    public BitSet getIndexEntriesAsBitset(@Nonnull Optional<Set<String>> readableIndexNames) throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have indexes!", ErrorCode.INVALID_PARAMETER);
    }

    @Nonnull
    public Set<InvokedRoutine> getInvokedRoutines() throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have invoked routines!", ErrorCode.INVALID_PARAMETER);
    }

    @Nonnull
    public Optional<InvokedRoutine> findInvokedRoutineByName(@Nonnull String routineName) throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have invoked routines!", ErrorCode.INVALID_PARAMETER);
    }

    @Nonnull
    public Collection<InvokedRoutine> getTemporaryInvokedRoutines() throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have temporary invoked routines!", ErrorCode.INVALID_PARAMETER);
    }

    @Override
    @Nonnull
    public String getTransactionBoundMetadataAsString() throws RelationalException {
        throw new RelationalException("NoOpSchemaTemplate doesn't have temporary invoked routines!", ErrorCode.INVALID_PARAMETER);
    }

    @Override
    @Nonnull
    public <T extends SchemaTemplate> T unwrap(@Nonnull Class<T> iface) throws RelationalException {
        return (T)((SchemaTemplate)iface.cast(this));
    }
}

