/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.metadata.Column;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.util.Assert;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerColumn
implements Column {
    @Nonnull
    private final String name;
    @Nonnull
    private final DataType dataType;
    private final int index;

    RecordLayerColumn(@Nonnull String name, @Nonnull DataType dataType, int index) {
        this.name = name;
        this.dataType = dataType;
        this.index = index;
    }

    @Override
    @Nonnull
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @Nonnull
    public static RecordLayerColumn from(@Nonnull DataType.StructType.Field field) {
        return new RecordLayerColumn(field.getName(), field.getType(), field.getIndex());
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private DataType dataType;
        private int index = -1;

        private Builder() {
        }

        @Nonnull
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder setDataType(@Nonnull DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        @Nonnull
        public Builder setIndex(int index) {
            Assert.thatUnchecked(index >= 0);
            this.index = index;
            return this;
        }

        public RecordLayerColumn build() {
            return new RecordLayerColumn(this.name, this.dataType, this.index);
        }
    }
}

