/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.relational.api.metadata.Index;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerIndex
implements Index {
    @Nonnull
    private final String tableName;
    private final String indexType;
    @Nonnull
    private final String name;
    @Nonnull
    private final KeyExpression keyExpression;
    @Nonnull
    private final Map<String, String> options;
    @Nullable
    private final RecordMetaDataProto.Predicate predicate;

    private RecordLayerIndex(@Nonnull String tableName, @Nonnull String indexType, @Nonnull String name, @Nonnull KeyExpression keyExpression, @Nullable RecordMetaDataProto.Predicate predicate, @Nonnull Map<String, String> options) {
        this.tableName = tableName;
        this.indexType = indexType;
        this.name = name;
        this.keyExpression = keyExpression;
        this.predicate = predicate;
        this.options = ImmutableMap.copyOf(options);
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Nonnull
    public String getIndexType() {
        return this.indexType;
    }

    @Override
    public boolean isUnique() {
        String uniqueOption = this.options.get("unique");
        return Boolean.parseBoolean(uniqueOption);
    }

    @Override
    public boolean isSparse() {
        return this.predicate != null;
    }

    @Nullable
    public RecordMetaDataProto.Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public KeyExpression getKeyExpression() {
        return this.keyExpression;
    }

    @Nonnull
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Nonnull
    public static RecordLayerIndex from(@Nonnull String tableName, @Nonnull com.apple.foundationdb.record.metadata.Index index) {
        RecordMetaDataProto.Index indexProto = index.toProto();
        return RecordLayerIndex.newBuilder().setName(index.getName()).setIndexType(index.getType()).setTableName(tableName).setKeyExpression(index.getRootExpression()).setPredicate(indexProto.hasPredicate() ? indexProto.getPredicate() : null).setOptions(index.getOptions()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordLayerIndex that = (RecordLayerIndex)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.indexType, that.indexType) && Objects.equals(this.name, that.name) && Objects.equals(this.keyExpression, that.keyExpression) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.indexType, this.name, this.keyExpression, this.options, this.predicate);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String tableName;
        private String indexType;
        private String name;
        private KeyExpression keyExpression;
        @Nullable
        private ImmutableMap.Builder<String, String> optionsBuilder;
        @Nullable
        private RecordMetaDataProto.Predicate predicate;

        @Nonnull
        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Nonnull
        public Builder setIndexType(String indexType) {
            this.indexType = indexType;
            return this;
        }

        @Nonnull
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder setKeyExpression(KeyExpression keyExpression) {
            this.keyExpression = keyExpression;
            return this;
        }

        @Nonnull
        public Builder setPredicate(@Nullable RecordMetaDataProto.Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        @Nonnull
        public Builder setUnique(boolean isUnique) {
            return this.setOption("unique", isUnique);
        }

        @Nonnull
        public Builder setOptions(@Nonnull Map<String, String> options) {
            this.optionsBuilder = ImmutableMap.builderWithExpectedSize(options.size());
            this.optionsBuilder.putAll(options);
            return this;
        }

        @Nonnull
        public Builder setOption(@Nonnull String optionKey, @Nonnull String optionValue) {
            if (this.optionsBuilder == null) {
                this.optionsBuilder = ImmutableMap.builder();
            }
            this.optionsBuilder.put(optionKey, optionValue);
            return this;
        }

        @Nonnull
        public Builder setOption(@Nonnull String optionKey, int optionValue) {
            return this.setOption(optionKey, Integer.toString(optionValue));
        }

        @Nonnull
        public Builder setOption(@Nonnull String optionKey, boolean optionValue) {
            return this.setOption(optionKey, Boolean.toString(optionValue));
        }

        @Nonnull
        public RecordLayerIndex build() {
            Assert.notNullUnchecked(this.name, "index name is not set");
            Assert.notNullUnchecked(this.tableName, "table name is not set");
            Assert.notNullUnchecked(this.indexType, "index type is not set");
            Assert.notNullUnchecked(this.keyExpression, "index key expression is not set");
            return new RecordLayerIndex(this.tableName, this.indexType, this.name, this.keyExpression, this.predicate, this.optionsBuilder == null ? ImmutableMap.of() : this.optionsBuilder.build());
        }
    }
}

