/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.record.query.plan.cascades.RawSqlFunction;
import com.apple.foundationdb.relational.api.metadata.InvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.query.functions.CompiledSqlFunction;
import com.apple.foundationdb.relational.util.Assert;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class RecordLayerInvokedRoutine
implements InvokedRoutine {
    @Nonnull
    private final String description;
    @Nonnull
    private final String normalizedDescription;
    @Nonnull
    private final String name;
    private final boolean isTemporary;
    @Nonnull
    private final Function<Boolean, CompiledSqlFunction> compilableSqlFunctionSupplier;

    public RecordLayerInvokedRoutine(@Nonnull String description, @Nonnull String normalizedDescription, @Nonnull String name, boolean isTemporary, @Nonnull Function<Boolean, CompiledSqlFunction> compilableSqlFunctionSupplier) {
        this.description = description;
        this.normalizedDescription = normalizedDescription;
        this.name = name;
        this.isTemporary = isTemporary;
        this.compilableSqlFunctionSupplier = compilableSqlFunctionSupplier;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public String getNormalizedDescription() {
        return this.normalizedDescription;
    }

    @Nonnull
    public Function<Boolean, CompiledSqlFunction> getCompilableSqlFunctionSupplier() {
        return this.compilableSqlFunctionSupplier;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public RawSqlFunction asRawFunction() {
        return new RawSqlFunction(this.getName(), this.getDescription());
    }

    @Override
    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RecordLayerInvokedRoutine that = (RecordLayerInvokedRoutine)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name);
    }

    public String toString() {
        return "invoked routine (name '" + this.name + "', description '" + this.description + "')";
    }

    @Nonnull
    public Builder toBuilder() {
        return RecordLayerInvokedRoutine.newBuilder().setName(this.getName()).setDescription(this.getDescription()).setNormalizedDescription(this.getNormalizedDescription()).setTemporary(this.isTemporary()).withCompilableRoutine(this.getCompilableSqlFunctionSupplier());
    }

    public static final class Builder {
        private String description;
        private String normalizedDescription;
        private String name;
        private Function<Boolean, CompiledSqlFunction> compilableSqlFunctionSupplier;
        private boolean isTemporary;

        private Builder() {
        }

        @Nonnull
        public Builder setDescription(@Nonnull String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder setNormalizedDescription(@Nonnull String normalizedDescription) {
            this.normalizedDescription = normalizedDescription;
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder withCompilableRoutine(@Nonnull Function<Boolean, CompiledSqlFunction> compilableSqlFunctionSupplier) {
            this.compilableSqlFunctionSupplier = compilableSqlFunctionSupplier;
            return this;
        }

        @Nonnull
        public Builder setTemporary(boolean isTemporary) {
            this.isTemporary = isTemporary;
            return this;
        }

        @Nonnull
        public RecordLayerInvokedRoutine build() {
            Assert.notNullUnchecked(this.name);
            Assert.notNullUnchecked(this.description);
            Assert.notNullUnchecked(this.compilableSqlFunctionSupplier);
            return new RecordLayerInvokedRoutine(this.description, this.normalizedDescription, this.name, this.isTemporary, this.compilableSqlFunctionSupplier);
        }
    }
}

