/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.InvokedRoutine;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.api.metadata.Visitor;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.metadata.serde.FileDescriptorSerializer;
import com.apple.foundationdb.relational.recordlayer.metadata.serde.RecordMetadataDeserializer;
import com.apple.foundationdb.relational.recordlayer.metadata.serde.RecordMetadataSerializer;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerSchemaTemplate
implements SchemaTemplate {
    @Nonnull
    private final String name;
    @Nonnull
    private final Set<RecordLayerTable> tables;
    @Nonnull
    private final Set<RecordLayerInvokedRoutine> invokedRoutines;
    private final int version;
    private final boolean enableLongRows;
    private final boolean storeRowVersions;
    @Nonnull
    private final Supplier<RecordMetaData> metaDataSupplier;
    @Nonnull
    private final Supplier<Multimap<String, String>> tableIndexMappingSupplier;
    @Nonnull
    private final Supplier<Set<String>> indexesSupplier;
    @Nonnull
    private final Supplier<Collection<? extends InvokedRoutine>> temporaryInvokedRoutinesSupplier;
    @Nonnull
    private final Supplier<String> transactionBoundMetadataSupplier;
    private final boolean intermingleTables;

    private RecordLayerSchemaTemplate(@Nonnull String name, @Nonnull Set<RecordLayerTable> tables, @Nonnull Set<RecordLayerInvokedRoutine> invokedRoutines, int version, boolean enableLongRows, boolean storeRowVersions, boolean intermingleTables) {
        this.name = name;
        this.tables = ImmutableSet.copyOf(tables);
        this.invokedRoutines = ImmutableSet.copyOf(invokedRoutines);
        this.version = version;
        this.enableLongRows = enableLongRows;
        this.storeRowVersions = storeRowVersions;
        this.intermingleTables = intermingleTables;
        this.metaDataSupplier = Suppliers.memoize(this::buildRecordMetadata);
        this.tableIndexMappingSupplier = Suppliers.memoize(this::computeTableIndexMapping);
        this.indexesSupplier = Suppliers.memoize(this::computeIndexes);
        this.temporaryInvokedRoutinesSupplier = Suppliers.memoize(this::computeTemporaryInvokedRoutines);
        this.transactionBoundMetadataSupplier = Suppliers.memoize(this::computeTransactionBoundMetadata);
    }

    private RecordLayerSchemaTemplate(@Nonnull String name, @Nonnull Set<RecordLayerTable> tables, @Nonnull Set<RecordLayerInvokedRoutine> invokedRoutines, int version, boolean enableLongRows, boolean storeRowVersions, boolean intermingleTables, @Nonnull RecordMetaData cachedMetadata) {
        this.name = name;
        this.version = version;
        this.tables = ImmutableSet.copyOf(tables);
        this.invokedRoutines = ImmutableSet.copyOf(invokedRoutines);
        this.enableLongRows = enableLongRows;
        this.storeRowVersions = storeRowVersions;
        this.intermingleTables = intermingleTables;
        this.metaDataSupplier = Suppliers.memoize(() -> cachedMetadata);
        this.tableIndexMappingSupplier = Suppliers.memoize(this::computeTableIndexMapping);
        this.indexesSupplier = Suppliers.memoize(this::computeIndexes);
        this.temporaryInvokedRoutinesSupplier = Suppliers.memoize(this::computeTemporaryInvokedRoutines);
        this.transactionBoundMetadataSupplier = Suppliers.memoize(this::computeTransactionBoundMetadata);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isEnableLongRows() {
        return this.enableLongRows;
    }

    @Override
    public boolean isStoreRowVersions() {
        return this.storeRowVersions;
    }

    @VisibleForTesting
    public boolean isIntermingleTables() {
        return this.intermingleTables;
    }

    @Nonnull
    public Set<RecordLayerTable> getTables() {
        return this.tables;
    }

    @Override
    @Nonnull
    public RecordLayerSchema generateSchema(@Nonnull String databaseId, @Nonnull String schemaName) {
        return new RecordLayerSchema(schemaName, databaseId, this);
    }

    @Nonnull
    public Descriptors.Descriptor getDescriptor(@Nonnull String tableName) {
        return this.toRecordMetadata().getRecordType(tableName).getDescriptor();
    }

    @Nonnull
    private RecordMetaData buildRecordMetadata() {
        Descriptors.FileDescriptor fileDescriptor;
        FileDescriptorSerializer fileDescriptorProtoSerializer = new FileDescriptorSerializer();
        this.accept(fileDescriptorProtoSerializer);
        ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>(TypeRepository.DEPENDENCIES);
        dependencies.add(RecordMetaDataProto.getDescriptor());
        try {
            fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescriptorProtoSerializer.getFileBuilder().build(), dependencies.toArray(new Descriptors.FileDescriptor[0]));
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RelationalException(ErrorCode.SERIALIZATION_FAILURE, (Throwable)e).toUncheckedWrappedException();
        }
        RecordMetadataSerializer recordMetadataSerializer = new RecordMetadataSerializer(fileDescriptor);
        this.accept(recordMetadataSerializer);
        return recordMetadataSerializer.getBuilder().build();
    }

    @Nonnull
    public RecordMetaData toRecordMetadata() {
        return this.metaDataSupplier.get();
    }

    @Nonnull
    public static RecordLayerSchemaTemplate fromRecordMetadata(@Nonnull RecordMetaData metaData, @Nonnull String templateName, int version) {
        RecordMetadataDeserializer deserializer = new RecordMetadataDeserializer(metaData);
        return deserializer.getSchemaTemplate(templateName, version);
    }

    @Override
    @Nonnull
    public Optional<Table> findTableByName(@Nonnull String tableName) {
        for (RecordLayerTable table : this.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return Optional.of(table);
        }
        return Optional.empty();
    }

    @Nonnull
    private Multimap<String, String> computeTableIndexMapping() {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (RecordLayerTable table : this.getTables()) {
            for (RecordLayerIndex index : table.getIndexes()) {
                result.put(table.getName(), index.getName());
            }
        }
        return result.build();
    }

    @Override
    @Nonnull
    public Multimap<String, String> getTableIndexMapping() {
        return this.tableIndexMappingSupplier.get();
    }

    @Nonnull
    private Set<String> computeIndexes() {
        TreeSet<String> result = new TreeSet<String>();
        RecordMetaData metaData = this.toRecordMetadata();
        metaData.getAllIndexes().stream().map(Index::getName).forEach(result::add);
        return result;
    }

    @Override
    @Nonnull
    public Set<String> getIndexes() throws RelationalException {
        return this.indexesSupplier.get();
    }

    @Override
    @Nonnull
    public BitSet getIndexEntriesAsBitset(@Nonnull Optional<Set<String>> indexNames) throws RelationalException {
        Set<String> indexSet = this.getIndexes();
        BitSet result = new BitSet(indexSet.size());
        if (indexNames.isEmpty()) {
            result.set(0, indexSet.size());
            return result;
        }
        Set<String> indexNamesToCheck = indexNames.get();
        boolean allExists = indexSet.containsAll(indexNamesToCheck);
        if (!allExists) {
            Set missingIndexes = indexNamesToCheck.stream().filter(Predicate.not(indexSet::contains)).collect(ImmutableSet.toImmutableSet());
            throw new RelationalException("could not find some of the provided index names ", ErrorCode.INVALID_SCHEMA_TEMPLATE).addContext("missingIndexes", missingIndexes);
        }
        int i = 0;
        for (String index : indexSet) {
            if (indexNames.get().contains(index)) {
                result.set(i);
            }
            ++i;
        }
        return result;
    }

    @Nonnull
    public Set<RecordLayerInvokedRoutine> getInvokedRoutines() {
        return this.invokedRoutines;
    }

    @Override
    @Nonnull
    public Optional<? extends InvokedRoutine> findInvokedRoutineByName(@Nonnull String routineName) {
        return this.invokedRoutines.stream().filter(routine -> routine.getName().equals(routineName)).findFirst();
    }

    @Nonnull
    private Collection<? extends InvokedRoutine> computeTemporaryInvokedRoutines() {
        return this.invokedRoutines.stream().filter(RecordLayerInvokedRoutine::isTemporary).sorted(Comparator.comparing(RecordLayerInvokedRoutine::getDescription)).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Collection<? extends InvokedRoutine> getTemporaryInvokedRoutines() {
        return this.temporaryInvokedRoutinesSupplier.get();
    }

    @Nonnull
    private String computeTransactionBoundMetadata() {
        return this.getTemporaryInvokedRoutines().stream().map(InvokedRoutine::getNormalizedDescription).collect(Collectors.joining("||"));
    }

    @Override
    @Nonnull
    public String getTransactionBoundMetadataAsString() {
        return this.transactionBoundMetadataSupplier.get();
    }

    @Override
    @Nonnull
    public <T extends SchemaTemplate> T unwrap(@Nonnull Class<T> iface) throws RelationalException {
        return (T)((SchemaTemplate)iface.cast(this));
    }

    @Override
    public void accept(@Nonnull Visitor visitor) {
        visitor.startVisit(this);
        visitor.visit(this);
        for (RecordLayerTable table : this.getTables()) {
            table.accept(visitor);
        }
        for (RecordLayerInvokedRoutine invokedRoutine : this.getInvokedRoutines()) {
            invokedRoutine.accept(visitor);
        }
        visitor.finishVisit(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public Builder toBuilder() {
        return RecordLayerSchemaTemplate.newBuilder().setName(this.name).setVersion(this.version).setEnableLongRows(this.enableLongRows).setIntermingleTables(this.intermingleTables).addTables(this.getTables()).addInvokedRoutines(this.getInvokedRoutines());
    }

    public static final class Builder {
        private static final String TABLE_ALREADY_EXISTS = "table '%s' already exists";
        private static final String TYPE_WITH_NAME_ALREADY_EXISTS = "type with name '%s' already exists";
        private static final String TABLE_MISSING_RECORD_TYPE_PREFIX = "table '%s' primary key '%s' is missing record type prefix";
        private String name;
        private int version;
        private boolean enableLongRows = true;
        private boolean intermingleTables;
        private boolean storeRowVersions;
        @Nonnull
        private final Map<String, RecordLayerTable> tables = new LinkedHashMap<String, RecordLayerTable>();
        @Nonnull
        private final Map<String, DataType.Named> auxiliaryTypes = new LinkedHashMap<String, DataType.Named>();
        @Nonnull
        private final Map<String, RecordLayerInvokedRoutine> invokedRoutines = new LinkedHashMap<String, RecordLayerInvokedRoutine>();
        private RecordMetaData cachedMetadata;

        private Builder() {
        }

        @Nonnull
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder setEnableLongRows(boolean value) {
            this.enableLongRows = value;
            return this;
        }

        @Nonnull
        public Builder setIntermingleTables(boolean intermingleTables) {
            this.intermingleTables = intermingleTables;
            return this;
        }

        public boolean isIntermingleTables() {
            return this.intermingleTables;
        }

        @Nonnull
        public Builder setStoreRowVersions(boolean value) {
            this.storeRowVersions = value;
            return this;
        }

        @Nonnull
        public Builder addTable(@Nonnull RecordLayerTable table) {
            Assert.thatUnchecked(!this.tables.containsKey(table.getName()), ErrorCode.INVALID_SCHEMA_TEMPLATE, TABLE_ALREADY_EXISTS, table.getName());
            Assert.thatUnchecked(!this.auxiliaryTypes.containsKey(table.getName()), ErrorCode.INVALID_SCHEMA_TEMPLATE, TYPE_WITH_NAME_ALREADY_EXISTS, table.getName());
            if (!this.intermingleTables) {
                Assert.thatUnchecked(Key.Expressions.recordType().isPrefixKey(table.getPrimaryKey()), ErrorCode.INTERNAL_ERROR, TABLE_MISSING_RECORD_TYPE_PREFIX, table.getName(), table.getPrimaryKey());
            }
            this.tables.put(table.getName(), table);
            return this;
        }

        @Nonnull
        public Builder addTables(@Nonnull Collection<RecordLayerTable> tables) {
            tables.forEach(this::addTable);
            return this;
        }

        @Nonnull
        public Builder addInvokedRoutine(@Nonnull RecordLayerInvokedRoutine invokedRoutine) {
            Assert.thatUnchecked(!this.invokedRoutines.containsKey(invokedRoutine.getName()), ErrorCode.INVALID_SCHEMA_TEMPLATE, () -> "routine " + invokedRoutine.getName() + " is already defined");
            Assert.thatUnchecked(!this.tables.containsKey(invokedRoutine.getName()), ErrorCode.INVALID_SCHEMA_TEMPLATE, () -> "routine " + invokedRoutine.getName() + " cannot be defined because a table with the same name exists");
            this.invokedRoutines.put(invokedRoutine.getName(), invokedRoutine);
            return this;
        }

        @Nonnull
        public Builder replaceInvokedRoutine(@Nonnull RecordLayerInvokedRoutine invokedRoutine) {
            if (this.invokedRoutines.containsKey(invokedRoutine.getName())) {
                Assert.thatUnchecked(this.invokedRoutines.get(invokedRoutine.getName()).isTemporary(), ErrorCode.INVALID_FUNCTION_DEFINITION, "attempt to replace non-temporary invoked routine!");
            }
            this.invokedRoutines.put(invokedRoutine.getName(), invokedRoutine);
            return this;
        }

        public Builder removeInvokedRoutine(@Nonnull String invokedRoutineName) {
            if (!this.invokedRoutines.containsKey(invokedRoutineName)) {
                Assert.thatUnchecked(this.invokedRoutines.get(invokedRoutineName).isTemporary(), ErrorCode.UNDEFINED_FUNCTION, "attempt to non-existent temporary invoked routine!");
            }
            this.invokedRoutines.remove(invokedRoutineName);
            return this;
        }

        @Nonnull
        public Builder addInvokedRoutines(@Nonnull Collection<RecordLayerInvokedRoutine> invokedRoutines) {
            invokedRoutines.forEach(this::addInvokedRoutine);
            return this;
        }

        @Nonnull
        public Builder addAuxiliaryType(@Nonnull DataType.Named auxiliaryType) {
            Assert.thatUnchecked(!this.tables.containsKey(auxiliaryType.getName()), ErrorCode.INVALID_SCHEMA_TEMPLATE, TABLE_ALREADY_EXISTS, auxiliaryType.getName());
            Assert.thatUnchecked(!this.auxiliaryTypes.containsKey(auxiliaryType.getName()), ErrorCode.INVALID_SCHEMA_TEMPLATE, TYPE_WITH_NAME_ALREADY_EXISTS, auxiliaryType.getName());
            this.auxiliaryTypes.put(auxiliaryType.getName(), auxiliaryType);
            return this;
        }

        @Nonnull
        public Builder addAuxiliaryTypes(@Nonnull Collection<DataType.Named> auxiliaryTypes) {
            auxiliaryTypes.forEach(this::addAuxiliaryType);
            return this;
        }

        @Nonnull
        public Builder setCachedMetadata(@Nonnull RecordMetaData metadata) {
            this.cachedMetadata = metadata;
            return this;
        }

        @Nonnull
        public RecordLayerTable findTable(@Nonnull String name) {
            Assert.thatUnchecked(this.tables.containsKey(name), ErrorCode.UNDEFINED_TABLE, "could not find '%s'", name);
            return this.tables.get(name);
        }

        @Nonnull
        public RecordLayerTable extractTable(@Nonnull String name) {
            Assert.thatUnchecked(this.tables.containsKey(name), ErrorCode.UNDEFINED_TABLE, "could not find '%s'", name);
            return this.tables.remove(name);
        }

        @Nonnull
        public Optional<DataType> findType(@Nonnull String name) {
            if (this.tables.containsKey(name)) {
                return Optional.of(this.tables.get(name).getDatatype());
            }
            if (this.auxiliaryTypes.containsKey(name)) {
                return Optional.of((DataType)((Object)this.auxiliaryTypes.get(name)));
            }
            return Optional.empty();
        }

        @Nonnull
        public RecordLayerSchemaTemplate build() {
            Assert.thatUnchecked(!this.tables.isEmpty(), ErrorCode.INVALID_SCHEMA_TEMPLATE, "schema template contains no tables");
            boolean needsResolution = false;
            for (RecordLayerTable table : this.tables.values()) {
                if (table.getDatatype().isResolved()) continue;
                needsResolution = true;
                break;
            }
            if (!needsResolution) {
                for (DataType.Named auxiliaryType : this.auxiliaryTypes.values()) {
                    if (((DataType)((Object)auxiliaryType)).isResolved()) continue;
                    needsResolution = true;
                    break;
                }
            }
            if (needsResolution) {
                this.resolveTypes();
            }
            if (this.cachedMetadata != null) {
                return new RecordLayerSchemaTemplate(this.name, new LinkedHashSet<RecordLayerTable>(this.tables.values()), new LinkedHashSet<RecordLayerInvokedRoutine>(this.invokedRoutines.values()), this.version, this.enableLongRows, this.storeRowVersions, this.intermingleTables, this.cachedMetadata);
            }
            return new RecordLayerSchemaTemplate(this.name, new LinkedHashSet<RecordLayerTable>(this.tables.values()), new LinkedHashSet<RecordLayerInvokedRoutine>(this.invokedRoutines.values()), this.version, this.enableLongRows, this.storeRowVersions, this.intermingleTables);
        }

        private void resolveTypes() {
            ImmutableMap.Builder<String, DataType> mapBuilder = ImmutableMap.builder();
            for (RecordLayerTable recordLayerTable : this.tables.values()) {
                mapBuilder.put(recordLayerTable.getName(), recordLayerTable.getDatatype());
            }
            for (Map.Entry entry : this.auxiliaryTypes.entrySet()) {
                mapBuilder.put((String)entry.getKey(), (DataType)entry.getValue());
            }
            ImmutableMap<String, DataType> namedTypes = mapBuilder.build();
            ImmutableMap.Builder<DataType, Set<DataType>> builder = ImmutableMap.builder();
            for (RecordLayerTable recordLayerTable : this.tables.values()) {
                builder.put(recordLayerTable.getDatatype(), Builder.getDependencies(recordLayerTable.getDatatype(), namedTypes));
            }
            for (Map.Entry entry : this.auxiliaryTypes.entrySet()) {
                builder.put((DataType)entry.getValue(), Builder.getDependencies((DataType)entry.getValue(), namedTypes));
            }
            ImmutableMap deps = builder.build();
            Optional<List<DataType>> optional = TopologicalSort.anyTopologicalOrderPermutation(new HashSet(namedTypes.values()), id -> deps.getOrDefault(id, ImmutableSet.of()));
            Assert.thatUnchecked(optional.isPresent(), ErrorCode.INVALID_SCHEMA_TEMPLATE, "Invalid cyclic dependency in the schema definition");
            LinkedHashMap<String, DataType.Named> resolvedTypes = new LinkedHashMap<String, DataType.Named>();
            Iterator<DataType> iterator = optional.get().iterator();
            while (iterator.hasNext()) {
                DataType dataType;
                DataType typeToAdd = dataType = iterator.next();
                if (!dataType.isResolved()) {
                    typeToAdd = dataType.resolve(resolvedTypes);
                }
                if (!(typeToAdd instanceof DataType.Named)) continue;
                DataType.Named asNamed = (DataType.Named)((Object)typeToAdd);
                resolvedTypes.put(asNamed.getName(), asNamed);
            }
            ImmutableMap.Builder<String, RecordLayerTable> resolvedTables = ImmutableMap.builder();
            for (RecordLayerTable table : this.tables.values()) {
                if (!table.getDatatype().isResolved()) {
                    RecordLayerTable.Builder builder2 = RecordLayerTable.Builder.from((DataType.StructType)table.getDatatype().resolve(resolvedTypes).withNullable(table.getDatatype().isNullable())).setPrimaryKey(table.getPrimaryKey()).addIndexes(table.getIndexes()).addGenerations(table.getGenerations());
                    resolvedTables.put(table.getName(), builder2.build());
                    continue;
                }
                resolvedTables.put(table.getName(), table);
            }
            this.tables.clear();
            this.tables.putAll(resolvedTables.build());
            ImmutableMap.Builder<String, DataType.Named> builder3 = ImmutableMap.builder();
            for (Map.Entry<String, DataType.Named> auxiliaryType : this.auxiliaryTypes.entrySet()) {
                DataType dataType = (DataType)((Object)auxiliaryType.getValue());
                if (!dataType.isResolved()) {
                    builder3.put(auxiliaryType.getKey(), (DataType.Named)((Object)((DataType)resolvedTypes.get(auxiliaryType.getKey())).withNullable(dataType.isNullable())));
                    continue;
                }
                builder3.put(auxiliaryType.getKey(), auxiliaryType.getValue());
            }
            this.auxiliaryTypes.clear();
            this.auxiliaryTypes.putAll(builder3.build());
        }

        @Nonnull
        private static Set<DataType> getDependencies(@Nonnull DataType dataType, @Nonnull Map<String, DataType> types) {
            switch (dataType.getCode()) {
                case ARRAY: {
                    return Builder.getDependencies(((DataType.ArrayType)dataType).getElementType(), types);
                }
                case STRUCT: {
                    ImmutableSet.Builder mapBuilder = ImmutableSet.builder();
                    for (DataType.StructType.Field field : ((DataType.StructType)dataType).getFields()) {
                        DataType fieldType = field.getType();
                        if (fieldType instanceof DataType.Named) {
                            String depName = ((DataType.Named)((Object)fieldType)).getName();
                            Assert.thatUnchecked(types.containsKey(depName), ErrorCode.UNKNOWN_TYPE, "could not find type '%s'", depName);
                            mapBuilder.add(types.get(depName));
                            continue;
                        }
                        if (fieldType.getCode() != DataType.Code.ARRAY || !(((DataType.ArrayType)fieldType).getElementType() instanceof DataType.Named)) continue;
                        DataType.ArrayType asArray = (DataType.ArrayType)fieldType;
                        String depName = ((DataType.Named)((Object)asArray.getElementType())).getName();
                        Assert.thatUnchecked(types.containsKey(depName), ErrorCode.UNKNOWN_TYPE, "could not find type '%s'", depName);
                        mapBuilder.add(types.get(depName));
                    }
                    return mapBuilder.build();
                }
                case UNKNOWN: {
                    String typeName = ((DataType.UnresolvedType)dataType).getName();
                    Assert.thatUnchecked(types.containsKey(typeName), ErrorCode.UNKNOWN_TYPE, "could not find type '%s'", typeName);
                    return Set.of(types.get(typeName));
                }
            }
            return Set.of();
        }
    }
}

