/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.api.metadata.Visitor;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerColumn;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerTable
implements Table {
    @Nonnull
    private final String name;
    @Nonnull
    private final List<RecordLayerColumn> columns;
    @Nonnull
    private final Set<RecordLayerIndex> indexes;
    @Nonnull
    private final KeyExpression primaryKey;
    @Nonnull
    private final DataType.StructType dataType;
    @Nonnull
    private final Type.Record record;
    @Nonnull
    private final Map<Integer, DescriptorProtos.FieldOptions> generations;

    private RecordLayerTable(@Nonnull String name, @Nonnull List<RecordLayerColumn> columns, @Nonnull Set<RecordLayerIndex> indexes, @Nonnull KeyExpression primaryKey, @Nonnull Map<Integer, DescriptorProtos.FieldOptions> generations, DataType.StructType dataType, Type.Record record) {
        this.name = name;
        this.columns = ImmutableList.copyOf(columns);
        this.indexes = ImmutableSet.copyOf(indexes);
        this.primaryKey = primaryKey;
        this.generations = generations;
        this.dataType = dataType == null ? this.calculateDataType() : dataType;
        this.record = record == null ? this.calculateRecordLayerType() : record;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<RecordLayerIndex> getIndexes() {
        return this.indexes;
    }

    @Nonnull
    public Map<Integer, DescriptorProtos.FieldOptions> getGenerations() {
        return this.generations;
    }

    @Nonnull
    public Collection<RecordLayerColumn> getColumns() {
        return this.columns;
    }

    @Nonnull
    public Type.Record getType() {
        return this.record;
    }

    @Nonnull
    public KeyExpression getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public void accept(@Nonnull Visitor visitor) {
        visitor.visit(this);
        for (RecordLayerIndex index : this.getIndexes()) {
            index.accept(visitor);
        }
        for (RecordLayerColumn column : this.getColumns()) {
            column.accept(visitor);
        }
    }

    @Nonnull
    private Type.Record calculateRecordLayerType() {
        return (Type.Record)DataTypeUtils.toRecordLayerType(this.getDatatype());
    }

    @Nonnull
    private DataType.StructType calculateDataType() {
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (RecordLayerColumn column : this.columns) {
            columnTypes.add(DataType.StructType.Field.from(column.getName(), column.getDataType(), column.getIndex()));
        }
        return DataType.StructType.from(this.getName(), (List<DataType.StructType.Field>)((Object)columnTypes.build()), true);
    }

    @Override
    @Nonnull
    public DataType.StructType getDatatype() {
        return this.dataType;
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RecordLayerTable)) {
            return false;
        }
        return this.getName().equals(((RecordLayerTable)obj).getName());
    }

    @Nonnull
    public static Builder newBuilder(boolean intermingleTables) {
        Builder builder = new Builder();
        if (intermingleTables) {
            builder.setPrimaryKey(EmptyKeyExpression.EMPTY);
        }
        return builder;
    }

    public static final class Builder {
        private String name;
        @Nonnull
        private Set<RecordLayerIndex> indexes = new LinkedHashSet<RecordLayerIndex>();
        @Nonnull
        private ImmutableList.Builder<RecordLayerColumn> columns = ImmutableList.builder();
        @Nonnull
        private List<KeyExpression> primaryKeyParts = new ArrayList<KeyExpression>();
        @Nonnull
        private Map<Integer, DescriptorProtos.FieldOptions> generations = new LinkedHashMap<Integer, DescriptorProtos.FieldOptions>();
        private DataType.StructType dataType;
        private Type.Record record;

        private Builder() {
            this.primaryKeyParts.add(Key.Expressions.recordType());
        }

        @Nonnull
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder setDatatype(@Nonnull DataType.StructType dataType) {
            this.dataType = dataType;
            return this;
        }

        @Nonnull
        public Builder setRecord(@Nonnull Type.Record record) {
            this.record = record;
            return this;
        }

        @Nonnull
        public Builder addIndex(@Nonnull RecordLayerIndex index) {
            Assert.thatUnchecked(this.indexes.stream().noneMatch(i -> index.getName().equals(i.getName())), ErrorCode.INDEX_ALREADY_EXISTS, () -> "attempt to add duplicate index '%s'" + index.getName());
            this.indexes.add(index);
            return this;
        }

        @Nonnull
        public Builder addIndexes(@Nonnull Collection<RecordLayerIndex> indexes) {
            indexes.forEach(this::addIndex);
            return this;
        }

        @Nonnull
        public Builder addGenerations(@Nonnull Map<Integer, DescriptorProtos.FieldOptions> generations) {
            generations.forEach(this::addGeneration);
            return this;
        }

        @Nonnull
        public Builder addGeneration(int number, @Nonnull DescriptorProtos.FieldOptions options) {
            Assert.thatUnchecked(!this.generations.containsKey(number), ErrorCode.TABLE_ALREADY_EXISTS, "Duplicate field number %d for generation of Table %s", number, this.name);
            Assert.thatUnchecked(!this.generations.containsValue(options), ErrorCode.TABLE_ALREADY_EXISTS, "Duplicated options for different generations of Table %s", this.name);
            this.generations.put(number, options);
            return this;
        }

        @Nonnull
        public Builder setPrimaryKey(@Nonnull KeyExpression primaryKey) {
            if (primaryKey instanceof ThenKeyExpression) {
                this.primaryKeyParts = new ArrayList<KeyExpression>(((ThenKeyExpression)primaryKey).getChildren());
            } else if (primaryKey instanceof EmptyKeyExpression) {
                this.primaryKeyParts.clear();
            } else {
                this.primaryKeyParts.clear();
                this.primaryKeyParts.add(primaryKey);
            }
            return this;
        }

        @Nonnull
        public Builder addPrimaryKeyPart(@Nonnull List<String> primaryKeyPart) {
            this.primaryKeyParts.add(Builder.toKeyExpression(primaryKeyPart));
            return this;
        }

        @Nonnull
        public Builder addColumn(@Nonnull RecordLayerColumn column) {
            this.columns.add((Object)column);
            return this;
        }

        @Nonnull
        public Builder addColumns(@Nonnull Collection<RecordLayerColumn> columns) {
            this.columns.addAll(columns);
            return this;
        }

        @Nonnull
        private static KeyExpression toKeyExpression(@Nonnull List<String> fields) {
            Assert.thatUnchecked(!fields.isEmpty());
            return Builder.toKeyExpression(fields, 0);
        }

        @Nonnull
        private static KeyExpression toKeyExpression(@Nonnull List<String> fields, int i) {
            Assert.thatUnchecked(0 <= i && i < fields.size());
            if (i == fields.size() - 1) {
                return Key.Expressions.field(fields.get(i));
            }
            return Key.Expressions.field(fields.get(i)).nest(Builder.toKeyExpression(fields, i + 1));
        }

        private KeyExpression getPrimaryKey() {
            if (this.primaryKeyParts.isEmpty()) {
                return EmptyKeyExpression.EMPTY;
            }
            if (this.primaryKeyParts.size() == 1) {
                return this.primaryKeyParts.get(0);
            }
            return Key.Expressions.concat(this.primaryKeyParts);
        }

        @Nonnull
        public RecordLayerTable build() {
            Assert.notNullUnchecked(this.name, "table name is not set");
            List<RecordLayerColumn> columnsList = Builder.normalize((List<RecordLayerColumn>)((Object)this.columns.build()));
            Assert.thatUnchecked(!columnsList.isEmpty(), ErrorCode.INVALID_TABLE_DEFINITION, "Attempting to create table %s without columns", this.name);
            ImmutableSet<RecordLayerIndex> indexesSet = ImmutableSet.copyOf(this.indexes);
            return new RecordLayerTable(this.name, columnsList, indexesSet, this.getPrimaryKey(), this.generations, this.dataType, this.record);
        }

        @Nonnull
        public static Builder from(@Nonnull RecordLayerTable table) {
            return RecordLayerTable.newBuilder(false).setName(table.getName()).addColumns(table.getColumns()).setPrimaryKey(table.getPrimaryKey()).addIndexes(table.getIndexes()).setDatatype(table.getDatatype()).setRecord(table.getType()).addGenerations(table.getGenerations());
        }

        @Nonnull
        public static Builder from(@Nonnull DataType.StructType structType) {
            return RecordLayerTable.newBuilder(false).setName(structType.getName()).addColumns(structType.getFields().stream().map(RecordLayerColumn::from).collect(Collectors.toList())).setDatatype(structType);
        }

        @Nonnull
        public static Builder from(@Nonnull Type.Record record) {
            DataType relationalType = DataTypeUtils.toRelationalType(record);
            Assert.thatUnchecked(relationalType instanceof DataType.StructType);
            DataType.StructType asStruct = (DataType.StructType)relationalType;
            return Builder.from(asStruct).setRecord(record);
        }

        @Nonnull
        private static List<RecordLayerColumn> normalize(@Nonnull List<RecordLayerColumn> columns) {
            if (columns.stream().allMatch(c -> c.getIndex() >= 0)) {
                return columns;
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (int i = 1; i <= columns.size(); ++i) {
                RecordLayerColumn column = columns.get(i - 1);
                if (column.getIndex() < 0) {
                    result.add(RecordLayerColumn.newBuilder().setName(column.getName()).setIndex(i).setDataType(column.getDataType()).build());
                    continue;
                }
                result.add(column);
            }
            return result.build();
        }
    }
}

