/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata.serde;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaDataOptionsProto;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.relational.api.metadata.Metadata;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.metadata.SkeletonVisitor;
import com.apple.foundationdb.relational.util.Assert;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class FileDescriptorSerializer
extends SkeletonVisitor {
    @Nonnull
    private final DescriptorProtos.FileDescriptorProto.Builder fileBuilder;
    @Nonnull
    private final DescriptorProtos.DescriptorProto.Builder unionDescriptorBuilder;
    @Nonnull
    private final Set<String> descriptorNames;
    @Nonnull
    private final Set<String> enumNames;
    private Boolean assignGenerations;
    private int tableCounter;

    public FileDescriptorSerializer() {
        this(DescriptorProtos.FileDescriptorProto.newBuilder());
    }

    public FileDescriptorSerializer(@Nonnull DescriptorProtos.FileDescriptorProto.Builder fileBuilder) {
        this.fileBuilder = fileBuilder;
        this.fileBuilder.addAllDependency(TypeRepository.DEPENDENCIES.stream().map(Descriptors.FileDescriptor::getFullName).collect(Collectors.toList()));
        this.unionDescriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder().setName("RecordTypeUnion");
        RecordMetaDataOptionsProto.RecordTypeOptions options = RecordMetaDataOptionsProto.RecordTypeOptions.newBuilder().setUsage(RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION).build();
        this.unionDescriptorBuilder.getOptionsBuilder().setExtension(RecordMetaDataOptionsProto.record, options);
        this.descriptorNames = new LinkedHashSet<String>();
        this.enumNames = new LinkedHashSet<String>();
        this.tableCounter = 1;
    }

    @Override
    public void visit(@Nonnull Metadata metadata) {
        Assert.failUnchecked(String.format(Locale.ROOT, "unexpected call on %s", metadata.getClass().getName()));
    }

    @Override
    public void visit(@Nonnull Table table) {
        Assert.thatUnchecked(table instanceof RecordLayerTable);
        RecordLayerTable recordLayerTable = (RecordLayerTable)table;
        Type.Record type = recordLayerTable.getType();
        String typeDescriptor = this.registerTypeDescriptors(type);
        Map<Integer, DescriptorProtos.FieldOptions> generations = recordLayerTable.getGenerations();
        this.checkTableGenerations(generations);
        int fieldCounter = 0;
        for (Map.Entry<Integer, DescriptorProtos.FieldOptions> version : generations.entrySet()) {
            DescriptorProtos.FieldDescriptorProto tableEntryInUnionDescriptor = DescriptorProtos.FieldDescriptorProto.newBuilder().setNumber(version.getKey()).setName(recordLayerTable.getName() + "_" + fieldCounter++).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(typeDescriptor).setOptions(version.getValue()).build();
            this.unionDescriptorBuilder.addField(tableEntryInUnionDescriptor);
        }
    }

    @Nonnull
    private String registerTypeDescriptors(@Nonnull Type.Record type) {
        Descriptors.GenericDescriptor descriptor;
        TypeRepository.Builder builder = TypeRepository.newBuilder();
        type.defineProtoType(builder);
        TypeRepository typeDescriptors = builder.build();
        String typeDescriptor = typeDescriptors.getMessageDescriptor(type).getName();
        for (String descriptorName : typeDescriptors.getMessageTypes()) {
            if (this.descriptorNames.contains(descriptorName)) continue;
            descriptor = typeDescriptors.getMessageDescriptor(descriptorName);
            this.fileBuilder.addMessageType(((Descriptors.Descriptor)descriptor).toProto());
            this.descriptorNames.add(descriptorName);
        }
        for (String enumName : typeDescriptors.getEnumTypes()) {
            if (this.enumNames.contains(enumName)) continue;
            descriptor = typeDescriptors.getEnumDescriptor(enumName);
            this.fileBuilder.addEnumType(((Descriptors.EnumDescriptor)descriptor).toProto());
            this.enumNames.add(enumName);
        }
        return typeDescriptor;
    }

    @Override
    public void startVisit(@Nonnull SchemaTemplate schemaTemplate) {
        this.fileBuilder.setName(schemaTemplate.getName());
    }

    @Override
    public void finishVisit(@Nonnull SchemaTemplate schemaTemplate) {
        this.finish();
    }

    private void finish() {
        DescriptorProtos.DescriptorProto unionDescriptor = this.unionDescriptorBuilder.build();
        this.fileBuilder.addMessageType(unionDescriptor);
    }

    @Nonnull
    public DescriptorProtos.FileDescriptorProto.Builder getFileBuilder() {
        return this.fileBuilder;
    }

    private void checkTableGenerations(@Nonnull Map<Integer, DescriptorProtos.FieldOptions> generations) {
        if (this.assignGenerations == null) {
            this.assignGenerations = generations.isEmpty();
        }
        if (this.assignGenerations.booleanValue()) {
            Assert.thatUnchecked(generations.isEmpty(), "Table already has generations when serializing in assignGenerations mode.");
            generations.put(this.tableCounter++, DescriptorProtos.FieldOptions.newBuilder().build());
        } else {
            Assert.thatUnchecked(!generations.isEmpty(), "Table do not have generations when serializing in non-assignGenerations mode.");
        }
    }
}

