/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata.serde;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.query.plan.cascades.RawSqlFunction;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.metadata.serde.RoutineParser;
import com.apple.foundationdb.relational.recordlayer.query.functions.CompiledSqlFunction;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordMetadataDeserializer {
    @Nonnull
    private final RecordMetaData recordMetaData;
    @Nonnull
    private final RecordLayerSchemaTemplate.Builder builder;

    public RecordMetadataDeserializer(@Nonnull RecordMetaData recordMetaData) {
        this.recordMetaData = recordMetaData;
        this.builder = this.deserializeRecordMetaData();
    }

    @Nonnull
    public RecordLayerSchemaTemplate getSchemaTemplate(@Nonnull String schemaTemplateName, int version) {
        return this.builder.setName(schemaTemplateName).setVersion(version).build();
    }

    @Nonnull
    private RecordLayerSchemaTemplate.Builder deserializeRecordMetaData() {
        Descriptors.Descriptor unionDescriptor = this.recordMetaData.getUnionDescriptor();
        List<Descriptors.FieldDescriptor> registeredTypes = unionDescriptor.getFields();
        RecordLayerSchemaTemplate.Builder schemaTemplateBuilder = RecordLayerSchemaTemplate.newBuilder().setStoreRowVersions(this.recordMetaData.isStoreRecordVersions()).setEnableLongRows(this.recordMetaData.isSplitLongRecords()).setIntermingleTables(!this.recordMetaData.primaryKeyHasRecordTypePrefix());
        HashMap<String, RecordLayerTable.Builder> nameToTableBuilder = new HashMap<String, RecordLayerTable.Builder>();
        block4: for (Descriptors.FieldDescriptor registeredType : registeredTypes) {
            switch (registeredType.getType()) {
                case MESSAGE: {
                    String name = registeredType.getMessageType().getName();
                    if (!nameToTableBuilder.containsKey(name)) {
                        nameToTableBuilder.put(name, this.generateTableBuilder(name));
                    }
                    ((RecordLayerTable.Builder)nameToTableBuilder.get(name)).addGeneration(registeredType.getNumber(), registeredType.getOptions());
                    continue block4;
                }
                case ENUM: {
                    Type.Enum recordLayerType = new Type.Enum(false, Type.Enum.enumValuesFromProto(registeredType.getEnumType().getValues()), registeredType.getName());
                    schemaTemplateBuilder.addAuxiliaryType((DataType.Named)((Object)DataTypeUtils.toRelationalType(recordLayerType)));
                    continue block4;
                }
            }
            Assert.failUnchecked(String.format(Locale.ROOT, "Unexpected type '%s' found in union descriptor!", new Object[]{registeredType.getType()}));
        }
        nameToTableBuilder.values().stream().map(RecordLayerTable.Builder::build).forEach(schemaTemplateBuilder::addTable);
        if (!this.recordMetaData.getUserDefinedFunctionMap().isEmpty()) {
            Supplier<RecordLayerSchemaTemplate> metadataProvider = Suppliers.memoize(schemaTemplateBuilder::build);
            for (Map.Entry<String, UserDefinedFunction> function : this.recordMetaData.getUserDefinedFunctionMap().entrySet()) {
                if (!(function.getValue() instanceof RawSqlFunction)) continue;
                schemaTemplateBuilder.addInvokedRoutine(this.generateInvokedRoutineBuilder(metadataProvider, function.getKey(), Assert.castUnchecked(function.getValue(), RawSqlFunction.class).getDefinition()).build());
            }
        }
        schemaTemplateBuilder.setCachedMetadata(this.getRecordMetaData());
        return schemaTemplateBuilder;
    }

    @Nonnull
    private RecordLayerTable.Builder generateTableBuilder(@Nonnull String tableName) {
        return this.generateTableBuilder(this.recordMetaData.getRecordType(tableName));
    }

    @Nonnull
    private RecordLayerTable.Builder generateTableBuilder(@Nonnull RecordType recordType) {
        Type.Record recordLayerType = Type.Record.fromFieldsWithName(recordType.getName(), false, Type.Record.fromDescriptor(recordType.getDescriptor()).getFields());
        if (recordLayerType.getFields().stream().anyMatch(f -> f.getFieldType().isRecord())) {
            ImmutableList.Builder newFields = ImmutableList.builder();
            for (int i = 0; i < recordLayerType.getFields().size(); ++i) {
                Descriptors.FieldDescriptor protoField = recordType.getDescriptor().getFields().get(i);
                Type.Record.Field field = recordLayerType.getField(i);
                if (field.getFieldType().isRecord()) {
                    Type.Record r = Type.Record.fromFieldsWithName(protoField.getMessageType().getName(), field.getFieldType().isNullable(), ((Type.Record)field.getFieldType()).getFields());
                    newFields.add(Type.Record.Field.of(r, field.getFieldNameOptional(), field.getFieldIndexOptional()));
                    continue;
                }
                newFields.add(field);
            }
            return RecordLayerTable.Builder.from(Type.Record.fromFieldsWithName(recordType.getName(), false, (List<Type.Record.Field>)((Object)newFields.build()))).setPrimaryKey(recordType.getPrimaryKey()).addIndexes(recordType.getIndexes().stream().map(index -> RecordLayerIndex.from(recordType.getName(), index)).collect(Collectors.toSet()));
        }
        return RecordLayerTable.Builder.from(recordLayerType).setPrimaryKey(recordType.getPrimaryKey()).addIndexes(recordType.getIndexes().stream().map(index -> RecordLayerIndex.from(recordType.getName(), index)).collect(Collectors.toSet()));
    }

    @Nonnull
    @VisibleForTesting
    protected Function<Boolean, CompiledSqlFunction> getSqlFunctionCompiler(@Nonnull String name, @Nonnull Supplier<RecordLayerSchemaTemplate> metadata, @Nonnull String functionBody) {
        return isCaseSensitive -> RoutineParser.sqlFunctionParser((RecordLayerSchemaTemplate)metadata.get()).parse(functionBody, (boolean)isCaseSensitive);
    }

    @Nonnull
    private RecordLayerInvokedRoutine.Builder generateInvokedRoutineBuilder(@Nonnull Supplier<RecordLayerSchemaTemplate> metadata, @Nonnull String name, @Nonnull String body) {
        return RecordLayerInvokedRoutine.newBuilder().setName(name).setDescription(body).setTemporary(false).withCompilableRoutine(this.getSqlFunctionCompiler(name, metadata, body));
    }

    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.recordMetaData;
    }
}

