/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata.serde;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.metadata.IndexPredicate;
import com.apple.foundationdb.record.metadata.RecordTypeBuilder;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.relational.api.metadata.Index;
import com.apple.foundationdb.relational.api.metadata.InvokedRoutine;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.metadata.SkeletonVisitor;
import com.apple.foundationdb.relational.util.Assert;
import com.google.protobuf.Descriptors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordMetadataSerializer
extends SkeletonVisitor {
    @Nonnull
    private final RecordMetaDataBuilder builder;
    private int recordTypeCounter;

    public RecordMetadataSerializer(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        this(RecordMetaData.newBuilder().setRecords(fileDescriptor));
    }

    public RecordMetadataSerializer(@Nonnull RecordMetaDataBuilder builder) {
        this.builder = builder;
        this.recordTypeCounter = 0;
    }

    @Override
    public void visit(@Nonnull Table table) {
        Assert.thatUnchecked(table instanceof RecordLayerTable);
        RecordLayerTable recLayerTable = (RecordLayerTable)table;
        KeyExpression keyExpression = recLayerTable.getPrimaryKey();
        RecordTypeBuilder recordType = this.getBuilder().getRecordType(table.getName());
        recordType.setRecordTypeKey(this.recordTypeCounter++);
        recordType.setPrimaryKey(keyExpression);
    }

    @Override
    public void visit(@Nonnull Index index) {
        Assert.thatUnchecked(index instanceof RecordLayerIndex);
        RecordLayerIndex recLayerIndex = (RecordLayerIndex)index;
        this.getBuilder().addIndex(index.getTableName(), new com.apple.foundationdb.record.metadata.Index(index.getName(), recLayerIndex.getKeyExpression(), index.getIndexType(), recLayerIndex.getOptions(), recLayerIndex.getPredicate() == null ? null : IndexPredicate.fromProto(recLayerIndex.getPredicate())));
    }

    @Override
    public void visit(@Nonnull InvokedRoutine invokedRoutine) {
        if (invokedRoutine.isTemporary()) {
            return;
        }
        RecordLayerInvokedRoutine recordLayerInvokedRoutine = Assert.castUnchecked(invokedRoutine, RecordLayerInvokedRoutine.class);
        this.getBuilder().addUserDefinedFunction(recordLayerInvokedRoutine.asRawFunction());
    }

    @Override
    public void visit(@Nonnull SchemaTemplate schemaTemplate) {
        Assert.thatUnchecked(schemaTemplate instanceof RecordLayerSchemaTemplate);
        this.getBuilder().setSplitLongRecords(schemaTemplate.isEnableLongRows());
        this.getBuilder().setStoreRecordVersions(schemaTemplate.isStoreRowVersions());
        this.getBuilder().setVersion(schemaTemplate.getVersion());
    }

    @Nonnull
    public RecordMetaDataBuilder getBuilder() {
        return this.builder;
    }
}

