/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metadata.serde;

import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.relational.api.ddl.NoOpQueryFactory;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.ddl.NoOpMetadataOperationsFactory;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.query.MutablePlanGenerationContext;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.recordlayer.query.QueryParser;
import com.apple.foundationdb.relational.recordlayer.query.functions.CompiledSqlFunction;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import java.net.URI;
import javax.annotation.Nonnull;

public interface RoutineParser {
    @Nonnull
    public UserDefinedFunction parse(@Nonnull String var1, boolean var2);

    @Nonnull
    public UserDefinedFunction parseTemporaryFunction(@Nonnull String var1, @Nonnull String var2, @Nonnull PreparedParams var3, boolean var4);

    @Nonnull
    public static DefaultSqlFunctionParser sqlFunctionParser(@Nonnull RecordLayerSchemaTemplate metaData) {
        return new DefaultSqlFunctionParser(metaData);
    }

    public static class DefaultSqlFunctionParser
    implements RoutineParser {
        @Nonnull
        private final RecordLayerSchemaTemplate metaData;

        private DefaultSqlFunctionParser(@Nonnull RecordLayerSchemaTemplate metaData) {
            this.metaData = metaData;
        }

        @Override
        @Nonnull
        public CompiledSqlFunction parse(@Nonnull String routineString, boolean isCaseSensitive) {
            RelationalParser.SqlInvokedFunctionContext parsed;
            try {
                parsed = QueryParser.parseFunction(routineString);
            }
            catch (RelationalException e) {
                throw e.toUncheckedWrappedException();
            }
            MutablePlanGenerationContext planGenerationContext = new MutablePlanGenerationContext(PreparedParams.empty(), PlanHashable.PlanHashMode.VC0, routineString, routineString, 0);
            BaseVisitor visitor = new BaseVisitor(planGenerationContext, this.metaData, new NoOpQueryFactory(), NoOpMetadataOperationsFactory.INSTANCE, URI.create(""), isCaseSensitive);
            return visitor.visitSqlInvokedFunction(parsed);
        }

        @Override
        @Nonnull
        public CompiledSqlFunction parseTemporaryFunction(@Nonnull String functionName, @Nonnull String routineString, @Nonnull PreparedParams preparedParams, boolean isCaseSensitive) {
            RelationalParser.TempSqlInvokedFunctionContext parsed;
            try {
                parsed = QueryParser.parseTemporaryFunction(routineString);
            }
            catch (RelationalException e) {
                throw e.toUncheckedWrappedException();
            }
            MutablePlanGenerationContext planGenerationContext = new MutablePlanGenerationContext(preparedParams, PlanHashable.PlanHashMode.VC0, routineString, routineString, 0);
            planGenerationContext.getLiteralsBuilder().setScope(functionName);
            BaseVisitor visitor = new BaseVisitor(planGenerationContext, this.metaData, new NoOpQueryFactory(), NoOpMetadataOperationsFactory.INSTANCE, URI.create(""), isCaseSensitive);
            return visitor.visitTempSqlInvokedFunction(parsed);
        }
    }
}

