/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.metric;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.Supplier;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerMetricCollector
implements MetricCollector {
    @Nonnull
    private final FDBRecordContext context;

    public RecordLayerMetricCollector(@Nonnull FDBRecordContext fdbRecordContext) {
        this.context = fdbRecordContext;
    }

    @Override
    public void increment(@Nonnull RelationalMetric.RelationalCount count) {
        this.context.increment(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T clock(@Nonnull RelationalMetric.RelationalEvent event, Supplier<T> supplier) throws RelationalException {
        long startTime = System.nanoTime();
        try {
            T result;
            T t2 = result = supplier.get();
            return t2;
        }
        finally {
            this.recordSinceNanoTime(event, startTime);
        }
    }

    private void recordSinceNanoTime(@Nonnull RelationalMetric.RelationalEvent event, long startTimeNanos) {
        this.context.record(event, System.nanoTime() - startTimeNanos);
    }

    @Override
    public double getAverageTimeMicrosForEvent(@Nonnull RelationalMetric.RelationalEvent event) {
        StoreTimer.Counter maybeCounter = this.context.getTimer().getCounter(event);
        Assert.notNullUnchecked(maybeCounter, ErrorCode.INTERNAL_ERROR, "Cannot find metrics associated for requested event: %s", event.title());
        if (maybeCounter.getCount() == 0) {
            return 0.0;
        }
        return (double)TimeUnit.NANOSECONDS.toMicros(maybeCounter.getTimeNanos()) / (double)maybeCounter.getCount();
    }

    @Override
    public long getCountsForCounter(@Nonnull RelationalMetric.RelationalCount count) {
        Assert.thatUnchecked(this.hasCounter(count), ErrorCode.INTERNAL_ERROR, "Cannot find metrics associated for requested event: %s", count.title());
        StoreTimer.Counter counter = this.getCounter(count);
        Assert.thatUnchecked(counter.getTimeNanos() == 0L, ErrorCode.INTERNAL_ERROR, "Event: %s records time and is probably a event timer", count.title());
        return counter.getCount();
    }

    @Override
    public boolean hasCounter(@Nonnull RelationalMetric.RelationalCount count) {
        return this.getCounter(count) != null;
    }

    @Nullable
    private StoreTimer.Counter getCounter(@Nonnull RelationalMetric.RelationalCount count) {
        return this.getUnderlyingStoreTimer().getCounter(count);
    }

    @Nonnull
    @VisibleForTesting
    public StoreTimer getUnderlyingStoreTimer() {
        return Objects.requireNonNull(this.context.getTimer());
    }
}

