/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.InvokedRoutine;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.generated.RelationalParserBaseVisitor;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.query.NormalizedQueryExecutionContext;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.query.PlannerConfiguration;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import com.apple.foundationdb.relational.recordlayer.query.QueryParser;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.cache.QueryCacheKey;
import com.apple.foundationdb.relational.recordlayer.query.functions.CompiledSqlFunction;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

@NotThreadSafe
@API(value=API.Status.EXPERIMENTAL)
public final class AstNormalizer
extends RelationalParserBaseVisitor<Object> {
    @Nonnull
    private final Hasher hashFunction = Hashing.murmur3_32_fixed().newHasher();
    private final Hasher parameterHash = Hashing.murmur3_32_fixed().newHasher().putInt("ParameterHash".hashCode());
    private final Supplier<Integer> parameterHashSupplier = Suppliers.memoize(() -> this.parameterHash.hash().asInt())::get;
    @Nonnull
    private final StringBuilder sqlCanonicalizer = new StringBuilder();
    private final boolean caseSensitive;
    private boolean allowTokenAddition;
    private boolean allowLiteralAddition;
    @Nonnull
    private final NormalizedQueryExecutionContext.Builder queryHasherContextBuilder;
    @Nonnull
    private final PreparedParams preparedStatementParameters;
    @Nonnull
    private final Set<NormalizationResult.QueryCachingFlags> queryCachingFlags;
    @Nonnull
    private final Options.Builder queryOptions;
    @Nonnull
    private static Map<Class<?>, Function<ParserRuleContext, Object>> literalNodes = new HashMap();

    private AstNormalizer(@Nonnull PreparedParams preparedStatementParameters, boolean caseSensitive, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) {
        this.queryHasherContextBuilder = NormalizedQueryExecutionContext.newBuilder().setPlanHashMode(currentPlanHashMode);
        this.preparedStatementParameters = preparedStatementParameters;
        this.allowTokenAddition = true;
        this.allowLiteralAddition = true;
        this.queryCachingFlags = EnumSet.noneOf(NormalizationResult.QueryCachingFlags.class);
        this.queryOptions = Options.builder();
        this.caseSensitive = caseSensitive;
    }

    @Override
    public Void visitChildren(@Nonnull RuleNode node) {
        if (literalNodes.containsKey(node.getClass())) {
            ParserRuleContext ruleContext = (ParserRuleContext)node;
            this.processScalarLiteral(literalNodes.get(node.getClass()).apply(ruleContext), ruleContext.getStart().getTokenIndex());
            return null;
        }
        if (this.allowTokenAddition) {
            this.hashFunction.putInt(node.getClass().hashCode());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ParseTree child = Assert.notNullUnchecked(node.getChild(i));
            child.accept(this);
        }
        return null;
    }

    @Override
    public Void visitTerminal(@Nonnull TerminalNode node) {
        if (node.getSymbol().getType() != -1) {
            this.sqlCanonicalizer.append(node.getText()).append(" ");
        }
        return null;
    }

    @Override
    public Object visitCreateTempFunction(RelationalParser.CreateTempFunctionContext ctx) {
        String functionName = ctx.tempSqlInvokedFunction().functionSpecification().schemaQualifiedRoutineName.getText();
        this.queryHasherContextBuilder.getLiteralsBuilder().setScope(functionName);
        return this.visitChildren(ctx);
    }

    @Override
    public Value visitUid(@Nonnull RelationalParser.UidContext ctx) {
        String uid = SemanticAnalyzer.normalizeString(ctx.getText(), this.caseSensitive);
        this.sqlCanonicalizer.append("\"").append(uid).append("\"").append(" ");
        return null;
    }

    public int getHash() {
        return this.hashFunction.hash().asInt();
    }

    public int getParameterHash() {
        return this.parameterHashSupplier.get();
    }

    @Nonnull
    public String getCanonicalSqlString() {
        return this.sqlCanonicalizer.toString();
    }

    @Nonnull
    public Set<NormalizationResult.QueryCachingFlags> getQueryCachingFlags() {
        return this.queryCachingFlags;
    }

    @Nonnull
    public Options getQueryOptions() {
        return this.queryOptions.build();
    }

    @Nonnull
    public QueryExecutionContext getQueryExecutionParameters() {
        this.queryHasherContextBuilder.setParameterHash(this.getParameterHash());
        return this.queryHasherContextBuilder.build();
    }

    @Override
    public Void visitFullDescribeStatement(@Nonnull RelationalParser.FullDescribeStatementContext ctx) {
        this.queryHasherContextBuilder.setForExplain(ctx.EXPLAIN() != null);
        return this.visitChildren(ctx);
    }

    @Override
    public Void visitLimitClause(@Nonnull RelationalParser.LimitClauseContext ctx) {
        if (ctx.offset != null) {
            Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "OFFSET clause is not supported.");
        }
        if (ctx.limit != null) {
            Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "LIMIT clause is not supported.");
        }
        return null;
    }

    @Override
    public Void visitLimitClauseAtom(RelationalParser.LimitClauseAtomContext ctx) {
        return null;
    }

    @Override
    public Object visitQuery(@Nonnull RelationalParser.QueryContext ctx) {
        if (this.queryCachingFlags.isEmpty()) {
            this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_DQL_STATEMENT);
        }
        if (ctx.ctes() != null) {
            this.visit(ctx.ctes());
        }
        ctx.queryExpressionBody().accept(this);
        if (ctx.continuation() != null) {
            ctx.continuation().accept(this);
        }
        return null;
    }

    @Override
    public Object visitContinuation(@Nonnull RelationalParser.ContinuationContext ctx) {
        return ctx.continuationAtom().accept(this);
    }

    @Override
    public RelationalExpression visitQueryOptions(@Nonnull RelationalParser.QueryOptionsContext ctx) {
        for (RelationalParser.QueryOptionContext opt : ctx.queryOption()) {
            this.visit(opt);
        }
        return null;
    }

    @Override
    public Object visitQueryOption(@Nonnull RelationalParser.QueryOptionContext ctx) {
        try {
            if (ctx.NOCACHE() != null) {
                this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.WITH_NO_CACHE_OPTION);
            }
            if (ctx.LOG() != null) {
                this.queryOptions.withOption(Options.Name.LOG_QUERY, true);
            }
            if (ctx.DRY() != null) {
                this.queryOptions.withOption(Options.Name.DRY_RUN, true);
            }
            return null;
        }
        catch (SQLException e) {
            throw ExceptionUtil.toRelationalException(e).toUncheckedWrappedException();
        }
    }

    @Override
    public Object visitDdlStatement(@Nonnull RelationalParser.DdlStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_DDL_STATEMENT);
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitInsertStatement(RelationalParser.InsertStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_INSERT_STATEMENT);
        return super.visitInsertStatement(ctx);
    }

    @Override
    public Object visitUpdateStatement(RelationalParser.UpdateStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_UPDATE_STATEMENT);
        return super.visitUpdateStatement(ctx);
    }

    @Override
    public Object visitDeleteStatement(RelationalParser.DeleteStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_DELETE_STATEMENT);
        return super.visitDeleteStatement(ctx);
    }

    @Override
    public Object visitAdministrationStatement(@Nonnull RelationalParser.AdministrationStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_ADMIN_STATEMENT);
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitUtilityStatement(@Nonnull RelationalParser.UtilityStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_UTILITY_STATEMENT);
        return this.visitChildren(ctx);
    }

    @Override
    public Void visitContinuationAtom(@Nonnull RelationalParser.ContinuationAtomContext ctx) {
        this.allowLiteralAddition = false;
        this.allowTokenAddition = false;
        if (ctx.bytesLiteral() != null) {
            byte[] continuation = ParseHelpers.parseBytes(ctx.bytesLiteral().getText());
            Assert.notNullUnchecked(continuation, ErrorCode.INVALID_CONTINUATION, "Illegal query with BEGIN continuation.");
            Assert.thatUnchecked(continuation.length != 0, ErrorCode.INVALID_CONTINUATION, "Illegal query with END continuation.");
            this.queryHasherContextBuilder.setContinuation(continuation);
            this.processScalarLiteral(continuation, ctx.getStart().getTokenIndex());
        } else {
            Object continuation = this.visit(ctx.preparedStatementParameter());
            Assert.thatUnchecked(continuation instanceof byte[]);
            this.queryHasherContextBuilder.setContinuation((byte[])continuation);
        }
        this.allowLiteralAddition = true;
        this.allowTokenAddition = true;
        return null;
    }

    @Override
    public Void visitScalarFunctionCall(@Nonnull RelationalParser.ScalarFunctionCallContext ctx) {
        String functionName = ctx.scalarFunctionName().getText();
        boolean skipFirstFunctionArgument = "JAVA_CALL".equals(SemanticAnalyzer.normalizeString(functionName, false));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = Assert.notNullUnchecked(ctx.getChild(i));
            if (child == ctx.functionArgs()) {
                RelationalParser.FunctionArgsContext args = (RelationalParser.FunctionArgsContext)child;
                for (int j = 0; j < args.getChildCount(); ++j) {
                    ParseTree arg = args.getChild(j);
                    if (j == 0 && skipFirstFunctionArgument) {
                        this.sqlCanonicalizer.append(arg.getText()).append(" ");
                        this.hashFunction.putBytes(arg.getText().getBytes(StandardCharsets.UTF_8));
                        continue;
                    }
                    arg.accept(this);
                }
                continue;
            }
            child.accept(this);
        }
        return null;
    }

    @Override
    public Object visitPreparedStatementParameter(@Nonnull RelationalParser.PreparedStatementParameterContext ctx) {
        Object param;
        if (ctx.QUESTION() != null) {
            int currentUnnamedParameterIndex = this.preparedStatementParameters.currentUnnamedParamIndex();
            param = this.preparedStatementParameters.nextUnnamedParamValue();
            if (param instanceof Array || param instanceof Struct) {
                this.allowLiteralAddition = false;
            }
            this.processUnnamedParameter(param, currentUnnamedParameterIndex, ctx.getStart().getTokenIndex());
            if (param instanceof Array || param instanceof Struct) {
                this.allowLiteralAddition = true;
            }
            if (param instanceof Array) {
                this.allowTokenAddition = false;
                this.processArrayParameter((Array)param, currentUnnamedParameterIndex, null, ctx.getStart().getTokenIndex());
                this.allowTokenAddition = true;
            } else if (param instanceof Struct) {
                this.allowTokenAddition = false;
                this.processStructParameter((Struct)param, currentUnnamedParameterIndex, null, ctx.getStart().getTokenIndex());
                this.allowTokenAddition = true;
            }
        } else {
            TerminalNode namedParameterContext = ctx.NAMED_PARAMETER();
            String parameterName = namedParameterContext.getText().substring(1);
            param = this.preparedStatementParameters.namedParamValue(parameterName);
            if (param instanceof Array || param instanceof Struct) {
                this.allowLiteralAddition = false;
            }
            this.processNamedParameter(param, parameterName, namedParameterContext.getSymbol().getTokenIndex());
            if (param instanceof Array || param instanceof Struct) {
                this.allowLiteralAddition = true;
            }
            if (param instanceof Array) {
                this.allowTokenAddition = false;
                this.processArrayParameter((Array)param, null, parameterName, ctx.getStart().getTokenIndex());
                this.allowTokenAddition = true;
            } else if (param instanceof Struct) {
                this.allowTokenAddition = false;
                this.processStructParameter((Struct)param, null, parameterName, ctx.getStart().getTokenIndex());
                this.allowTokenAddition = true;
            }
        }
        return param;
    }

    @Override
    public Object visitInPredicate(@Nonnull RelationalParser.InPredicateContext ctx) {
        ctx.IN().accept(this);
        if (ctx.inList().preparedStatementParameter() != null) {
            this.visit(ctx.inList().preparedStatementParameter());
        } else {
            this.sqlCanonicalizer.append("( ");
            if (ParseHelpers.isConstant(ctx.inList().expressions())) {
                this.queryHasherContextBuilder.getLiteralsBuilder().startArrayLiteral();
                this.allowTokenAddition = false;
                this.sqlCanonicalizer.append("[ ");
                for (int i = 0; i < ctx.inList().expressions().expression().size(); ++i) {
                    this.visit(ctx.inList().expressions().expression(i));
                }
                this.queryHasherContextBuilder.getLiteralsBuilder().finishArrayLiteral(null, null, true, ctx.inList().getStart().getTokenIndex());
                this.allowTokenAddition = true;
                this.sqlCanonicalizer.append("] ");
            } else {
                int size = ctx.inList().expressions().expression().size();
                for (int i = 0; i < size; ++i) {
                    this.visit(ctx.inList().expressions().expression(i));
                    if (i >= size - 1) continue;
                    this.sqlCanonicalizer.append(", ");
                }
            }
            this.sqlCanonicalizer.append(") ");
        }
        return null;
    }

    @Override
    public Object visitExecuteContinuationStatement(@Nonnull RelationalParser.ExecuteContinuationStatementContext ctx) {
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.IS_EXECUTE_CONTINUATION_STATEMENT);
        this.queryCachingFlags.add(NormalizationResult.QueryCachingFlags.WITH_NO_CACHE_OPTION);
        if (ctx.queryOptions() != null) {
            ctx.queryOptions().accept(this);
        }
        return ctx.packageBytes.accept(this);
    }

    private void processArrayParameter(@Nonnull Array param, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        try {
            this.queryHasherContextBuilder.getLiteralsBuilder().startArrayLiteral();
            try (ResultSet rs = param.getResultSet();){
                int i = 0;
                while (rs.next()) {
                    this.processParameterValue(rs.getObject(2), unnamedParameterIndex, parameterName, i);
                    ++i;
                }
            }
            this.queryHasherContextBuilder.getLiteralsBuilder().finishArrayLiteral(unnamedParameterIndex, parameterName, true, tokenIndex);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void processStructParameter(@Nonnull Struct param, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        try {
            this.queryHasherContextBuilder.getLiteralsBuilder().startStructLiteral();
            Object[] attributes = param.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                this.processParameterValue(attributes[i], unnamedParameterIndex, parameterName, i);
            }
            Type resolvedType = DataTypeUtils.toRecordLayerType(((RelationalStruct)param).getMetaData().getRelationalDataType());
            this.queryHasherContextBuilder.getLiteralsBuilder().finishStructLiteral((Type.Record)resolvedType, unnamedParameterIndex, parameterName, tokenIndex);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void processParameterValue(@Nonnull Object parameterValue, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        if (parameterValue instanceof Array) {
            this.processArrayParameter((Array)parameterValue, unnamedParameterIndex, parameterName, tokenIndex);
        } else if (parameterValue instanceof Struct) {
            this.processStructParameter((Struct)parameterValue, unnamedParameterIndex, parameterName, tokenIndex);
        } else {
            this.processScalarLiteral(parameterValue, tokenIndex);
        }
    }

    private void processScalarLiteral(@Nonnull Object literal, int tokenIndex) {
        this.processLiteral(literal, tokenIndex, null, null);
    }

    private void processUnnamedParameter(@Nonnull Object literal, int unnamedParameterIndex, int tokenIndex) {
        this.processLiteral(literal, tokenIndex, unnamedParameterIndex, null);
    }

    private void processNamedParameter(@Nonnull Object literal, @Nonnull String parameterName, int tokenIndex) {
        this.processLiteral(literal, tokenIndex, null, parameterName);
    }

    private void processLiteral(@Nonnull Object literal, int tokenIndex, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName) {
        if (this.allowLiteralAddition) {
            this.queryHasherContextBuilder.getLiteralsBuilder().addLiteral(Type.any(), literal, unnamedParameterIndex, parameterName, tokenIndex);
        }
        if (this.allowTokenAddition) {
            Object canonicalName = parameterName == null ? "?" : "?" + parameterName;
            this.sqlCanonicalizer.append((String)canonicalName).append(" ");
            this.parameterHash.putInt(Objects.hash(canonicalName, literal));
        }
    }

    @Nonnull
    public static NormalizationResult normalizeQuery(@Nonnull PlanContext context, @Nonnull String query, boolean isCaseSensitive, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) throws RelationalException {
        MetricCollector metricCollector = context.getMetricsCollector();
        RelationalParser.RootContext rootContext = metricCollector.clock(RelationalMetric.RelationalEvent.LEX_PARSE, () -> QueryParser.parse(query).getRootContext());
        return metricCollector.clock(RelationalMetric.RelationalEvent.NORMALIZE_QUERY, () -> AstNormalizer.normalizeAst(context.getSchemaTemplate(), rootContext, PreparedParams.copyOf(context.getPreparedStatementParameters()), context.getUserVersion(), context.getPlannerConfiguration(), isCaseSensitive, currentPlanHashMode, query));
    }

    @Nonnull
    @VisibleForTesting
    public static NormalizationResult normalizeAst(@Nonnull SchemaTemplate schemaTemplate, @Nonnull RelationalParser.RootContext context, @Nonnull PreparedParams preparedStatementParameters, int userVersion, @Nonnull PlannerConfiguration plannerConfiguration, boolean caseSensitive, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode, @Nonnull String query) {
        AstNormalizer astNormalizer = new AstNormalizer(preparedStatementParameters, caseSensitive, currentPlanHashMode);
        astNormalizer.visit(context);
        RecordLayerSchemaTemplate recordLayerSchemaTemplate = Assert.castUnchecked(schemaTemplate, RecordLayerSchemaTemplate.class);
        for (InvokedRoutine invokedRoutine : recordLayerSchemaTemplate.getTemporaryInvokedRoutines()) {
            if (!(invokedRoutine instanceof RecordLayerInvokedRoutine)) continue;
            RecordLayerInvokedRoutine recordLayerRoutine = (RecordLayerInvokedRoutine)invokedRoutine;
            CompiledSqlFunction compiledFunction = recordLayerRoutine.getCompilableSqlFunctionSupplier().apply(caseSensitive);
            astNormalizer.queryHasherContextBuilder.getLiteralsBuilder().importLiterals(compiledFunction.getAuxiliaryLiterals());
        }
        return new NormalizationResult(recordLayerSchemaTemplate.getName(), QueryCacheKey.of(astNormalizer.getCanonicalSqlString(), plannerConfiguration, recordLayerSchemaTemplate.getTransactionBoundMetadataAsString(), astNormalizer.getHash(), recordLayerSchemaTemplate.getVersion(), userVersion), astNormalizer.getQueryExecutionParameters(), context, astNormalizer.getQueryCachingFlags(), astNormalizer.getQueryOptions(), query);
    }

    static {
        literalNodes.put(RelationalParser.BooleanLiteralContext.class, context -> {
            RelationalParser.BooleanLiteralContext ctx = (RelationalParser.BooleanLiteralContext)context;
            return ctx.FALSE() == null;
        });
        literalNodes.put(RelationalParser.BytesConstantContext.class, context -> ParseHelpers.parseBytes(context.getText()));
        literalNodes.put(RelationalParser.StringConstantContext.class, context -> SemanticAnalyzer.normalizeString(context.getText(), false));
        literalNodes.put(RelationalParser.DecimalConstantContext.class, context -> ParseHelpers.parseDecimal(context.getText()));
        literalNodes.put(RelationalParser.NegativeDecimalConstantContext.class, context -> ParseHelpers.parseDecimal(context.getText()));
    }

    public static final class NormalizationResult {
        @Nonnull
        private final String schemaTemplateName;
        @Nonnull
        private final QueryCacheKey queryCacheKey;
        @Nonnull
        private final QueryExecutionContext queryExecutionContext;
        @Nonnull
        private final ParseTree parseTree;
        @Nonnull
        private final Set<QueryCachingFlags> queryCachingFlags;
        @Nonnull
        private final Options queryOptions;
        @Nonnull
        private final String query;

        public NormalizationResult(@Nonnull String schemaTemplateName, @Nonnull QueryCacheKey queryCacheKey, @Nonnull QueryExecutionContext queryExecutionContext, @Nonnull ParseTree parseTree, @Nonnull Set<QueryCachingFlags> queryCachingFlags, @Nonnull Options queryOptions, @Nonnull String query) {
            this.schemaTemplateName = schemaTemplateName;
            this.queryCacheKey = queryCacheKey;
            this.queryExecutionContext = queryExecutionContext;
            this.parseTree = parseTree;
            this.queryCachingFlags = queryCachingFlags;
            this.queryOptions = queryOptions;
            this.query = query;
        }

        @Nonnull
        public String getSchemaTemplateName() {
            return this.schemaTemplateName;
        }

        @Nonnull
        public QueryCacheKey getQueryCacheKey() {
            return this.queryCacheKey;
        }

        @Nonnull
        public QueryExecutionContext getQueryExecutionContext() {
            return this.queryExecutionContext;
        }

        @Nonnull
        public ParseTree getParseTree() {
            return this.parseTree;
        }

        @Nonnull
        public Set<QueryCachingFlags> getQueryCachingFlags() {
            return this.queryCachingFlags;
        }

        @Nonnull
        public Options getQueryOptions() {
            return this.queryOptions;
        }

        @Nonnull
        public String getQuery() {
            return this.query;
        }

        public static enum QueryCachingFlags {
            IS_DDL_STATEMENT,
            IS_UPDATE_STATEMENT,
            IS_DELETE_STATEMENT,
            IS_INSERT_STATEMENT,
            IS_DQL_STATEMENT,
            IS_UTILITY_STATEMENT,
            IS_ADMIN_STATEMENT,
            IS_EXECUTE_CONTINUATION_STATEMENT,
            WITH_NO_CACHE_OPTION;

        }
    }
}

