/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AccessHint;
import com.apple.foundationdb.record.query.plan.cascades.IndexAccessHint;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class CatalogKey {
    @Nonnull
    private final Identifier identifier;
    @Nonnull
    private final Set<AccessHint> hints;

    private CatalogKey(@Nonnull Identifier identifier, @Nonnull Set<AccessHint> hints) {
        this.identifier = identifier;
        this.hints = hints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogKey that = (CatalogKey)o;
        return Objects.equals(this.getIdentifier(), that.getIdentifier()) && Objects.equals(this.getHints(), that.getHints());
    }

    public int hashCode() {
        return Objects.hash(this.getIdentifier(), this.getHints());
    }

    @Nonnull
    public static CatalogKey of(@Nonnull Identifier identifier, @Nonnull Set<String> requestedIndexes) {
        return new CatalogKey(identifier, requestedIndexes.stream().map(IndexAccessHint::new).collect(ImmutableSet.toImmutableSet()));
    }

    @Nonnull
    public static CatalogKey of(@Nonnull Identifier identifier) {
        return new CatalogKey(identifier, ImmutableSet.of());
    }

    @Nonnull
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public Set<AccessHint> getHints() {
        return this.hints;
    }
}

