/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.AndOrValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NotValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RelOpValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.query.EphemeralExpression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class Expression {
    @Nonnull
    private final Optional<Identifier> name;
    @Nonnull
    private final DataType dataType;
    @Nonnull
    private final Supplier<Value> underlying;

    public Expression(@Nonnull Optional<Identifier> name, @Nonnull DataType dataType, @Nonnull Value expression) {
        this(name, dataType, () -> expression);
    }

    public Expression(@Nonnull Optional<Identifier> name, @Nonnull DataType dataType, @Nonnull Supplier<Value> valueSupplier) {
        this.name = name;
        this.dataType = dataType;
        this.underlying = Suppliers.memoize(valueSupplier::get);
    }

    @Nonnull
    public Optional<Identifier> getName() {
        return this.name;
    }

    @Nonnull
    public DataType getDataType() {
        return this.dataType;
    }

    @Nonnull
    public Value getUnderlying() {
        return this.underlying.get();
    }

    @Nonnull
    public Expression withName(@Nonnull Identifier name) {
        if (this.getName().isPresent() && this.getName().get().equals(name)) {
            return this;
        }
        return new Expression(Optional.of(name), this.getDataType(), this.getUnderlying());
    }

    @Nonnull
    public Expression withUnderlying(@Nonnull Value underlying) {
        if (this.getUnderlying().semanticEquals((Object)underlying, AliasMap.identitiesFor(underlying.getCorrelatedTo()))) {
            return this;
        }
        return new Expression(this.getName(), DataTypeUtils.toRelationalType(underlying.getResultType()), underlying);
    }

    @Nonnull
    public Expression clearQualifier() {
        if (this.getName().isEmpty()) {
            return this;
        }
        Identifier name = this.getName().get();
        if (!name.isQualified()) {
            return this;
        }
        return new Expression(Optional.of(name.withoutQualifier()), this.getDataType(), this.getUnderlying());
    }

    @Nonnull
    public Expression withQualifier(@Nonnull Collection<String> qualifier) {
        return this.replaceQualifier(ignored -> qualifier);
    }

    @Nonnull
    public Expression replaceQualifier(@Nonnull Function<Collection<String>, Collection<String>> replaceFunc) {
        if (this.getName().isEmpty()) {
            return this;
        }
        Identifier name = this.getName().get();
        Identifier newNameMaybe = name.replaceQualifier(replaceFunc);
        if (newNameMaybe.equals(name)) {
            return this;
        }
        return new Expression(Optional.of(newNameMaybe), this.getDataType(), this.getUnderlying());
    }

    @Nonnull
    public Expression withQualifier(@Nonnull Optional<Identifier> qualifier) {
        if (this.getName().isEmpty()) {
            return this;
        }
        Identifier name = this.getName().get();
        if (qualifier.isEmpty() && !name.isQualified()) {
            return this;
        }
        if (name.isQualified() && qualifier.isPresent() && qualifier.get().fullyQualifiedName().equals(name.getQualifier())) {
            return this;
        }
        if (qualifier.isEmpty()) {
            return new Expression(Optional.of(name.withoutQualifier()), this.getDataType(), this.getUnderlying());
        }
        Identifier newName = name.withQualifier(qualifier.get().fullyQualifiedName());
        return new Expression(Optional.of(newName), this.getDataType(), this.getUnderlying());
    }

    public boolean isAggregate() {
        return this.underlying instanceof AggregateValue && !(this.underlying instanceof RecordConstructorValue);
    }

    @Nonnull
    public NamedArgumentExpression toNamedArgument(@Nonnull Identifier name) {
        return new NamedArgumentExpression(name, this.dataType, this.getUnderlying());
    }

    @Nonnull
    public NamedArgumentExpression toNamedArgument() {
        return this.toNamedArgument(Assert.optionalUnchecked(this.getName()));
    }

    public boolean isNamedArgument() {
        return false;
    }

    @Nonnull
    public Expression pullUp(@Nonnull Value value, @Nonnull CorrelationIdentifier correlationIdentifier, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        AliasMap aliasMap = AliasMap.identitiesFor(value.getCorrelatedTo());
        Value simplifiedValue = value.simplify(EvaluationContext.empty(), aliasMap, constantAliases);
        Value underlying = this.getUnderlying();
        Value pulledUpUnderlying = Assert.notNullUnchecked((Value)underlying.replace(subExpression -> {
            Map<Value, Value> pulledUpExpressionMap = simplifiedValue.pullUp(List.of(subExpression), EvaluationContext.empty(), aliasMap, constantAliases, correlationIdentifier);
            if (pulledUpExpressionMap.containsKey(subExpression)) {
                return pulledUpExpressionMap.get(subExpression);
            }
            return subExpression;
        }));
        return this.withUnderlying(pulledUpUnderlying);
    }

    public boolean canBeDerivedFrom(@Nonnull Expression expression, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        Value value = expression.getUnderlying();
        AliasMap aliasMap = AliasMap.identitiesFor(value.getCorrelatedTo());
        Value simplifiedValue = value.simplify(EvaluationContext.empty(), aliasMap, constantAliases);
        Value thisValue = this.getUnderlying();
        CorrelationIdentifier quantifier = CorrelationIdentifier.uniqueId();
        Map<Value, Value> result = simplifiedValue.pullUp(ImmutableList.of(thisValue), EvaluationContext.empty(), aliasMap, constantAliases, quantifier);
        return result.containsKey(thisValue);
    }

    @Nonnull
    public Expressions dereferenced(@Nonnull Literals literals) {
        return Expressions.ofSingle(this.withUnderlying(Assert.notNullUnchecked((Value)this.underlying.get().replace(value -> {
            if (value instanceof ConstantObjectValue) {
                ConstantObjectValue constantObjectValue = (ConstantObjectValue)value;
                return new LiteralValue<Object>(constantObjectValue.getResultType(), literals.asMap().get(constantObjectValue.getConstantId()));
            }
            return value;
        }))));
    }

    @Nonnull
    public EphemeralExpression asEphemeral() {
        Verify.verify(this.getName().isPresent());
        return new EphemeralExpression(this.getName().get(), this.getDataType(), this.getUnderlying());
    }

    public String toString() {
        return String.valueOf(this.getName().orElse(Identifier.of("??"))) + "|" + String.valueOf(this.getDataType()) + "| \u21fe " + String.valueOf(this.getUnderlying());
    }

    @Nonnull
    public static Expression ofUnnamed(@Nonnull Value value) {
        return Expression.ofUnnamed(DataTypeUtils.toRelationalType(value.getResultType()), value);
    }

    @Nonnull
    public static Expression of(@Nonnull Value value, @Nonnull Identifier identifier) {
        return new Expression(Optional.of(identifier), DataTypeUtils.toRelationalType(value.getResultType()), value);
    }

    @Nonnull
    public static Expression ofUnnamed(@Nonnull DataType dataType, @Nonnull Value expression) {
        return new Expression(Optional.empty(), dataType, expression);
    }

    @Nonnull
    public static Expression fromUnderlying(@Nonnull Value underlying) {
        return new Expression(Optional.empty(), DataTypeUtils.toRelationalType(underlying.getResultType()), underlying);
    }

    @Nonnull
    public static Expression fromColumn(@Nonnull Column<? extends Value> column) {
        Expression result = Expression.ofUnnamed(column.getValue());
        if (column.getField().getFieldNameOptional().isPresent()) {
            return result.withName(Identifier.of(column.getField().getFieldName()));
        }
        return result;
    }

    public static final class NamedArgumentExpression
    extends Expression {
        private NamedArgumentExpression(@Nonnull Identifier name, @Nonnull DataType dataType, @Nonnull Value expression) {
            super(Optional.of(name), dataType, expression);
        }

        @Nonnull
        public Identifier getArgumentName() {
            return Assert.optionalUnchecked(this.getName());
        }

        @Override
        public boolean isNamedArgument() {
            return true;
        }

        @Override
        @Nonnull
        public NamedArgumentExpression toNamedArgument(@Nonnull Identifier name) {
            if (name.equals(this.getArgumentName())) {
                return this;
            }
            return new NamedArgumentExpression(name, this.getDataType(), this.getUnderlying());
        }
    }

    public static final class Utils {
        private Utils() {
        }

        @Nonnull
        public static Iterable<Value> filterUnderlyingAggregates(@Nonnull Expression expression) {
            return Utils.filterUnderlying(expression, true);
        }

        @Nonnull
        public static Iterable<Value> filterUnderlyingNonAggregates(@Nonnull Expression expression) {
            return Utils.filterUnderlying(expression, false);
        }

        @Nonnull
        private static Iterable<Value> filterUnderlying(@Nonnull Expression expression, boolean onlyAggregates) {
            return Streams.stream(expression.getUnderlying().preOrderIterator(value -> value instanceof ArithmeticValue || value instanceof AndOrValue || value instanceof NotValue || value instanceof RecordConstructorValue || value instanceof RelOpValue)).filter(leaf -> onlyAggregates == (!leaf.getResultType().isRecord() && leaf instanceof AggregateValue)).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        public static QueryPredicate toUnderlyingPredicate(@Nonnull Expression expression, @Nonnull Set<CorrelationIdentifier> localAliases, boolean forDdl) {
            BooleanValue value = Assert.castUnchecked(expression.getUnderlying(), BooleanValue.class);
            if (forDdl) {
                Optional<QueryPredicate> result = value.toQueryPredicate(ParseHelpers.EMPTY_TYPE_REPOSITORY, localAliases);
                Assert.thatUnchecked(result.isPresent());
                return result.get();
            }
            Optional<QueryPredicate> result = value.toQueryPredicate(null, localAliases);
            Assert.thatUnchecked(result.isPresent());
            return result.get();
        }
    }
}

