/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.recordlayer.query.EphemeralExpression;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.Star;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class Expressions
implements Iterable<Expression> {
    @Nonnull
    private static final Expressions EMPTY = new Expressions(ImmutableList.of());
    @Nonnull
    private final List<Expression> underlying;

    private Expressions(@Nonnull Iterable<Expression> underlying) {
        this.underlying = ImmutableList.copyOf(underlying);
    }

    @Override
    @Nonnull
    public Iterator<Expression> iterator() {
        return this.underlying.iterator();
    }

    @Nonnull
    public Expressions expanded() {
        return Expressions.of(this.underlying.stream().flatMap(item -> item instanceof Star ? ((Star)item).getExpansion().stream() : Stream.of(item)).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public Expressions rewireQov(@Nonnull Value value) {
        ImmutableList.Builder pulledUpOutputBuilder = ImmutableList.builder();
        int colCount = 0;
        for (Expression expression : this) {
            FieldValue newUnderlying = FieldValue.ofOrdinalNumber(value, colCount);
            pulledUpOutputBuilder.add(expression.withUnderlying(newUnderlying));
            ++colCount;
        }
        return Expressions.of(pulledUpOutputBuilder.build());
    }

    @Nonnull
    public Expressions pullUp(@Nonnull Value value, @Nonnull CorrelationIdentifier correlationIdentifier, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        ImmutableList.Builder pulledUpOutputBuilder = ImmutableList.builder();
        AliasMap aliasMap = AliasMap.identitiesFor(value.getCorrelatedTo());
        Value simplifiedValue = value.simplify(EvaluationContext.empty(), aliasMap, constantAliases);
        for (Expression expression : this) {
            Value underlying = expression.getUnderlying();
            Value pulledUpUnderlying = Assert.notNullUnchecked((Value)underlying.replace(subExpression -> {
                Map<Value, Value> pulledUpExpressionMap = simplifiedValue.pullUp(List.of(subExpression), EvaluationContext.empty(), aliasMap, constantAliases, correlationIdentifier);
                if (pulledUpExpressionMap.containsKey(subExpression)) {
                    return pulledUpExpressionMap.get(subExpression);
                }
                return subExpression;
            }));
            pulledUpOutputBuilder.add(expression.withUnderlying(pulledUpUnderlying));
        }
        return Expressions.of(pulledUpOutputBuilder.build());
    }

    @Nonnull
    public Expressions difference(@Nonnull Expressions that, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        if (Iterables.isEmpty(that)) {
            return this;
        }
        if (Iterables.isEmpty(this)) {
            return Expressions.empty();
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (Expression thisExpression : this.expanded()) {
            boolean foundDerivation = false;
            for (Expression thatExpression : that.expanded()) {
                if (!thisExpression.canBeDerivedFrom(thatExpression, constantAliases)) continue;
                foundDerivation = true;
                break;
            }
            if (foundDerivation) continue;
            resultBuilder.add(thisExpression);
        }
        return Expressions.of(resultBuilder.build());
    }

    @Nonnull
    public Expressions concat(@Nonnull Expressions other) {
        return Expressions.of(Iterables.concat(this.underlying, other.underlying));
    }

    @Nonnull
    public Expressions concat(@Nonnull Expression expression) {
        return Expressions.of(Iterables.concat(this.underlying, ImmutableList.of(expression)));
    }

    @Nonnull
    public Expressions dereferenced(@Nonnull Literals literals) {
        return Expressions.of(this.stream().flatMap(e -> e.dereferenced(literals).stream()).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public Expressions nonEphemeral() {
        return Expressions.of(this.stream().filter(e -> !(e instanceof EphemeralExpression)).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public Expression getSingleItem() {
        Assert.thatUnchecked(this.size() == 1, "invalid attempt to get single item");
        return this.asList().get(0);
    }

    @Nonnull
    public Set<Value> collectAggregateValues() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (Expression expression : this) {
            resultBuilder.addAll(Expression.Utils.filterUnderlyingAggregates(expression));
        }
        return resultBuilder.build();
    }

    @Nonnull
    public Expressions replaceQualifier(@Nonnull Function<Collection<String>, Collection<String>> replaceFunc) {
        return Expressions.of(this.underlying.stream().map(expression -> expression.replaceQualifier(replaceFunc)).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public Expressions withQualifier(@Nonnull Identifier qualifier) {
        return Expressions.of(this.underlying.stream().map(expression -> expression.withQualifier(Optional.of(qualifier))).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public Expressions clearQualifier() {
        return Expressions.of(this.underlying.stream().map(Expression::clearQualifier).collect(ImmutableList.toImmutableList()));
    }

    public boolean isEmpty() {
        return this == Expressions.empty() || Iterables.isEmpty(this);
    }

    public int size() {
        return this.underlying.size();
    }

    @Nonnull
    public Iterable<Value> underlying() {
        return Streams.stream(this).map(Expression::getUnderlying).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public List<Type> underlyingTypes() {
        return Streams.stream(this.underlying()).map(Value::getResultType).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Stream<Expression> stream() {
        return this.underlying.stream();
    }

    @Nonnull
    public Collection<Column<? extends Value>> underlyingAsColumns() {
        return Streams.stream(this).map(expression -> Column.of(expression.getName().map(Identifier::getName), expression.getUnderlying())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Iterable<Value> underlyingRebased(@Nonnull CorrelationIdentifier source, @Nonnull CorrelationIdentifier target) {
        AliasMap aliasMap = AliasMap.ofAliases(source, target);
        return Streams.stream(this.underlying()).map(value -> value.rebase(aliasMap)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public List<Expression> asList() {
        return this.underlying;
    }

    @Nonnull
    public Expressions asNamedArguments() {
        return Expressions.of(Streams.stream(this).map(Expression::toNamedArgument).collect(ImmutableList.toImmutableList()));
    }

    public boolean allNamedArguments() {
        return Streams.stream(this).allMatch(Expression::isNamedArgument);
    }

    @Nonnull
    public List<String> argumentNames() {
        Assert.thatUnchecked(this.allNamedArguments());
        return Streams.stream(this).map(Expression::getName).flatMap(Optional::stream).map(Identifier::toString).collect(ImmutableList.toImmutableList());
    }

    public boolean noneNamedArguments() {
        return Streams.stream(this).noneMatch(Expression::isNamedArgument);
    }

    @Nonnull
    public Map<String, Value> toNamedArgumentInvocation() {
        Assert.thatUnchecked(this.allNamedArguments());
        ImmutableMap.Builder<String, Value> resultBuilder = ImmutableMap.builder();
        for (Expression argument : this) {
            Optional<Identifier> argumentName = argument.getName();
            Verify.verify(argumentName.isPresent());
            resultBuilder.put(argumentName.get().toString(), argument.getUnderlying());
        }
        return resultBuilder.build();
    }

    public String toString() {
        return this.underlying.stream().map(Expression::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Nonnull
    public static Expressions of(@Nonnull Iterable<Expression> expressions) {
        return new Expressions(expressions);
    }

    @Nonnull
    public static Expressions of(@Nonnull Expression[] expressions) {
        ImmutableList<Expression> expressionsList = ImmutableList.copyOf(expressions);
        return Expressions.of(expressionsList);
    }

    @Nonnull
    public static Expressions ofSingle(@Nonnull Expression expression) {
        return new Expressions(ImmutableList.of(expression));
    }

    @Nonnull
    public static Expressions fromQuantifier(@Nonnull Quantifier quantifier) {
        return Expressions.of(quantifier.getFlowedColumns().stream().map(Expression::fromColumn).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public static Expressions fromUnderlying(@Nonnull Iterable<Value> values) {
        return Expressions.of(Streams.stream(values).map(Expression::fromUnderlying).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public static Expressions empty() {
        return EMPTY;
    }
}

