/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.values.EmptyValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.TrieNode;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FieldValueTrieNode
extends TrieNode.AbstractTrieNode<FieldValue.ResolvedAccessor, Value, FieldValueTrieNode> {
    public FieldValueTrieNode(@Nonnull Value value, @Nullable Map<FieldValue.ResolvedAccessor, FieldValueTrieNode> childrenMap) {
        super(value, childrenMap);
    }

    public FieldValueTrieNode(@Nullable Map<FieldValue.ResolvedAccessor, FieldValueTrieNode> childrenMap) {
        this(EmptyValue.empty(), childrenMap);
    }

    public FieldValueTrieNode(@Nonnull Value value) {
        this(value, (Map<FieldValue.ResolvedAccessor, FieldValueTrieNode>)null);
    }

    public FieldValueTrieNode() {
        this(EmptyValue.empty(), (Map<FieldValue.ResolvedAccessor, FieldValueTrieNode>)null);
    }

    @Override
    @Nonnull
    public FieldValueTrieNode getThis() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldValueTrieNode)) {
            return false;
        }
        FieldValueTrieNode transformationTrieNode = (FieldValueTrieNode)o;
        return Objects.equals(this.getValue(), transformationTrieNode.getValue()) && Objects.equals(this.getChildrenMap(), transformationTrieNode.getChildrenMap());
    }

    public boolean semanticEquals(Object other, @Nonnull AliasMap equivalencesMap) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FieldValueTrieNode)) {
            return false;
        }
        FieldValueTrieNode otherFieldValueTrieNode = (FieldValueTrieNode)other;
        return FieldValueTrieNode.equalsNullable((Value)this.getValue(), (Value)otherFieldValueTrieNode.getValue(), (t2, o) -> t2.semanticEquals(o, equivalencesMap)) && FieldValueTrieNode.equalsNullable(this.getChildrenMap(), otherFieldValueTrieNode.getChildrenMap(), (t2, o) -> FieldValueTrieNode.semanticEqualsForChildrenMap(t2, o, equivalencesMap));
    }

    private static boolean semanticEqualsForChildrenMap(@Nonnull Map<FieldValue.ResolvedAccessor, FieldValueTrieNode> self, @Nonnull Map<FieldValue.ResolvedAccessor, FieldValueTrieNode> other, @Nonnull AliasMap equivalencesMap) {
        if (self.size() != other.size()) {
            return false;
        }
        for (Map.Entry<FieldValue.ResolvedAccessor, FieldValueTrieNode> entry : self.entrySet()) {
            FieldValueTrieNode otherNestedTrie;
            FieldValue.ResolvedAccessor ordinal = entry.getKey();
            FieldValueTrieNode selfNestedTrie = entry.getValue();
            if (selfNestedTrie.semanticEquals(otherNestedTrie = other.get(ordinal), equivalencesMap)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean equalsNullable(@Nullable T self, @Nullable T other, @Nonnull BiFunction<T, T, Boolean> nonNullableTest) {
        if (self == null && other == null) {
            return true;
        }
        if (self == null) {
            return false;
        }
        return nonNullableTest.apply(self, other);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getValue(), this.getChildrenMap());
    }

    public void validateNoOverlaps(@Nonnull Collection<FieldValueTrieNode> otherNodes) {
        Map children = this.getChildrenMap();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (FieldValueTrieNode otherNode : otherNodes) {
            Map otherChildren = otherNode.getChildrenMap();
            if (otherChildren == null || otherChildren.isEmpty()) continue;
            for (Map.Entry otherEntry : otherChildren.entrySet()) {
                if (!children.containsKey(otherEntry.getKey())) continue;
                throw new RelationalException("Index with multiple disconnected references to the same column are not supported", ErrorCode.UNSUPPORTED_OPERATION).toUncheckedWrappedException();
            }
        }
    }

    public boolean isLeaf() {
        Map children = this.getChildrenMap();
        return children == null || children.isEmpty();
    }

    @Nonnull
    public static FieldValueTrieNode computeTrieForFieldPaths(@Nonnull Collection<FieldValue.FieldPath> orderedFieldPaths) {
        return FieldValueTrieNode.computeTrieForFieldPaths(new FieldValue.FieldPath(ImmutableList.of()), orderedFieldPaths, Iterators.peekingIterator(orderedFieldPaths.iterator()));
    }

    @Nonnull
    private static FieldValueTrieNode computeTrieForFieldPaths(@Nonnull FieldValue.FieldPath prefix, @Nonnull Collection<FieldValue.FieldPath> orderedFieldPaths, @Nonnull PeekingIterator<FieldValue.FieldPath> orderedFieldPathIterator) {
        FieldValue.FieldPath fieldPath;
        if (orderedFieldPaths.contains(prefix)) {
            orderedFieldPathIterator.next();
            return new FieldValueTrieNode();
        }
        ImmutableMap.Builder<FieldValue.ResolvedAccessor, FieldValueTrieNode> childrenMapBuilder = ImmutableMap.builder();
        while (orderedFieldPathIterator.hasNext() && prefix.isPrefixOf(fieldPath = orderedFieldPathIterator.peek())) {
            List<FieldValue.ResolvedAccessor> prefixAccessors = prefix.getFieldAccessors();
            FieldValue.ResolvedAccessor currentAccessor = fieldPath.getFieldAccessors().get(prefixAccessors.size());
            FieldValue.FieldPath nestedPrefix = new FieldValue.FieldPath((List<FieldValue.ResolvedAccessor>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(prefixAccessors)).add(currentAccessor)).build()));
            FieldValueTrieNode currentTrie = FieldValueTrieNode.computeTrieForFieldPaths(nestedPrefix, orderedFieldPaths, orderedFieldPathIterator);
            childrenMapBuilder.put(currentAccessor, currentTrie);
        }
        return new FieldValueTrieNode(childrenMapBuilder.build());
    }

    @Nonnull
    public static FieldValueTrieNode computeTrieForValues(@Nonnull FieldValue.FieldPath prefix, @Nonnull PeekingIterator<Value> orderedValueIterator) {
        Value value;
        List<FieldValue.ResolvedAccessor> prefixAccessors = prefix.getFieldAccessors();
        ImmutableMap.Builder<FieldValue.ResolvedAccessor, FieldValueTrieNode> childrenMapBuilder = ImmutableMap.builder();
        while (orderedValueIterator.hasNext() && (value = orderedValueIterator.peek()) instanceof FieldValue) {
            FieldValue.FieldPath fieldPath = ((FieldValue)value).getFieldPath();
            if (prefix.equals(fieldPath)) {
                orderedValueIterator.next();
                return new FieldValueTrieNode(value);
            }
            if (!prefix.isPrefixOf(fieldPath)) break;
            FieldValue.ResolvedAccessor currentAccessor = fieldPath.getFieldAccessors().get(prefixAccessors.size());
            FieldValue.FieldPath nestedPrefix = new FieldValue.FieldPath((List<FieldValue.ResolvedAccessor>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builderWithExpectedSize(prefixAccessors.size() + 1).addAll(prefixAccessors)).add(currentAccessor)).build()));
            FieldValueTrieNode currentTrie = FieldValueTrieNode.computeTrieForValues(nestedPrefix, orderedValueIterator);
            childrenMapBuilder.put(currentAccessor, currentTrie);
        }
        try {
            return new FieldValueTrieNode(childrenMapBuilder.build());
        }
        catch (IllegalArgumentException e) {
            throw new RelationalException("Index with multiple disconnected references to the same column are not supported", ErrorCode.UNSUPPORTED_OPERATION, e).toUncheckedWrappedException();
        }
    }
}

