/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class Identifier {
    @Nonnull
    private final String name;
    @Nonnull
    private final List<String> qualifier;

    protected Identifier(@Nonnull String name, @Nonnull Iterable<String> qualifier) {
        this.name = name;
        this.qualifier = ImmutableList.copyOf(qualifier);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public List<String> getQualifier() {
        return this.qualifier;
    }

    public boolean isQualified() {
        return !this.qualifier.isEmpty();
    }

    public String toString() {
        return String.join((CharSequence)".", this.qualifier) + (this.qualifier.isEmpty() ? "" : ".") + this.name;
    }

    @Nonnull
    public static Identifier of(@Nonnull String name) {
        return new Identifier(name, ImmutableList.of());
    }

    @Nonnull
    public static Identifier of(@Nonnull String name, @Nonnull Iterable<String> qualifier) {
        return new Identifier(name, qualifier);
    }

    @Nonnull
    public Identifier withQualifier(@Nonnull Collection<String> qualifier) {
        if (qualifier.isEmpty()) {
            return this;
        }
        ImmutableList.Builder newQualifierBuilder = ImmutableList.builder();
        newQualifierBuilder.addAll(qualifier);
        newQualifierBuilder.addAll(this.getQualifier());
        return new Identifier(this.name, newQualifierBuilder.build());
    }

    @Nonnull
    public Identifier replaceQualifier(@Nonnull Function<Collection<String>, Collection<String>> replaceFunc) {
        Collection<String> replacingQualifier = replaceFunc.apply(this.qualifier);
        if (replacingQualifier.equals(this.qualifier)) {
            return this;
        }
        return new Identifier(this.name, replacingQualifier);
    }

    @Nonnull
    public Identifier withQualifier(@Nonnull String qualifier) {
        return this.withQualifier(List.of(qualifier));
    }

    @Nonnull
    public Identifier withoutQualifier() {
        if (!this.isQualified()) {
            return this;
        }
        return new Identifier(this.getName(), ImmutableList.of());
    }

    @Nonnull
    public List<String> fullyQualifiedName() {
        if (!this.isQualified()) {
            return List.of(this.name);
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getQualifier())).add(this.name)).build();
    }

    public boolean prefixedWith(@Nonnull Identifier identifier) {
        List<String> identifierFullName = identifier.fullyQualifiedName();
        List<String> fullName = this.fullyQualifiedName();
        if (fullName.size() < identifierFullName.size()) {
            return false;
        }
        for (int i = 0; i < identifierFullName.size(); ++i) {
            if (fullName.get(i).equals(identifierFullName.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean qualifiedWith(@Nonnull Identifier identifier) {
        List<String> identifierFullName = identifier.fullyQualifiedName();
        List<String> fullName = this.fullyQualifiedName();
        if (fullName.size() != identifierFullName.size() + 1) {
            return false;
        }
        for (int i = 0; i < identifierFullName.size(); ++i) {
            if (fullName.get(i).equals(identifierFullName.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier otherIdentifier = (Identifier)obj;
        return this.getName().equals(otherIdentifier.getName()) && this.getQualifier().equals(otherIdentifier.getQualifier());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getQualifier());
    }
}

