/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.IndexPredicate;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.VersionKeyExpression;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IndexPredicateExpansion;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.ReferencesAndDependenciesProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CountValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NumericAggregationValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.VersionValue;
import com.apple.foundationdb.record.query.plan.planning.BooleanPredicateNormalizer;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.query.FieldValueTrieNode;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.NullableArrayUtils;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class IndexGenerator {
    private static final String BITMAP_BIT_POSITION = "bitmap_bit_position";
    private static final String BITMAP_BUCKET_OFFSET = "bitmap_bucket_offset";
    @Nonnull
    private final IdentityHashMap<CorrelationIdentifier, Value> correlatedKeyExpressions = new IdentityHashMap();
    @Nonnull
    private final List<RelationalExpression> relationalExpressions;
    @Nonnull
    private final RelationalExpression relationalExpression;
    private final boolean useLegacyBasedExtremumEver;

    private IndexGenerator(@Nonnull RelationalExpression relationalExpression, boolean useLegacyBasedExtremumEver) {
        this.collectQuantifiers(relationalExpression);
        PartiallyOrderedSet<Reference> partialOrder = ReferencesAndDependenciesProperty.referencesAndDependencies().evaluate(Reference.initialOf(relationalExpression));
        this.relationalExpressions = TopologicalSort.anyTopologicalOrderPermutation(partialOrder).orElseThrow(() -> new RelationalException("graph has cycles", ErrorCode.UNSUPPORTED_OPERATION).toUncheckedWrappedException()).stream().map(Reference::get).collect(Collectors.toList());
        this.relationalExpression = relationalExpression;
        this.useLegacyBasedExtremumEver = useLegacyBasedExtremumEver;
    }

    @Nonnull
    public RecordLayerIndex generate(@Nonnull String indexName, boolean isUnique, @Nonnull Type.Record tableType, boolean containsNullableArray) {
        RecordLayerIndex.Builder indexBuilder = RecordLayerIndex.newBuilder().setName(indexName).setTableName(this.getRecordTypeName()).setUnique(isUnique);
        this.collectQuantifiers(this.relationalExpression);
        PartiallyOrderedSet<Reference> partialOrder = ReferencesAndDependenciesProperty.referencesAndDependencies().evaluate(Reference.initialOf(this.relationalExpression));
        List expressionRefs = TopologicalSort.anyTopologicalOrderPermutation(partialOrder).orElseThrow(() -> new RecordCoreException("graph has cycles", new Object[0])).stream().map(Reference::get).collect(Collectors.toList());
        this.checkValidity(expressionRefs);
        QueryPredicate predicate = IndexGenerator.getTopLevelPredicate(Lists.reverse(expressionRefs));
        if (predicate != null) {
            indexBuilder.setPredicate(IndexPredicate.fromQueryPredicate(predicate).toProto());
        }
        List<Value> simplifiedValues = this.collectResultValues(this.relationalExpression.getResultValue());
        List unsupportedAggregates = simplifiedValues.stream().filter(sv -> sv instanceof StreamableAggregateValue && !(sv instanceof IndexableAggregateValue)).collect(Collectors.toList());
        Assert.thatUnchecked(unsupportedAggregates.isEmpty(), ErrorCode.UNSUPPORTED_OPERATION, () -> String.format(Locale.ROOT, "Unsupported aggregate index definition containing non-indexable aggregation (%s), consider using a value index on the aggregated column instead.", unsupportedAggregates.stream().map(Objects::toString).collect(Collectors.joining(","))));
        Assert.thatUnchecked(simplifiedValues.stream().allMatch(sv -> sv instanceof FieldValue || sv instanceof IndexableAggregateValue || sv instanceof VersionValue || sv instanceof ArithmeticValue));
        List aggregateValues = simplifiedValues.stream().filter(sv -> sv instanceof IndexableAggregateValue).collect(Collectors.toList());
        List<Value> fieldValues = simplifiedValues.stream().filter(sv -> !(sv instanceof IndexableAggregateValue)).collect(Collectors.toList());
        List versionValues = simplifiedValues.stream().filter(sv -> sv instanceof VersionValue).map(sv -> (VersionValue)sv).collect(Collectors.toList());
        Assert.thatUnchecked(versionValues.size() <= 1, ErrorCode.UNSUPPORTED_OPERATION, "Cannot have index with more than one version column");
        IdentityHashMap<Value, String> orderingFunctions = new IdentityHashMap<Value, String>();
        List<Value> orderByValues = this.getOrderByValues(this.relationalExpression, orderingFunctions);
        if (aggregateValues.isEmpty()) {
            int splitPoint;
            indexBuilder.setIndexType(versionValues.isEmpty() ? "value" : "version");
            Assert.thatUnchecked(orderByValues.stream().allMatch(sv -> sv instanceof FieldValue || sv instanceof VersionValue || sv instanceof ArithmeticValue), ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, order by must be a subset of projection list");
            if (fieldValues.size() > 1) {
                Assert.thatUnchecked(!orderByValues.isEmpty(), ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, value indexes must have an order by clause at the top level");
            }
            List<Value> reordered = IndexGenerator.reorderValues(fieldValues, orderByValues);
            KeyExpression expression = this.generate(reordered, orderingFunctions);
            int n = splitPoint = orderByValues.isEmpty() ? -1 : orderByValues.size();
            if (splitPoint != -1 && splitPoint < fieldValues.size()) {
                indexBuilder.setKeyExpression(KeyExpression.fromProto(NullableArrayUtils.wrapArray(Key.Expressions.keyWithValue(expression, splitPoint).toKeyExpression(), tableType, containsNullableArray)));
            } else {
                indexBuilder.setKeyExpression(KeyExpression.fromProto(NullableArrayUtils.wrapArray(expression.toKeyExpression(), tableType, containsNullableArray)));
            }
        } else {
            Assert.thatUnchecked(aggregateValues.size() == 1, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, multiple group by aggregations found");
            AggregateValue aggregateValue = (AggregateValue)aggregateValues.get(0);
            int aggregateOrderIndex = -1;
            if (!orderByValues.isEmpty()) {
                boolean inOrder = true;
                Iterator<Value> fieldIterator = fieldValues.iterator();
                for (int i = 0; i < orderByValues.size(); ++i) {
                    Value value = orderByValues.get(i);
                    if (value.equals(aggregateValue)) {
                        if (aggregateOrderIndex >= 0) {
                            Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, aggregate can appear only once in ordering clause");
                        }
                        aggregateOrderIndex = i;
                        continue;
                    }
                    if (fieldIterator.hasNext()) {
                        Value expectedField = fieldIterator.next();
                        if (value.equals(expectedField)) continue;
                        inOrder = false;
                        break;
                    }
                    inOrder = false;
                    break;
                }
                if (fieldIterator.hasNext() || !inOrder) {
                    Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, attempt to create a covering aggregate index");
                }
            }
            Optional<KeyExpression> groupingKeyExpression = fieldValues.isEmpty() ? Optional.empty() : Optional.of(this.generate(fieldValues, orderingFunctions));
            NonnullPair<KeyExpression, String> indexExpressionAndType = this.generateAggregateIndexKeyExpression(aggregateValue, groupingKeyExpression);
            String indexType = Objects.requireNonNull(indexExpressionAndType.getRight());
            indexBuilder.setIndexType(indexType);
            indexBuilder.setKeyExpression(KeyExpression.fromProto(NullableArrayUtils.wrapArray(indexExpressionAndType.getLeft().toKeyExpression(), tableType, containsNullableArray)));
            if ("permuted_min".equals(indexType) || "permuted_max".equals(indexType)) {
                int permutedSize = aggregateOrderIndex < 0 ? 0 : fieldValues.size() - aggregateOrderIndex;
                indexBuilder.setOption("permutedSize", permutedSize);
            } else if (aggregateOrderIndex >= 0) {
                Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition. Cannot order " + indexType + " index by aggregate value");
            }
        }
        return indexBuilder.build();
    }

    @Nonnull
    private List<Value> collectResultValues(@Nonnull Value value) {
        List<Value> resultValues = this.simplify(value);
        boolean isSingleAggregation = resultValues.size() == 1 && resultValues.get(0) instanceof IndexableAggregateValue;
        Optional<RelationalExpression> maybeGroupBy = this.relationalExpressions.stream().filter(exp -> exp instanceof GroupByExpression).findFirst();
        if (maybeGroupBy.isPresent()) {
            GroupByExpression groupBy = (GroupByExpression)maybeGroupBy.get();
            Value groupingValues = groupBy.getGroupingValue();
            List<Value> adjustResultValues = IndexGenerator.adjustGroupByFieldPaths(resultValues, groupBy);
            if (isSingleAggregation) {
                if (groupingValues == null) {
                    return adjustResultValues;
                }
                Stream<Value> simplifiedGroupingValues = Values.deconstructRecord(groupingValues).stream().map(this::dereference).map(v -> v.simplify(EvaluationContext.empty(), AliasMap.emptyMap(), Set.of()));
                return Stream.concat(adjustResultValues.stream(), simplifiedGroupingValues).collect(Collectors.toList());
            }
            if (groupingValues == null) {
                Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Grouping values absent from aggregate result value");
            }
            Iterator simplifiedGroupingValues = Values.deconstructRecord(groupingValues).stream().map(this::dereference).map(v -> v.simplify(EvaluationContext.empty(), AliasMap.emptyMap(), Set.of())).iterator();
            for (Value resultValue : resultValues) {
                Value groupingValue;
                if (resultValue instanceof IndexableAggregateValue) continue;
                if (!simplifiedGroupingValues.hasNext()) {
                    Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Aggregate result value contains values missing from the grouping expression");
                }
                if (resultValue.equals(groupingValue = (Value)simplifiedGroupingValues.next())) continue;
                Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Aggregate result value does not align with grouping value");
            }
            if (simplifiedGroupingValues.hasNext()) {
                Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "Grouping value absent from aggregate result value");
            }
            return adjustResultValues;
        }
        return resultValues;
    }

    @Nonnull
    private static List<Value> adjustGroupByFieldPaths(@Nonnull List<Value> resultValues, @Nonnull GroupByExpression groupByExpression) {
        Quantifier selectWhereQun = groupByExpression.getQuantifiers().get(0);
        return resultValues.stream().map(resultValue -> (Value)resultValue.replace(value -> {
            if (!(value instanceof FieldValue)) {
                return value;
            }
            FieldValue fieldValue = (FieldValue)value;
            if (!(fieldValue.getChild() instanceof QuantifiedObjectValue)) {
                return value;
            }
            QuantifiedObjectValue quantifiedObjectValue = (QuantifiedObjectValue)fieldValue.getChild();
            if (!quantifiedObjectValue.getAlias().equals(selectWhereQun.getAlias())) {
                return value;
            }
            List<FieldValue.ResolvedAccessor> fieldAccessors = fieldValue.getFieldPath().getFieldAccessors();
            return FieldValue.ofFields(fieldValue.getChild(), new FieldValue.FieldPath(fieldAccessors.subList(1, fieldAccessors.size())));
        })).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private List<Value> simplify(@Nonnull Value value) {
        return Values.deconstructRecord(value).stream().map(this::dereference).map(v -> v.simplify(EvaluationContext.empty(), AliasMap.emptyMap(), Set.of())).collect(Collectors.toList());
    }

    @Nonnull
    private List<Value> getOrderByValues(@Nonnull RelationalExpression relationalExpression, @Nonnull Map<Value, String> orderingFunctions) {
        if (relationalExpression instanceof LogicalSortExpression) {
            LogicalSortExpression logicalSortExpression = (LogicalSortExpression)relationalExpression;
            AliasMap reverseAliasMap = AliasMap.ofAliases(Quantifier.current(), logicalSortExpression.getQuantifiers().get(0).getAlias());
            ImmutableList.Builder values = ImmutableList.builder();
            for (OrderingPart.RequestedOrderingPart orderingPart : logicalSortExpression.getOrdering().getOrderingParts()) {
                String orderingFunction;
                switch ((OrderingPart.RequestedSortOrder)orderingPart.getSortOrder()) {
                    case ASCENDING: {
                        orderingFunction = null;
                        break;
                    }
                    case DESCENDING: {
                        orderingFunction = "order_desc_nulls_last";
                        break;
                    }
                    case ASCENDING_NULLS_LAST: {
                        orderingFunction = "order_asc_nulls_last";
                        break;
                    }
                    case DESCENDING_NULLS_FIRST: {
                        orderingFunction = "order_desc_nulls_first";
                        break;
                    }
                    default: {
                        orderingFunction = null;
                    }
                }
                if (orderingPart.getValue().getResultType().getTypeCode() == Type.TypeCode.RECORD) {
                    for (Value value : Values.deconstructRecord(orderingPart.getValue())) {
                        Value rebased = this.dereference(value.rebase(reverseAliasMap)).simplify(EvaluationContext.empty(), AliasMap.emptyMap(), Set.of());
                        values.add(rebased);
                        if (orderingFunction == null) continue;
                        orderingFunctions.put(rebased, orderingFunction);
                    }
                    continue;
                }
                Value rebased = this.dereference(orderingPart.getValue().rebase(reverseAliasMap)).simplify(EvaluationContext.empty(), AliasMap.emptyMap(), Set.of());
                values.add(rebased);
                if (orderingFunction == null) continue;
                orderingFunctions.put(rebased, orderingFunction);
            }
            return values.build();
        }
        return List.of();
    }

    private static List<Value> reorderValues(@Nonnull List<Value> values, @Nonnull List<Value> orderByValues) {
        Assert.thatUnchecked(values.size() >= orderByValues.size());
        if (orderByValues.isEmpty()) {
            return values;
        }
        ImmutableList remaining = values.stream().filter(v -> !orderByValues.contains(v)).collect(ImmutableList.toImmutableList());
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(orderByValues)).addAll((Iterable)remaining)).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private NonnullPair<KeyExpression, String> generateAggregateIndexKeyExpression(@Nonnull AggregateValue aggregateValue, @Nonnull Optional<KeyExpression> maybeGroupingExpression) {
        Value indexValue;
        GroupingKeyExpression keyExpression;
        Assert.thatUnchecked(aggregateValue instanceof IndexableAggregateValue);
        IndexableAggregateValue indexableAggregateValue = (IndexableAggregateValue)((Object)aggregateValue);
        Value child = (Value)Iterables.getOnlyElement(aggregateValue.getChildren());
        String indexTypeName = indexableAggregateValue.getIndexTypeName();
        if (aggregateValue instanceof CountValue && "count".equals(indexTypeName)) {
            keyExpression = maybeGroupingExpression.isPresent() ? new GroupingKeyExpression(maybeGroupingExpression.get(), 0) : new GroupingKeyExpression(EmptyKeyExpression.EMPTY, 0);
        } else if (aggregateValue instanceof NumericAggregationValue.BitmapConstructAgg && "bitmap_value".equals(indexTypeName)) {
            Assert.thatUnchecked(child instanceof FieldValue || child instanceof ArithmeticValue, "Unsupported index definition, expecting a column argument in aggregation function");
            KeyExpression groupedValue = this.generate(List.of(child), Collections.emptyMap());
            Assert.thatUnchecked(groupedValue instanceof FunctionKeyExpression, "Unsupported index definition, expecting a bitmap_bit_position function in bitmap_construct_agg function");
            FunctionKeyExpression functionGroupedValue = (FunctionKeyExpression)groupedValue;
            Assert.thatUnchecked(BITMAP_BIT_POSITION.equals(functionGroupedValue.getName()), "Unsupported index definition, expecting a bitmap_bit_position function in bitmap_construct_agg function");
            KeyExpression groupedColumnValue = ((ThenKeyExpression)((FunctionKeyExpression)groupedValue).getArguments()).getChildren().get(0);
            if (!maybeGroupingExpression.isPresent()) throw Assert.failUnchecked("Unsupported index definition, unexpected grouping expression " + String.valueOf(groupedValue));
            KeyExpression afterRemove = this.removeBitmapBucketOffset(maybeGroupingExpression.get());
            keyExpression = afterRemove == null ? ((FieldKeyExpression)groupedColumnValue).ungrouped() : ((FieldKeyExpression)groupedColumnValue).groupBy(afterRemove, new KeyExpression[0]);
        } else {
            Assert.thatUnchecked(child instanceof FieldValue, "Unsupported index definition, expecting a column argument in aggregation function");
            KeyExpression groupedValue = this.generate(List.of(child), Collections.emptyMap());
            Assert.thatUnchecked(groupedValue instanceof FieldKeyExpression || groupedValue instanceof ThenKeyExpression);
            if (maybeGroupingExpression.isPresent()) {
                keyExpression = groupedValue instanceof FieldKeyExpression ? ((FieldKeyExpression)groupedValue).groupBy(maybeGroupingExpression.get(), new KeyExpression[0]) : ((ThenKeyExpression)groupedValue).groupBy(maybeGroupingExpression.get(), new KeyExpression[0]);
            } else {
                GroupingKeyExpression groupingKeyExpression = keyExpression = groupedValue instanceof FieldKeyExpression ? ((FieldKeyExpression)groupedValue).ungrouped() : ((ThenKeyExpression)groupedValue).ungrouped();
            }
        }
        if ("max_ever".equals(indexTypeName)) {
            if (this.useLegacyBasedExtremumEver) {
                indexValue = (Value)Iterables.getOnlyElement(indexableAggregateValue.getChildren());
                Verify.verify(indexValue.getResultType().isNumeric(), "only numeric types allowed in max_ever_long aggregation operation", new Object[0]);
                indexTypeName = "max_ever_long";
                return NonnullPair.of(keyExpression, indexTypeName);
            } else {
                indexTypeName = "max_ever_tuple";
            }
            return NonnullPair.of(keyExpression, indexTypeName);
        } else {
            if (!"min_ever".equals(indexTypeName)) return NonnullPair.of(keyExpression, indexTypeName);
            if (this.useLegacyBasedExtremumEver) {
                indexValue = (Value)Iterables.getOnlyElement(indexableAggregateValue.getChildren());
                Verify.verify(indexValue.getResultType().isNumeric(), "only numeric types allowed in min_ever_long aggregation operation", new Object[0]);
                indexTypeName = "min_ever_long";
                return NonnullPair.of(keyExpression, indexTypeName);
            } else {
                indexTypeName = "min_ever_tuple";
            }
        }
        return NonnullPair.of(keyExpression, indexTypeName);
    }

    @Nullable
    private KeyExpression removeBitmapBucketOffset(@Nonnull KeyExpression groupingExpression) {
        Assert.thatUnchecked(groupingExpression instanceof ThenKeyExpression || groupingExpression instanceof FunctionKeyExpression, "Unsupported index definition, expecting column or function arguments in group by");
        if (groupingExpression instanceof ThenKeyExpression) {
            List<KeyExpression> groupingChildren = ((ThenKeyExpression)groupingExpression).getChildren();
            Assert.thatUnchecked(groupingChildren.get(groupingChildren.size() - 1) instanceof FunctionKeyExpression && BITMAP_BUCKET_OFFSET.equals(((FunctionKeyExpression)groupingChildren.get(groupingChildren.size() - 1)).getName()), "Unsupported index definition, expecting the last element in group by to be a bitmap_bucket_offset function");
            if (groupingChildren.size() >= 3) {
                return new ThenKeyExpression(groupingChildren, 0, groupingChildren.size() - 1);
            }
            return groupingChildren.get(0);
        }
        if (BITMAP_BUCKET_OFFSET.equals(((FunctionKeyExpression)groupingExpression).getName())) {
            return null;
        }
        return groupingExpression;
    }

    @Nonnull
    private KeyExpression generate(@Nonnull List<Value> fields, @Nonnull Map<Value, String> orderingFunctions) {
        if (fields.isEmpty()) {
            return EmptyKeyExpression.EMPTY;
        }
        if (fields.size() == 1) {
            return this.toKeyExpression(fields.get(0), orderingFunctions);
        }
        ArrayList<FieldValueTrieNode> trieNodes = new ArrayList<FieldValueTrieNode>(fields.size());
        ArrayList<KeyExpression> components = new ArrayList<KeyExpression>(fields.size());
        PeekingIterator<Value> valueIterator = Iterators.peekingIterator(fields.iterator());
        while (valueIterator.hasNext()) {
            if (!(valueIterator.peek() instanceof FieldValue)) {
                components.add(this.toKeyExpression(valueIterator.next(), orderingFunctions));
                continue;
            }
            FieldValueTrieNode trieNode = FieldValueTrieNode.computeTrieForValues(FieldValue.FieldPath.empty(), valueIterator);
            trieNode.validateNoOverlaps(trieNodes);
            trieNodes.add(trieNode);
            components.add(IndexGenerator.toKeyExpression(trieNode, orderingFunctions));
        }
        if (components.size() == 1) {
            return (KeyExpression)components.get(0);
        }
        return Key.Expressions.concat(components);
    }

    @Nonnull
    private KeyExpression toKeyExpression(Value value, Map<Value, String> orderingFunctions) {
        KeyExpression expr = this.toKeyExpression(value);
        if (orderingFunctions.containsKey(value)) {
            return Key.Expressions.function(orderingFunctions.get(value), expr);
        }
        return expr;
    }

    @Nonnull
    private KeyExpression toKeyExpression(@Nonnull Value value) {
        if (value instanceof VersionValue) {
            return VersionKeyExpression.VERSION;
        }
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            return this.toKeyExpression(fieldValue.getFieldPath().getFieldAccessors().stream().map(acc -> Pair.of(acc.getName(), acc.getType())).collect(Collectors.toList()));
        }
        if (value instanceof ArithmeticValue) {
            Iterable children = value.getChildren();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Value child : children) {
                builder.add(this.toKeyExpression(child));
            }
            ImmutableCollection argumentList = builder.build();
            KeyExpression argumentExpr = argumentList.isEmpty() ? Key.Expressions.empty() : (argumentList.size() == 1 ? (KeyExpression)argumentList.get(0) : Key.Expressions.concat((List<KeyExpression>)((Object)argumentList)));
            return Key.Expressions.function(((ArithmeticValue)value).getLogicalOperator().name().toLowerCase(Locale.ROOT), argumentExpr);
        }
        if (value instanceof LiteralValue) {
            return Key.Expressions.value(((LiteralValue)value).getLiteralValue());
        }
        Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "unable to construct expression");
        return null;
    }

    @Nonnull
    private static KeyExpression toKeyExpression(@Nonnull FieldValueTrieNode trieNode, @Nonnull Map<Value, String> orderingFunctions) {
        Assert.notNullUnchecked(trieNode.getChildrenMap());
        Assert.thatUnchecked(!trieNode.getChildrenMap().isEmpty());
        Map childrenMap = trieNode.getChildrenMap();
        List<KeyExpression> exprConstituents = childrenMap.keySet().stream().map(key -> {
            FieldKeyExpression expr = IndexGenerator.toKeyExpression(Objects.requireNonNull(key.getName()), key.getType());
            FieldValueTrieNode value = (FieldValueTrieNode)childrenMap.get(key);
            if (value.getChildrenMap() != null) {
                return expr.nest(IndexGenerator.toKeyExpression(value, orderingFunctions));
            }
            if (orderingFunctions.containsKey(value.getValue())) {
                return Key.Expressions.function((String)orderingFunctions.get(value.getValue()), expr);
            }
            return expr;
        }).map(v -> v).collect(Collectors.toList());
        if (exprConstituents.size() == 1) {
            return exprConstituents.get(0);
        }
        return Key.Expressions.concat(exprConstituents);
    }

    private void checkValidity(@Nonnull List<? extends RelationalExpression> expressions) {
        long numScans = expressions.stream().filter(r -> r instanceof FullUnorderedScanExpression).count();
        Assert.thatUnchecked(numScans == 1L, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, %s iteration generator found", numScans == 0L ? "no" : "more than one");
        long numGroupBy = expressions.stream().filter(r -> r instanceof GroupByExpression).count();
        Assert.thatUnchecked(numGroupBy <= 1L, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, multiple group by expressions found");
        boolean groupByContainsOneAggregation = expressions.stream().filter(r -> r instanceof GroupByExpression).map(r -> (GroupByExpression)r).noneMatch(g2 -> Values.deconstructRecord(g2.getAggregateValue()).size() > 1);
        Assert.thatUnchecked(groupByContainsOneAggregation, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, found group by expression with more than one aggregation");
        boolean allRecordValues = expressions.stream().allMatch(r -> r.getResultValue().getResultType().getTypeCode() == Type.TypeCode.RECORD);
        Assert.thatUnchecked(allRecordValues, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, some operators return non-record values");
        boolean allSimpleValues = expressions.stream().filter(r -> r.getResultType().getInnerType() instanceof Type.Record).allMatch(r -> Values.deconstructRecord(r.getResultValue()).stream().allMatch(v -> v instanceof FieldValue || v instanceof VersionValue || v instanceof QuantifiedObjectValue || v instanceof AggregateValue || v instanceof ArithmeticValue || v instanceof LiteralValue));
        Assert.thatUnchecked(allSimpleValues, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, not all fields can be mapped to key expression in");
    }

    @Nullable
    private static QueryPredicate getTopLevelPredicate(@Nonnull List<? extends RelationalExpression> expressions) {
        if (expressions.isEmpty()) {
            return null;
        }
        int currentExpression = 0;
        if (expressions.get(currentExpression) instanceof LogicalSortExpression) {
            ++currentExpression;
        }
        if (expressions.size() > currentExpression && expressions.get(currentExpression) instanceof SelectExpression && expressions.size() > currentExpression + 1 && expressions.get(currentExpression + 1) instanceof GroupByExpression) {
            Assert.thatUnchecked(((SelectExpression)expressions.get(currentExpression)).getPredicates().isEmpty(), ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, found predicate in select-having");
            Assert.thatUnchecked(expressions.size() > ++currentExpression);
            ++currentExpression;
        }
        for (int i = currentExpression + 1; i < expressions.size(); ++i) {
            if (!(expressions.get(i) instanceof SelectExpression)) continue;
            SelectExpression innerSelect = (SelectExpression)expressions.get(i);
            Assert.thatUnchecked(innerSelect.getPredicates().isEmpty(), ErrorCode.UNSUPPORTED_OPERATION, "Unsupported index definition, found predicate in inner-select");
        }
        List predicates = ((SelectExpression)expressions.get(currentExpression)).getPredicates().stream().map(QueryPredicate::toResidualPredicate).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            return null;
        }
        QueryPredicate conjunction = predicates.size() == 1 ? (QueryPredicate)predicates.get(0) : AndPredicate.and(predicates);
        QueryPredicate result = BooleanPredicateNormalizer.getDefaultInstanceForDnf().normalize(conjunction, false).orElse(conjunction);
        Assert.thatUnchecked(IndexPredicate.isSupported(result), ErrorCode.UNSUPPORTED_OPERATION, () -> String.format(Locale.ROOT, "Unsupported predicate '%s'", result));
        if (IndexPredicateExpansion.dnfPredicateToRanges(result).isEmpty()) {
            return conjunction;
        }
        return result;
    }

    private void collectQuantifiers(@Nonnull RelationalExpression relationalExpression) {
        AtomicInteger counter = new AtomicInteger(0);
        this.collectQuantifiersInternal(relationalExpression, counter);
    }

    private void collectQuantifiersInternal(@Nonnull RelationalExpression relationalExpression, @Nonnull AtomicInteger explodeCounter) {
        for (Quantifier quantifier : relationalExpression.getQuantifiers()) {
            if (quantifier.getRangesOver().get() instanceof ExplodeExpression) {
                explodeCounter.incrementAndGet();
                Value collectionValue = ((ExplodeExpression)quantifier.getRangesOver().get()).getCollectionValue();
                if (collectionValue instanceof FieldValue) {
                    FieldValue field = (FieldValue)collectionValue;
                    ArrayList<FieldValue.ResolvedAccessor> fieldAccessors = new ArrayList<FieldValue.ResolvedAccessor>(field.getFieldPath().getFieldAccessors());
                    fieldAccessors.set(fieldAccessors.size() - 1, AnnotatedAccessor.of(fieldAccessors.get(fieldAccessors.size() - 1), explodeCounter.get()));
                    this.correlatedKeyExpressions.put(quantifier.getAlias(), FieldValue.ofFields(((FieldValue)collectionValue).getChild(), new FieldValue.FieldPath(fieldAccessors)));
                } else {
                    this.correlatedKeyExpressions.put(quantifier.getAlias(), collectionValue);
                }
            } else {
                this.correlatedKeyExpressions.put(quantifier.getAlias(), quantifier.getRangesOver().get().getResultValue());
            }
            this.collectQuantifiersInternal(quantifier.getRangesOver().get(), explodeCounter);
        }
    }

    @Nonnull
    private Value dereference(@Nonnull Value value) {
        if (value instanceof RecordConstructorValue) {
            return RecordConstructorValue.ofColumns(((RecordConstructorValue)value).getColumns().stream().map(c -> Column.of(c.getField(), this.dereference((Value)c.getValue()))).collect(Collectors.toList()));
        }
        if (value instanceof CountValue) {
            List children = StreamSupport.stream(value.getChildren().spliterator(), false).collect(Collectors.toList());
            Verify.verify(children.size() <= 1);
            if (!children.isEmpty()) {
                return value.withChildren(Collections.singleton(this.dereference((Value)children.get(0))));
            }
            return value;
        }
        if (value instanceof FieldValue || value instanceof IndexableAggregateValue) {
            ValueWithChild valueWithChild = (ValueWithChild)value;
            return valueWithChild.withNewChild(this.dereference(valueWithChild.getChild()));
        }
        if (value instanceof QuantifiedObjectValue) {
            return this.dereference(this.correlatedKeyExpressions.get(value.getCorrelatedTo().stream().findFirst().orElseThrow()));
        }
        if (value instanceof ArithmeticValue) {
            ArrayList<Value> newChildren = new ArrayList<Value>();
            for (Value v : value.getChildren()) {
                newChildren.add(this.dereference(v));
            }
            return ((ArithmeticValue)value).withChildren(newChildren);
        }
        return value;
    }

    @Nonnull
    private KeyExpression toKeyExpression(@Nonnull List<Pair<String, Type>> fields) {
        return this.toKeyExpression(fields, 0);
    }

    @Nonnull
    private KeyExpression toKeyExpression(@Nonnull List<Pair<String, Type>> fields, int index) {
        Assert.thatUnchecked(!fields.isEmpty());
        Pair<String, Type> field = fields.get(index);
        FieldKeyExpression keyExpression = IndexGenerator.toKeyExpression(field.getLeft(), field.getRight());
        if (index + 1 < fields.size()) {
            return keyExpression.nest(this.toKeyExpression(fields, index + 1));
        }
        return keyExpression;
    }

    @Nonnull
    public String getRecordTypeName() {
        List expressionRefs = this.relationalExpressions.stream().filter(r -> r instanceof LogicalTypeFilterExpression).map(r -> (LogicalTypeFilterExpression)r).collect(Collectors.toList());
        Assert.thatUnchecked(expressionRefs.size() == 1, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported query, expected to find exactly one type filter operator");
        Collection recordTypes = ((LogicalTypeFilterExpression)expressionRefs.get(0)).getRecordTypes();
        Assert.thatUnchecked(recordTypes.size() == 1, ErrorCode.UNSUPPORTED_OPERATION, () -> IndexGenerator.lambda$getRecordTypeName$33((Set)recordTypes));
        return (String)recordTypes.stream().findFirst().orElseThrow();
    }

    @Nonnull
    private static FieldKeyExpression toKeyExpression(@Nonnull String name, @Nonnull Type type) {
        Assert.notNullUnchecked(name);
        KeyExpression.FanType fanType = type.getTypeCode() == Type.TypeCode.ARRAY ? KeyExpression.FanType.FanOut : KeyExpression.FanType.None;
        return Key.Expressions.field(name, fanType);
    }

    @Nonnull
    public static IndexGenerator from(@Nonnull RelationalExpression relationalExpression, boolean useLongBasedExtremumEver) {
        return new IndexGenerator(relationalExpression, useLongBasedExtremumEver);
    }

    private static /* synthetic */ String lambda$getRecordTypeName$33(Set recordTypes) {
        return String.format(Locale.ROOT, "Unsupported query, expected to find exactly one record type in type filter operator, however found %s", recordTypes.isEmpty() ? "nothing" : String.join((CharSequence)",", recordTypes));
    }

    private static final class AnnotatedAccessor
    extends FieldValue.ResolvedAccessor {
        private final int marker;

        private AnnotatedAccessor(@Nonnull Type fieldType, @Nullable String fieldName, int fieldOrdinal, int marker) {
            super(fieldName, fieldOrdinal, fieldType);
            this.marker = marker;
        }

        @Nonnull
        public static AnnotatedAccessor of(@Nonnull FieldValue.ResolvedAccessor resolvedAccessor, int marker) {
            return new AnnotatedAccessor(resolvedAccessor.getType(), resolvedAccessor.getName(), resolvedAccessor.getOrdinal(), marker);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AnnotatedAccessor that = (AnnotatedAccessor)o;
            return this.marker == that.marker;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.marker);
        }
    }
}

