/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.recordlayer.query.OrderedLiteral;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Literals {
    @Nonnull
    private static final Literals EMPTY = new Literals(ImmutableList.of());
    @Nonnull
    private final List<OrderedLiteral> orderedLiterals;
    @Nonnull
    private final Supplier<Map<String, Object>> asMapSupplier;

    private Literals(@Nonnull List<OrderedLiteral> orderedLiterals) {
        this.orderedLiterals = ImmutableList.copyOf(orderedLiterals);
        this.asMapSupplier = Suppliers.memoize(() -> Collections.unmodifiableMap(this.orderedLiterals.stream().collect(LinkedHashMap::new, (m4, v) -> m4.put(v.getConstantId(), v.getLiteralObject()), HashMap::putAll)));
    }

    @Nonnull
    public List<OrderedLiteral> getOrderedLiterals() {
        return this.orderedLiterals;
    }

    public boolean isEmpty() {
        return this.orderedLiterals.isEmpty();
    }

    public Map<String, Object> asMap() {
        return this.asMapSupplier.get();
    }

    @Nonnull
    public static Literals empty() {
        return EMPTY;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nonnull
        private final Multiset<OrderedLiteral> literals = TreeMultiset.create(OrderedLiteral.COMPARATOR);
        @Nonnull
        private final Stack<Multiset<OrderedLiteral>> current = new Stack();
        @Nonnull
        private final Map<Object, OrderedLiteral> literalReverseLookup;
        @Nonnull
        private Optional<String> scope;
        private int arrayLiteralScopeCount;
        private int structLiteralScopeCount;

        private Builder() {
            this.current.push(this.literals);
            this.literalReverseLookup = new HashMap<Object, OrderedLiteral>();
            this.scope = Optional.empty();
        }

        private void startComplexLiteral() {
            this.current.push(TreeMultiset.create(OrderedLiteral.COMPARATOR));
        }

        @Nonnull
        public Builder setScope(@Nonnull String scope) {
            this.scope = Optional.of(scope);
            return this;
        }

        public List<OrderedLiteral> importLiteralsRetrieveNewLiterals(@Nonnull Literals other) {
            return other.getOrderedLiterals().stream().filter(literal -> this.addLiteral((OrderedLiteral)literal, false)).collect(ImmutableList.toImmutableList());
        }

        public void importLiterals(@Nonnull Literals other) {
            other.getOrderedLiterals().forEach(literalToImport -> this.addLiteral((OrderedLiteral)literalToImport, false));
        }

        public void addLiteral(@Nonnull OrderedLiteral orderedLiteral) {
            this.addLiteral(orderedLiteral, true);
        }

        private boolean addLiteral(@Nonnull OrderedLiteral orderedLiteral, boolean verifyNotExists) {
            Multiset<OrderedLiteral> currentLiterals = this.current.peek();
            if (orderedLiteral.getLiteralObject() instanceof byte[]) {
                OrderedLiteral byteOrderedLiteral = new OrderedLiteral(orderedLiteral.getType(), ByteString.copyFrom((byte[])orderedLiteral.getLiteralObject()), orderedLiteral.getUnnamedParameterIndex(), orderedLiteral.getParameterName(), orderedLiteral.getTokenIndex(), orderedLiteral.getScopeMaybe());
                this.literalReverseLookup.putIfAbsent(byteOrderedLiteral.getLiteralObject(), byteOrderedLiteral);
                currentLiterals.add(byteOrderedLiteral);
            } else {
                if (verifyNotExists) {
                    Assert.thatUnchecked(!currentLiterals.contains(orderedLiteral));
                } else if (currentLiterals.contains(orderedLiteral)) {
                    OrderedLiteral duplicate = currentLiterals.elementSet().stream().filter(element -> element.equals(orderedLiteral)).findFirst().orElseThrow();
                    Assert.thatUnchecked(orderedLiteral.deepEquals(duplicate));
                    return false;
                }
                this.literalReverseLookup.putIfAbsent(orderedLiteral.getLiteralObject(), orderedLiteral);
                currentLiterals.add(orderedLiteral);
            }
            return true;
        }

        @Nonnull
        public OrderedLiteral addLiteral(@Nonnull Type type, @Nullable Object literalObject, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
            OrderedLiteral literal = new OrderedLiteral(type, literalObject, unnamedParameterIndex, parameterName, tokenIndex, this.scope);
            this.addLiteral(literal);
            return literal;
        }

        public void startArrayLiteral() {
            ++this.arrayLiteralScopeCount;
            this.startComplexLiteral();
        }

        public void startStructLiteral() {
            ++this.structLiteralScopeCount;
            this.startComplexLiteral();
        }

        @Nonnull
        public Optional<OrderedLiteral> getFirstValueDuplicateMaybe(@Nullable Object value) {
            if (this.current.size() > 1) {
                return Optional.empty();
            }
            return Optional.of(this.literalReverseLookup.get(value));
        }

        @Nonnull
        public Optional<OrderedLiteral> getFirstDuplicateOfConstantIdMaybe(@Nonnull String constantId) {
            if (this.current.size() > 1) {
                return Optional.empty();
            }
            return Optional.of(this.literalReverseLookup.get(this.literals.stream().filter(l -> l.getConstantId().equals(constantId)).findFirst().orElseThrow().getLiteralObject()));
        }

        public void finishArrayLiteral(@Nullable Integer unnamedParameterIndex, @Nullable String parameterName, boolean shouldProcessLiterals, int tokenIndex) {
            Assert.thatUnchecked(!this.current.empty());
            Assert.thatUnchecked(this.arrayLiteralScopeCount > 0);
            Multiset<OrderedLiteral> nestedArrayLiterals = this.current.pop();
            ArrayList<Object> arrayElements = Lists.newArrayListWithExpectedSize(nestedArrayLiterals.size());
            Type elementType = null;
            for (OrderedLiteral nestedArrayLiteral : nestedArrayLiterals) {
                Type currentElementType = nestedArrayLiteral.getType();
                if (elementType != null) {
                    Assert.thatUnchecked(currentElementType.equals(elementType), ErrorCode.DATATYPE_MISMATCH, "Elements of array literal are not of identical type!");
                } else {
                    elementType = currentElementType;
                }
                arrayElements.add(nestedArrayLiteral.getLiteralObject());
            }
            OrderedLiteral orderedLiteral = new OrderedLiteral(new Type.Array(elementType), arrayElements, unnamedParameterIndex, parameterName, tokenIndex, this.scope);
            if (shouldProcessLiterals) {
                Verify.verify(!this.current.peek().contains(orderedLiteral));
                this.literalReverseLookup.putIfAbsent(orderedLiteral.getLiteralObject(), orderedLiteral);
                this.current.peek().add(orderedLiteral);
            }
            --this.arrayLiteralScopeCount;
        }

        public void finishStructLiteral(@Nonnull Type.Record type, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
            Assert.thatUnchecked(!this.current.empty());
            Assert.thatUnchecked(this.structLiteralScopeCount > 0);
            Multiset<OrderedLiteral> fields = this.current.pop();
            TypeRepository.Builder builder = TypeRepository.newBuilder();
            type.defineProtoType(builder);
            DynamicMessage.Builder messageBuilder = Objects.requireNonNull(builder.build().newMessageBuilder(type));
            List<Descriptors.FieldDescriptor> fieldDescriptors = messageBuilder.getDescriptorForType().getFields();
            int i = 0;
            for (OrderedLiteral fieldOrderedLiteral : fields) {
                Object fieldValue = fieldOrderedLiteral.getLiteralObject();
                if (fieldValue != null) {
                    messageBuilder.setField(fieldDescriptors.get(i), Builder.transformFieldValue(fieldValue));
                }
                ++i;
            }
            Verify.verify(tokenIndex >= 0);
            OrderedLiteral orderedLiteral = new OrderedLiteral(type, messageBuilder.build(), unnamedParameterIndex, parameterName, tokenIndex, this.scope);
            this.literalReverseLookup.putIfAbsent(orderedLiteral.getLiteralObject(), orderedLiteral);
            this.current.peek().add(orderedLiteral);
            --this.structLiteralScopeCount;
        }

        private static Object transformFieldValue(@Nonnull Object fieldValue) {
            if (fieldValue instanceof UUID) {
                return TupleFieldsHelper.toProto((UUID)fieldValue);
            }
            return fieldValue;
        }

        public boolean isAddingComplexLiteral() {
            return this.arrayLiteralScopeCount + this.structLiteralScopeCount != 0;
        }

        public boolean isEmpty() {
            return this.literals.isEmpty();
        }

        @Nonnull
        public Literals build() {
            return new Literals(this.literals.stream().collect(ImmutableList.toImmutableList()));
        }

        @Nonnull
        public String constructConstantId(int tokenIndex) {
            return "c" + this.scope.orElse("") + tokenIndex;
        }
    }
}

