/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.continuation.LiteralObject;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class LiteralsUtils {
    private LiteralsUtils() {
    }

    @Nonnull
    public static Type.Array resolveArrayTypeFromObjectsList(List<Object> objects) {
        DataType distinctType = null;
        for (Object object : objects) {
            DataType objectType = DataType.getDataTypeFromObject(object);
            if (distinctType == null) {
                distinctType = objectType;
                continue;
            }
            if (distinctType instanceof DataType.CompositeType) {
                Assert.thatUnchecked(((DataType.CompositeType)((Object)distinctType)).hasIdenticalStructure(objectType), ErrorCode.DATATYPE_MISMATCH, "could not determine type of array literal");
                continue;
            }
            Assert.thatUnchecked(distinctType.equals(objectType), ErrorCode.DATATYPE_MISMATCH, "could not determine type of array literal");
        }
        return new Type.Array(distinctType == null ? Type.nullType() : DataTypeUtils.toRecordLayerType(distinctType));
    }

    @Nonnull
    public static LiteralObject objectToLiteralObjectProto(@Nonnull Type type, @Nullable Object object) {
        LiteralObject.Builder builder = LiteralObject.newBuilder();
        if (object == null) {
            return builder.build();
        }
        if (type.isRecord()) {
            Message message = (Message)object;
            builder.setRecordObject(message.toByteString());
        } else if (type.isArray()) {
            Type elementType = Objects.requireNonNull(((Type.Array)type).getElementType());
            List array = (List)object;
            LiteralObject.Array.Builder arrayBuilder = LiteralObject.Array.newBuilder();
            for (Object element : array) {
                arrayBuilder.addElementObjects(LiteralsUtils.objectToLiteralObjectProto(elementType, element));
            }
            builder.setArrayObject(arrayBuilder.build());
        } else {
            builder.setScalarObject(PlanSerialization.valueObjectToProto(object));
        }
        return builder.build();
    }

    @Nullable
    public static Object objectFromLiteralObjectProto(@Nonnull TypeRepository typeRepository, @Nonnull Type type, @Nonnull LiteralObject literalObject) {
        if (literalObject.hasScalarObject()) {
            return PlanSerialization.protoToValueObject(literalObject.getScalarObject());
        }
        if (literalObject.hasRecordObject()) {
            Descriptors.Descriptor typeDescriptor = Objects.requireNonNull(typeRepository.getMessageDescriptor(type));
            try {
                return DynamicMessage.parseFrom(typeDescriptor, literalObject.getRecordObject());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RelationalException("unable to parse object", ErrorCode.INTERNAL_ERROR, e).toUncheckedWrappedException();
            }
        }
        if (literalObject.hasArrayObject()) {
            LiteralObject.Array arrayObject = literalObject.getArrayObject();
            Type elementType = Objects.requireNonNull(((Type.Array)type).getElementType());
            ArrayList<Object> array = Lists.newArrayListWithExpectedSize(arrayObject.getElementObjectsCount());
            for (int i = 0; i < arrayObject.getElementObjectsCount(); ++i) {
                array.add(LiteralsUtils.objectFromLiteralObjectProto(typeRepository, elementType, arrayObject.getElementObjects(i)));
            }
            return array;
        }
        return null;
    }
}

