/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AccessHint;
import com.apple.foundationdb.record.query.plan.cascades.AccessHints;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.InsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TempTableInsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TempTableScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.CountValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.VariadicFunctionValue;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperatorCatalog;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperators;
import com.apple.foundationdb.relational.recordlayer.query.LogicalPlanFragment;
import com.apple.foundationdb.relational.recordlayer.query.OrderByExpression;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.Star;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalOperator {
    @Nonnull
    private final Optional<Identifier> name;
    @Nonnull
    private final Expressions output;
    @Nonnull
    private final Quantifier quantifier;

    public LogicalOperator(@Nonnull Optional<Identifier> name, @Nonnull Expressions output, @Nonnull Quantifier quantifier) {
        this.name = name;
        this.output = output;
        this.quantifier = quantifier;
    }

    @Nonnull
    public Optional<Identifier> getName() {
        return this.name;
    }

    @Nonnull
    public Expressions getOutput() {
        return this.output;
    }

    @Nonnull
    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    @Nonnull
    public LogicalOperator withName(@Nonnull Identifier name) {
        if (this.getName().isPresent() && this.getName().get().equals(name)) {
            return this;
        }
        if (this.getName().isEmpty()) {
            return LogicalOperator.newNamedOperator(name, this.getOutput(), this.getQuantifier());
        }
        return LogicalOperator.newNamedOperator(name, this.getOutput().replaceQualifier(existing -> {
            int existingSize;
            int prefixSize = this.getName().get().fullyQualifiedName().size();
            if (prefixSize > (existingSize = existing.size())) {
                return existing;
            }
            ImmutableList existingList = ImmutableList.copyOf(existing);
            if (((ImmutableList)existingList.subList(0, prefixSize)).equals(this.getName().get().fullyQualifiedName())) {
                return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(name.fullyQualifiedName())).addAll((Iterable)existingList.subList(prefixSize, existingList.size()))).build();
            }
            return existing;
        }), this.getQuantifier());
    }

    @Nonnull
    public LogicalOperator withAdditionalOutput(@Nonnull Expressions expressions) {
        return LogicalOperator.newOperatorWithPreservedExpressionNames(this.getName(), this.output.concat(expressions), this.getQuantifier());
    }

    @Nonnull
    public LogicalOperator withOutput(@Nonnull Expressions expressions) {
        return LogicalOperator.newOperatorWithPreservedExpressionNames(this.getName(), expressions, this.getQuantifier());
    }

    @Nonnull
    public LogicalOperator withQuantifier(@Nonnull Quantifier quantifier) {
        if (quantifier == this.getQuantifier()) {
            return this;
        }
        return LogicalOperator.newOperator(this.getName(), this.getOutput(), quantifier);
    }

    @Nonnull
    public LogicalOperator withNewSharedReferenceAndAlias(@Nonnull Optional<Identifier> alias) {
        Quantifier.ForEach quantifier = Quantifier.forEach(this.getQuantifier().getRangesOver());
        LogicalOperator result = this.withOutput(this.getOutput().rewireQov(quantifier.getFlowedObjectValue())).withQuantifier(quantifier);
        return alias.map(result::withName).orElse(result);
    }

    @Nonnull
    public static LogicalOperator generateAccess(@Nonnull Identifier identifier, @Nonnull Optional<Identifier> alias, @Nonnull Set<String> requestedIndexes, @Nonnull SemanticAnalyzer semanticAnalyzer, @Nonnull LogicalPlanFragment currentPlanFragment, @Nonnull LogicalOperatorCatalog logicalOperatorCatalog) {
        Optional<LogicalOperator> cteMaybe = semanticAnalyzer.findCteMaybe(identifier, currentPlanFragment);
        if (cteMaybe.isPresent()) {
            return cteMaybe.get().withNewSharedReferenceAndAlias(alias);
        }
        if (semanticAnalyzer.tableExists(identifier)) {
            return logicalOperatorCatalog.lookupTableAccess(identifier, alias, requestedIndexes, semanticAnalyzer);
        }
        if (semanticAnalyzer.functionExists(identifier)) {
            return semanticAnalyzer.resolveTableFunction(identifier, Expressions.empty(), false);
        }
        Expression correlatedField = semanticAnalyzer.resolveCorrelatedIdentifier(identifier, currentPlanFragment.getLogicalOperatorsIncludingOuter());
        Assert.thatUnchecked(requestedIndexes.isEmpty(), ErrorCode.UNSUPPORTED_QUERY, () -> String.format(Locale.ROOT, "Can not hint indexes with correlated field access %s", identifier));
        return LogicalOperator.generateCorrelatedFieldAccess(correlatedField, alias);
    }

    @Nonnull
    public static LogicalOperator newNamedOperator(@Nonnull Identifier name, @Nonnull Expressions output, @Nonnull Quantifier quantifier) {
        return new LogicalOperator(Optional.of(name), output.withQualifier(name), quantifier);
    }

    @Nonnull
    public static LogicalOperator newUnnamedOperator(@Nonnull Expressions output, @Nonnull Quantifier quantifier) {
        return new LogicalOperator(Optional.empty(), output.clearQualifier(), quantifier);
    }

    @Nonnull
    public static LogicalOperator newOperator(@Nonnull Optional<Identifier> name, @Nonnull Expressions output, @Nonnull Quantifier quantifier) {
        return name.map(identifier -> LogicalOperator.newNamedOperator(identifier, output, quantifier)).orElseGet(() -> LogicalOperator.newUnnamedOperator(output, quantifier));
    }

    @Nonnull
    public static LogicalOperator newOperatorWithPreservedExpressionNames(@Nonnull Expressions output, @Nonnull Quantifier quantifier) {
        return LogicalOperator.newOperatorWithPreservedExpressionNames(Optional.empty(), output, quantifier);
    }

    @Nonnull
    public static LogicalOperator newOperatorWithPreservedExpressionNames(@Nonnull Optional<Identifier> name, @Nonnull Expressions output, @Nonnull Quantifier quantifier) {
        return new LogicalOperator(name, output, quantifier);
    }

    @Nonnull
    public static LogicalOperator generateTableAccess(@Nonnull Identifier tableId, @Nonnull Set<AccessHint> indexAccessHints, @Nonnull SemanticAnalyzer semanticAnalyzer) {
        Set<String> tableNames = semanticAnalyzer.getAllTableNames();
        semanticAnalyzer.validateIndexes(tableId, indexAccessHints);
        Quantifier.ForEach scanExpression = Quantifier.forEach(Reference.initialOf((RelationalExpression)new FullUnorderedScanExpression(tableNames, new Type.AnyRecord(false), new AccessHints(indexAccessHints.toArray(new AccessHint[0])))));
        Table table = semanticAnalyzer.getTable(tableId);
        Type.Record type = Assert.castUnchecked(table, RecordLayerTable.class).getType();
        LogicalTypeFilterExpression typeFilterExpression = new LogicalTypeFilterExpression(ImmutableSet.of(tableId.getName()), scanExpression, type);
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)typeFilterExpression));
        ImmutableList.Builder attributesBuilder = ImmutableList.builder();
        int colCount = 0;
        for (com.apple.foundationdb.relational.api.metadata.Column column : table.getColumns()) {
            Identifier attributeName = Identifier.of(column.getName());
            DataType attributeType = column.getDataType();
            Type.Record.Field fieldType = type.getField(colCount);
            FieldValue attributeExpression = FieldValue.ofFields(resultingQuantifier.getFlowedObjectValue(), FieldValue.FieldPath.ofSingle(FieldValue.ResolvedAccessor.of(fieldType, colCount)));
            attributesBuilder.add(new Expression(Optional.of(attributeName), attributeType, attributeExpression));
            ++colCount;
        }
        Expressions attributes = Expressions.of(attributesBuilder.build());
        return LogicalOperator.newNamedOperator(tableId, attributes, resultingQuantifier);
    }

    @Nonnull
    private static LogicalOperator generateCorrelatedFieldAccess(@Nonnull Expression expression, @Nonnull Optional<Identifier> alias) {
        Assert.thatUnchecked(expression.getDataType().getCode() == DataType.Code.ARRAY, ErrorCode.INVALID_COLUMN_REFERENCE, () -> String.format(Locale.ROOT, "join correlation can occur only on column of repeated type, not %s type", expression.getDataType()));
        ExplodeExpression explode = new ExplodeExpression(expression.getUnderlying());
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)explode));
        Expressions outputAttributes = Expressions.of(LogicalOperator.convertToExpressions(resultingQuantifier));
        return LogicalOperator.newOperator(alias, outputAttributes, resultingQuantifier);
    }

    @Nonnull
    public static Expressions convertToExpressions(@Nonnull Quantifier quantifier) {
        ImmutableList.Builder attributesBuilder = ImmutableList.builder();
        int colCount = 0;
        List<Column<? extends FieldValue>> columns = quantifier.getFlowedColumns();
        for (Column<? extends FieldValue> column : columns) {
            Type.Record.Field field = column.getField();
            FieldValue value = column.getValue();
            Optional<Identifier> attributeName = field.getFieldNameOptional().map(Identifier::of);
            DataType attributeType = DataTypeUtils.toRelationalType(value.getResultType());
            FieldValue attributeExpression = FieldValue.ofOrdinalNumber(quantifier.getFlowedObjectValue(), colCount);
            attributesBuilder.add(new Expression(attributeName, attributeType, attributeExpression));
            ++colCount;
        }
        return Expressions.of(attributesBuilder.build());
    }

    @Nonnull
    public static LogicalOperator generateSelect(@Nonnull Expressions output, @Nonnull LogicalOperators logicalOperators, @Nonnull Optional<Expression> predicate, @Nonnull List<OrderByExpression> orderBys, @Nonnull Optional<Identifier> alias, @Nonnull Set<CorrelationIdentifier> outerCorrelations, boolean isTopLevel, boolean isForDdl) {
        if (orderBys.isEmpty()) {
            if (isTopLevel) {
                return LogicalOperator.generateSort(LogicalOperator.generateSimpleSelect(output, logicalOperators, predicate, Optional.empty(), outerCorrelations, isForDdl), orderBys, outerCorrelations, alias);
            }
            return LogicalOperator.generateSimpleSelect(output, logicalOperators, predicate, alias, outerCorrelations, isForDdl);
        }
        Expressions orderByExpressions = Expressions.of(orderBys.stream().map(OrderByExpression::getExpression).collect(ImmutableList.toImmutableList()));
        Expressions remainingOrderByExpressions = orderByExpressions.difference(output, outerCorrelations);
        if (remainingOrderByExpressions.isEmpty()) {
            return LogicalOperator.generateSort(LogicalOperator.generateSimpleSelect(output, logicalOperators, predicate, Optional.empty(), outerCorrelations, isForDdl), orderBys, outerCorrelations, alias);
        }
        Expressions selectWithExtraOrderByExpressions = output.concat(remainingOrderByExpressions);
        LogicalOperator selectWithExtraOrderBy = LogicalOperator.generateSimpleSelect(selectWithExtraOrderByExpressions, logicalOperators, predicate, Optional.empty(), outerCorrelations, isForDdl);
        LogicalOperator sortOperator = LogicalOperator.generateSort(selectWithExtraOrderBy, orderBys, outerCorrelations, Optional.empty());
        Expressions pulledOutput = output.expanded().rewireQov(selectWithExtraOrderBy.getQuantifier().getFlowedObjectValue()).rewireQov(sortOperator.getQuantifier().getFlowedObjectValue()).clearQualifier();
        return LogicalOperator.generateSimpleSelect(pulledOutput, LogicalOperators.ofSingle(sortOperator), Optional.empty(), alias, outerCorrelations, isForDdl);
    }

    @Nonnull
    public static LogicalOperator generateSelectWhere(@Nonnull LogicalOperators logicalOperators, @Nonnull Set<CorrelationIdentifier> outerCorrelations, @Nonnull Optional<Expression> where, boolean isForDdl) {
        List<Quantifier> quantifiers = logicalOperators.getQuantifiers();
        ImmutableList quantifiedObjectValues = quantifiers.stream().map(QuantifiedObjectValue::of).collect(ImmutableList.toImmutableList());
        GraphExpansion.Builder selectBuilder = GraphExpansion.builder().addAllQuantifiers(quantifiers).addAllResultValues(quantifiedObjectValues);
        where.ifPresent(predicate -> {
            ImmutableSet<CorrelationIdentifier> localAliases = quantifiers.stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
            selectBuilder.addPredicate(Expression.Utils.toUnderlyingPredicate(predicate, localAliases, isForDdl));
        });
        SelectExpression selectExpression = selectBuilder.build().buildSelect();
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)selectExpression));
        Expressions expressions = logicalOperators.getExpressions();
        Expressions output = expressions.pullUp(selectExpression.getResultValue(), resultingQuantifier.getAlias(), outerCorrelations);
        return LogicalOperator.newOperatorWithPreservedExpressionNames(output, resultingQuantifier);
    }

    @Nonnull
    public static LogicalOperator generateGroupBy(@Nonnull LogicalOperators logicalOperators, @Nonnull Expressions groupByExpressions, @Nonnull Expressions outputExpressions, @Nonnull Optional<Expression> havingPredicate, @Nonnull Set<CorrelationIdentifier> outerCorrelations, @Nonnull Literals literals) {
        AliasMap aliasMap = AliasMap.identitiesFor(logicalOperators.getCorrelations());
        Expressions aggregates = Expressions.of(havingPredicate.map(outputExpressions::concat).orElse(outputExpressions).collectAggregateValues().stream().map(Expression::fromUnderlying).collect(ImmutableSet.toImmutableSet()));
        SemanticAnalyzer.validateGroupByAggregates(aggregates);
        Expressions validSubExpressions = groupByExpressions.dereferenced(literals).concat(aggregates.dereferenced(literals));
        for (Expression expression : outputExpressions.expanded().concat(havingPredicate.map(Expressions::ofSingle).orElseGet(Expressions::empty))) {
            Assert.thatUnchecked(SemanticAnalyzer.isComposableFrom(expression.dereferenced(literals).getSingleItem(), validSubExpressions, aliasMap, outerCorrelations), ErrorCode.GROUPING_ERROR, () -> String.format(Locale.ROOT, "Invalid reference to non-grouping expression %s", expression));
        }
        RecordConstructorValue aggregateValue = RecordConstructorValue.ofUnnamed(Assert.castUnchecked(aggregates.underlying(), List.class));
        RecordConstructorValue groupingValue = RecordConstructorValue.ofUnnamed(Assert.castUnchecked(groupByExpressions.underlying(), List.class));
        GroupByExpression groupByExpression = new GroupByExpression(groupingValue.getColumns().isEmpty() ? null : groupingValue, aggregateValue, GroupByExpression::nestedResults, Iterables.getOnlyElement(logicalOperators).quantifier);
        Reference groupByReference = Reference.initialOf((RelationalExpression)groupByExpression);
        Quantifier.ForEach resultingQuantifier = groupByExpression.getGroupingValue() == null ? Quantifier.forEachWithNullOnEmpty(groupByReference) : Quantifier.forEach(groupByReference);
        Expressions output = groupByExpressions.concat(aggregates).pullUp(groupByExpression.getResultValue(), resultingQuantifier.getAlias(), outerCorrelations).clearQualifier();
        return LogicalOperator.newUnnamedOperator(output, resultingQuantifier);
    }

    @Nonnull
    public static LogicalOperator generateSimpleSelect(@Nonnull Expressions output, @Nonnull LogicalOperators logicalOperators, @Nonnull Optional<Expression> where, @Nonnull Optional<Identifier> alias, @Nonnull Set<CorrelationIdentifier> outerCorrelations, boolean isForDdl) {
        SelectExpression selectExpression;
        List<Quantifier> quantifiers = logicalOperators.getQuantifiers();
        GraphExpansion.Builder selectBuilder = GraphExpansion.builder().addAllQuantifiers(quantifiers);
        where.ifPresent(predicate -> {
            ImmutableSet<CorrelationIdentifier> localAliases = quantifiers.stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
            selectBuilder.addPredicate(Expression.Utils.toUnderlyingPredicate(predicate, localAliases, isForDdl));
        });
        Expressions expandedOutput = output.expanded();
        if (LogicalOperator.canAvoidProjectingIndividualFields(output, logicalOperators)) {
            Value passedThroughResultValue = Iterables.getOnlyElement(output).getUnderlying();
            selectExpression = selectBuilder.build().buildSelectWithResultValue(passedThroughResultValue);
        } else {
            expandedOutput.underlyingAsColumns().forEach(selectBuilder::addResultColumn);
            selectExpression = selectBuilder.build().buildSelect();
        }
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)selectExpression));
        Expressions resultingExpressions = expandedOutput.rewireQov(resultingQuantifier.getFlowedObjectValue());
        resultingExpressions = alias.map(resultingExpressions::withQualifier).orElseGet(resultingExpressions::clearQualifier);
        return LogicalOperator.newOperator(alias, resultingExpressions, resultingQuantifier);
    }

    private static boolean canAvoidProjectingIndividualFields(@Nonnull Expressions output, @Nonnull LogicalOperators logicalOperators) {
        return Iterables.size(logicalOperators.forEachOnly()) == 1 && Iterables.size(output) == 1 && Iterables.getOnlyElement(output) instanceof Star && output.expanded().stream().allMatch(expression -> expression.getName().isEmpty() || expression.getUnderlying() instanceof FieldValue && ((FieldValue)expression.getUnderlying()).getLastFieldName().equals(expression.getName().map(Identifier::getName)));
    }

    @Nonnull
    public static LogicalOperator generateSort(@Nonnull LogicalOperator logicalOperator, @Nonnull List<OrderByExpression> orderBys, @Nonnull Set<CorrelationIdentifier> outerCorrelations, @Nonnull Optional<Identifier> alias) {
        LogicalSortExpression sortExpression;
        if (orderBys.isEmpty()) {
            sortExpression = LogicalSortExpression.unsorted(logicalOperator.quantifier);
        } else {
            ImmutableList<OrderingPart.RequestedOrderingPart> orderingParts = OrderByExpression.toOrderingParts(OrderByExpression.pullUp(orderBys.stream(), logicalOperator.quantifier.getRangesOver().get().getResultValue(), logicalOperator.quantifier.getAlias(), outerCorrelations, logicalOperator.name), logicalOperator.quantifier.getAlias(), Quantifier.current()).collect(ImmutableList.toImmutableList());
            sortExpression = new LogicalSortExpression(RequestedOrdering.ofPrimitiveParts(orderingParts, RequestedOrdering.Distinctness.PRESERVE_DISTINCTNESS, false), logicalOperator.quantifier);
        }
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)sortExpression));
        Expressions resultingExpressions = Expressions.of(logicalOperator.output).rewireQov(resultingQuantifier.getFlowedObjectValue());
        resultingExpressions = alias.map(resultingExpressions::withQualifier).orElseGet(resultingExpressions::clearQualifier);
        return LogicalOperator.newOperator(alias, resultingExpressions, resultingQuantifier);
    }

    @Nonnull
    public static LogicalOperator generateInsert(@Nonnull LogicalOperator insertSource, @Nonnull Table target) {
        Type.Record targetType = Assert.castUnchecked(target, RecordLayerTable.class).getType();
        InsertExpression insertExpression = new InsertExpression(Assert.castUnchecked(insertSource.getQuantifier(), Quantifier.ForEach.class), target.getName(), targetType);
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)insertExpression));
        Expressions output = Expressions.fromQuantifier(resultingQuantifier);
        LogicalOperator insertOperator = LogicalOperator.newUnnamedOperator(output, resultingQuantifier);
        return LogicalOperator.generateSort(insertOperator, List.of(), Set.of(), Optional.empty());
    }

    @Nonnull
    public static CorrelationIdentifier getInnermostAlias(@Nonnull Iterable<LogicalOperator> logicalOperators) {
        Collection aliases = Streams.stream(logicalOperators).map(LogicalOperator::getQuantifier).filter(qun -> qun instanceof Quantifier.ForEach).map(Quantifier::getAlias).collect(Collectors.toList());
        return (CorrelationIdentifier)aliases.stream().findFirst().orElseThrow();
    }

    @Nonnull
    public static LogicalOperator generateUnionAll(@Nonnull LogicalOperators unionLegs, @Nonnull Set<CorrelationIdentifier> outerCorrelations) {
        Assert.thatUnchecked(!unionLegs.isEmpty());
        if (unionLegs.size() == 1) {
            return unionLegs.first();
        }
        List<Quantifier> quantifiers = unionLegs.getQuantifiers();
        Optional<Type.Record> maybeType = SemanticAnalyzer.validateUnionTypes(LogicalOperators.of(unionLegs));
        if (maybeType.isEmpty()) {
            Quantifier.ForEach union = Quantifier.forEach(Reference.initialOf((RelationalExpression)new LogicalUnionExpression(quantifiers)));
            Expressions output = unionLegs.first().getOutput().rewireQov(union.getFlowedObjectValue());
            return LogicalOperator.newUnnamedOperator(output, union);
        }
        Type.Record type = maybeType.get();
        ImmutableList.Builder promotedUnionLegsBuilder = ImmutableList.builder();
        for (LogicalOperator unionLeg : unionLegs) {
            Type unionLegType = unionLeg.getQuantifier().getFlowedObjectType();
            if (unionLegType.equals(type)) {
                promotedUnionLegsBuilder.add(unionLeg);
                continue;
            }
            Expressions expressions = unionLeg.getOutput();
            Assert.thatUnchecked(expressions.size() == type.getFields().size());
            ImmutableList.Builder promotedExpressions = ImmutableList.builder();
            for (int i = 0; i < expressions.size(); ++i) {
                Expression currentExpression = expressions.asList().get(i);
                Value newValue = PromoteValue.inject(currentExpression.getUnderlying(), type.getField(i).getFieldType());
                promotedExpressions.add(currentExpression.withUnderlying(newValue));
            }
            LogicalOperator promotedUnionLeg = LogicalOperator.generateSimpleSelect(Expressions.of(promotedExpressions.build()), LogicalOperators.ofSingle(unionLeg), Optional.empty(), Optional.empty(), outerCorrelations, false);
            promotedUnionLegsBuilder.add(promotedUnionLeg);
        }
        LogicalOperators promotedUnionLegs = LogicalOperators.of(promotedUnionLegsBuilder.build());
        Quantifier.ForEach union = Quantifier.forEach(Reference.initialOf((RelationalExpression)new LogicalUnionExpression(promotedUnionLegs.getQuantifiers())));
        Expressions output = promotedUnionLegs.first().getOutput().rewireQov(union.getFlowedObjectValue());
        return LogicalOperator.newUnnamedOperator(output, union);
    }

    @Nonnull
    public static Expressions adjustCountOnEmpty(@Nonnull Expressions expressions) {
        return Expressions.of(expressions.expanded().stream().map(expression -> {
            Value underlyingValue = expression.getUnderlying();
            Set visited = Sets.newIdentityHashSet();
            return expression.withUnderlying(Objects.requireNonNull((Value)underlyingValue.replace(subValue -> {
                if (!visited.add(subValue)) {
                    return subValue;
                }
                if (subValue instanceof CountValue) {
                    LiteralValue<Long> zero = LiteralValue.ofScalar(0L);
                    return (Value)new VariadicFunctionValue.CoalesceFn().encapsulate(ImmutableList.of(subValue, zero));
                }
                return subValue;
            })));
        }).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public static LogicalOperator newTemporaryTableScan(@Nonnull Identifier operatorId, @Nonnull Identifier tempTableId, @Nonnull Type type) {
        CorrelationIdentifier tempTableAlias = CorrelationIdentifier.of(tempTableId.getName());
        TempTableScanExpression tempTableScan = TempTableScanExpression.ofCorrelated(tempTableAlias, type);
        Quantifier.ForEach quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)tempTableScan));
        Expressions expressions = Expressions.fromQuantifier(quantifier);
        return LogicalOperator.newNamedOperator(operatorId, expressions, quantifier);
    }

    @Nonnull
    public static LogicalOperator newTemporaryTableInsert(@Nonnull LogicalOperator input, @Nonnull Identifier identifier, @Nonnull Type type) {
        CorrelationIdentifier tempTableAlias = CorrelationIdentifier.of(identifier.getName());
        TempTableInsertExpression tempTableInsert = TempTableInsertExpression.ofCorrelated(input.getQuantifier().narrow(Quantifier.ForEach.class), tempTableAlias, type);
        Quantifier.ForEach quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)tempTableInsert));
        Expressions expressions = Expressions.fromQuantifier(quantifier);
        return LogicalOperator.newUnnamedOperator(expressions, quantifier);
    }
}

