/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.recordlayer.query.CatalogKey;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class LogicalOperatorCatalog {
    @Nonnull
    private final Map<CatalogKey, LogicalOperator> logicalOperators = new LinkedHashMap<CatalogKey, LogicalOperator>();

    private LogicalOperatorCatalog() {
    }

    @Nonnull
    public LogicalOperator lookup(@Nonnull CatalogKey key, @Nonnull Function<CatalogKey, LogicalOperator> mappingFunction) {
        return this.logicalOperators.computeIfAbsent(key, mappingFunction);
    }

    @Nonnull
    public LogicalOperator lookupTableAccess(@Nonnull Identifier tableId, @Nonnull SemanticAnalyzer semanticAnalyzer) {
        return this.lookupTableAccess(tableId, Optional.empty(), ImmutableSet.of(), semanticAnalyzer);
    }

    @Nonnull
    public LogicalOperator lookupTableAccess(@Nonnull Identifier tableId, @Nonnull Optional<Identifier> alias, @Nonnull Set<String> requestedIndexes, @Nonnull SemanticAnalyzer semanticAnalyzer) {
        return this.lookupTableAccess(CatalogKey.of(tableId, requestedIndexes), alias, semanticAnalyzer);
    }

    @Nonnull
    public LogicalOperator lookupTableAccess(@Nonnull CatalogKey key, @Nonnull Optional<Identifier> alias, @Nonnull SemanticAnalyzer semanticAnalyzer) {
        if (!this.logicalOperators.containsKey(key)) {
            LogicalOperator value = LogicalOperator.generateTableAccess(key.getIdentifier(), key.getHints(), semanticAnalyzer);
            this.logicalOperators.put(key, value);
            return alias.map(value::withName).orElse(value);
        }
        return this.logicalOperators.get(key).withNewSharedReferenceAndAlias(alias);
    }

    @Nonnull
    public static LogicalOperatorCatalog newInstance() {
        return new LogicalOperatorCatalog();
    }
}

