/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalOperators
implements Iterable<LogicalOperator> {
    @Nonnull
    private static final LogicalOperators EMPTY = new LogicalOperators(ImmutableList.of());
    @Nonnull
    private final List<LogicalOperator> underlying;

    public LogicalOperators(@Nonnull Iterable<LogicalOperator> underlying) {
        this.underlying = ImmutableList.copyOf(underlying);
    }

    @Override
    @Nonnull
    public Iterator<LogicalOperator> iterator() {
        return this.underlying.iterator();
    }

    @Nonnull
    public Stream<LogicalOperator> stream() {
        return this.underlying.stream();
    }

    @Nonnull
    public List<LogicalOperator> asList() {
        return this.underlying;
    }

    @Nonnull
    public LogicalOperator first() {
        Assert.thatUnchecked(!this.underlying.isEmpty());
        return this.underlying.get(0);
    }

    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    public int size() {
        return this.underlying.size();
    }

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelations() {
        return this.underlying.stream().map(operator -> operator.getQuantifier().getAlias()).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public List<Quantifier> getQuantifiers() {
        return this.underlying.stream().map(LogicalOperator::getQuantifier).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Expressions getExpressions() {
        Expressions accumulated = Expressions.empty();
        for (LogicalOperator logicalOperator : this) {
            accumulated = accumulated.concat(Expressions.of(logicalOperator.getOutput()));
        }
        return accumulated;
    }

    @Nonnull
    public LogicalOperators forEachOnly() {
        return LogicalOperators.of(this.stream().filter(operator -> operator.getQuantifier().getClass().equals(Quantifier.ForEach.class)).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    public LogicalOperators concat(@Nonnull LogicalOperator logicalOperator) {
        return this.concat(LogicalOperators.ofSingle(logicalOperator));
    }

    @Nonnull
    public LogicalOperators concat(@Nonnull LogicalOperators other) {
        return new LogicalOperators(Iterables.concat(this, other));
    }

    @Nonnull
    public static LogicalOperators of(@Nonnull Iterable<LogicalOperator> logicalOperators) {
        return new LogicalOperators(logicalOperators);
    }

    @Nonnull
    public static LogicalOperators ofSingle(@Nonnull LogicalOperator logicalOperator) {
        return new LogicalOperators(ImmutableList.of(logicalOperator));
    }

    @Nonnull
    public static LogicalOperators empty() {
        return EMPTY;
    }
}

