/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperators;
import com.apple.foundationdb.relational.recordlayer.query.StringTrieNode;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class LogicalPlanFragment {
    @Nonnull
    private final Optional<LogicalPlanFragment> parent;
    @Nonnull
    private LogicalOperators operators;
    @Nonnull
    private Optional<State> state;

    private LogicalPlanFragment(@Nonnull Optional<LogicalPlanFragment> parent, @Nonnull LogicalOperators operators, @Nonnull Optional<State> state) {
        this.parent = parent;
        this.operators = operators;
        this.state = state;
    }

    @Nonnull
    public LogicalOperators getLogicalOperators() {
        return this.operators;
    }

    @Nonnull
    public Optional<LogicalPlanFragment> getParentMaybe() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent.isPresent();
    }

    @Nonnull
    public LogicalPlanFragment getParent() {
        Assert.thatUnchecked(this.parent.isPresent());
        return this.parent.get();
    }

    @Nonnull
    public LogicalOperators getLogicalOperatorsIncludingOuter() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        resultBuilder.addAll((Iterable)this.getLogicalOperators());
        Optional<LogicalPlanFragment> current = this.parent;
        while (current.isPresent()) {
            resultBuilder.addAll((Iterable)current.get().getLogicalOperators());
            current = current.get().getParentMaybe();
        }
        return LogicalOperators.of(resultBuilder.build());
    }

    public void addOperator(@Nonnull LogicalOperator logicalOperator) {
        this.operators = this.operators.concat(logicalOperator);
    }

    public void setOperator(@Nonnull LogicalOperator logicalOperator) {
        this.operators = LogicalOperators.ofSingle(logicalOperator);
    }

    public void setState(@Nonnull State state) {
        this.state = Optional.of(state);
    }

    public void setStateMaybe(@Nonnull Optional<State> state) {
        this.state = state;
    }

    @Nonnull
    public State getState() {
        Assert.thatUnchecked(this.state.isPresent());
        return this.state.get();
    }

    @Nonnull
    public Optional<State> getStateMaybe() {
        return this.state;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getOuterCorrelations() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        Optional<LogicalPlanFragment> current = this.parent;
        while (current.isPresent()) {
            resultBuilder.addAll(current.get().getLogicalOperators().getCorrelations());
            current = current.get().parent;
        }
        return resultBuilder.build();
    }

    @Nonnull
    public LogicalPlanFragment addChild() {
        return LogicalPlanFragment.ofParent(Optional.of(this));
    }

    @Nonnull
    private static LogicalPlanFragment ofParent(@Nonnull Optional<LogicalPlanFragment> parent) {
        return new LogicalPlanFragment(parent, LogicalOperators.empty(), Optional.empty());
    }

    @Nonnull
    public static LogicalPlanFragment ofRoot() {
        return new LogicalPlanFragment(Optional.empty(), LogicalOperators.empty(), Optional.empty());
    }

    public static final class State {
        @Nonnull
        private final Optional<Type> targetType;
        @Nonnull
        private final Optional<StringTrieNode> targetTypeReorderings;

        private State(@Nonnull Optional<Type> targetType, @Nonnull Optional<StringTrieNode> targetTypeReorderings) {
            this.targetType = targetType;
            this.targetTypeReorderings = targetTypeReorderings;
        }

        @Nonnull
        public static Builder newBuilder() {
            return new Builder();
        }

        @Nonnull
        public Optional<Type> getTargetType() {
            return this.targetType;
        }

        @Nonnull
        public Optional<StringTrieNode> getTargetTypeReorderings() {
            return this.targetTypeReorderings;
        }

        public static final class Builder {
            @Nullable
            private Type targetType;
            @Nullable
            StringTrieNode targetTypeReorderings;

            private Builder() {
            }

            @Nonnull
            public Builder withTargetType(@Nonnull Type targetType) {
                this.targetType = targetType;
                return this;
            }

            @Nonnull
            public Builder withTargetTypeReorderings(@Nonnull StringTrieNode targetTypeReorderings) {
                this.targetTypeReorderings = targetTypeReorderings;
                return this;
            }

            @Nonnull
            public State build() {
                return new State(Optional.ofNullable(this.targetType), Optional.ofNullable(this.targetTypeReorderings));
            }
        }
    }
}

