/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalQuery {
    private final String query;
    private final long queryHash;

    public LogicalQuery(@Nonnull String query, long queryHash) {
        this.query = query;
        this.queryHash = queryHash;
    }

    public static LogicalQuery of(@Nonnull String query, @Nonnull RelationalExpression relExp) {
        return new LogicalQuery(query, relExp.semanticHashCode());
    }

    public String getQuery() {
        return this.query;
    }

    public long getQueryHash() {
        return this.queryHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogicalQuery)) {
            return false;
        }
        LogicalQuery that = (LogicalQuery)o;
        return this.queryHash == that.queryHash && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.queryHash);
    }
}

