/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.EvaluatesToValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.OfTypeValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.LiteralsUtils;
import com.apple.foundationdb.relational.recordlayer.query.OrderedLiteral;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ZeroCopyByteString;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MutablePlanGenerationContext
implements QueryExecutionContext {
    @Nonnull
    private final PreparedParams preparedParams;
    @Nonnull
    private final Literals.Builder literalsBuilder;
    private final int parameterHash;
    @Nonnull
    private final PlanHashable.PlanHashMode planHashMode;
    @Nonnull
    private final String query;
    @Nonnull
    private final String canonicalQueryString;
    @Nonnull
    private final List<ConstantObjectValue> constantObjectValues;
    private boolean shouldProcessLiteral;
    private boolean forExplain;
    @Nullable
    private byte[] continuation;
    @Nonnull
    private final ImmutableList.Builder<QueryPredicate> equalityConstraints;

    private void startStructLiteral() {
        this.literalsBuilder.startStructLiteral();
    }

    private void finishStructLiteral(@Nonnull Type.Record type, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        this.literalsBuilder.finishStructLiteral(type, unnamedParameterIndex, parameterName, tokenIndex);
    }

    private void addLiteralReference(@Nonnull ConstantObjectValue constantObjectValue) {
        if (!this.literalsBuilder.isAddingComplexLiteral()) {
            this.constantObjectValues.add(constantObjectValue);
        }
    }

    @Nonnull
    private Optional<OrderedLiteral> getFirstDuplicate(@Nullable Object literal, int requestedTokenIndex, @Nonnull Type type) {
        Optional<OrderedLiteral> orderedLiteralMaybe = this.literalsBuilder.getFirstValueDuplicateMaybe(literal);
        if (orderedLiteralMaybe.isEmpty()) {
            return Optional.empty();
        }
        this.addEqualityConstraint(this.literalsBuilder.constructConstantId(requestedTokenIndex), orderedLiteralMaybe.get().getConstantId(), type);
        return orderedLiteralMaybe;
    }

    @Nonnull
    private Optional<OrderedLiteral> getFirstDuplicate(@Nonnull String constantId) {
        Optional<OrderedLiteral> firstDuplicateMaybe = this.literalsBuilder.getFirstDuplicateOfConstantIdMaybe(constantId);
        if (firstDuplicateMaybe.isEmpty()) {
            return firstDuplicateMaybe;
        }
        OrderedLiteral firstDuplicate = firstDuplicateMaybe.get();
        this.addEqualityConstraint(firstDuplicate.getConstantId(), constantId, firstDuplicate.getType());
        return firstDuplicateMaybe;
    }

    private void addEqualityConstraint(@Nonnull String leftTokenId, @Nonnull String rightTokenId, @Nonnull Type type) {
        if (leftTokenId.equals(rightTokenId)) {
            return;
        }
        ConstantObjectValue leftCov = ConstantObjectValue.of(Quantifier.constant(), leftTokenId, type);
        ConstantObjectValue rightCov = ConstantObjectValue.of(Quantifier.constant(), rightTokenId, type);
        ValuePredicate leftIsNotNull = new ValuePredicate(leftCov, new Comparisons.NullComparison(Comparisons.Type.NOT_NULL));
        ValuePredicate rightIsNotNull = new ValuePredicate(rightCov, new Comparisons.NullComparison(Comparisons.Type.NOT_NULL));
        ValuePredicate equalityPredicate = new ValuePredicate(leftCov, new Comparisons.ValueComparison(Comparisons.Type.EQUALS, rightCov));
        QueryPredicate notNullComparison = AndPredicate.and(ImmutableList.of(leftIsNotNull, rightIsNotNull, equalityPredicate));
        ValuePredicate leftIsNull = new ValuePredicate(leftCov, new Comparisons.NullComparison(Comparisons.Type.IS_NULL));
        ValuePredicate rightIsNull = new ValuePredicate(rightCov, new Comparisons.NullComparison(Comparisons.Type.IS_NULL));
        QueryPredicate bothAreNullComparison = AndPredicate.and(leftIsNull, rightIsNull, new QueryPredicate[0]);
        QueryPredicate constraint = OrPredicate.or(notNullComparison, bothAreNullComparison, new QueryPredicate[0]);
        this.equalityConstraints.add((Object)constraint);
    }

    private void setShouldProcessLiteral(boolean shouldProcessLiteral) {
        this.shouldProcessLiteral = shouldProcessLiteral;
    }

    @Nonnull
    private ConstantObjectValue processPreparedStatementArrayParameter(@Nonnull Array param, @Nullable Type.Array type, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        Type.Array resolvedType = type;
        this.startArrayLiteral();
        ArrayList<Object> arrayElements = new ArrayList<Object>();
        try {
            if (type == null) {
                resolvedType = (Type.Array)DataTypeUtils.toRecordLayerType(((RelationalArray)param).getMetaData().asRelationalType());
            }
            try (ResultSet rs = param.getResultSet();){
                while (rs.next()) {
                    arrayElements.add(rs.getObject(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RelationalException(e).toUncheckedWrappedException();
        }
        if (!arrayElements.isEmpty()) {
            Assert.thatUnchecked(resolvedType.equals(LiteralsUtils.resolveArrayTypeFromObjectsList(arrayElements)), ErrorCode.DATATYPE_MISMATCH, "Cannot convert literal to " + String.valueOf(resolvedType));
        }
        for (int i = 0; i < arrayElements.size(); ++i) {
            Object o = arrayElements.get(i);
            this.processPreparedStatementParameter(o, resolvedType.getElementType(), unnamedParameterIndex, parameterName, i);
        }
        this.finishArrayLiteral(unnamedParameterIndex, parameterName, tokenIndex);
        return this.processComplexLiteral(tokenIndex, resolvedType);
    }

    @Nonnull
    private Value processQueryLiteralOrParameter(@Nonnull Type type, @Nullable Object literal, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        LiteralValue<Object> literalValue = new LiteralValue<Object>(literal);
        if (!this.shouldProcessLiteral()) {
            return literalValue;
        }
        OrderedLiteral orderedLiteral = this.literalsBuilder.addLiteral(type, literal, unnamedParameterIndex, parameterName, tokenIndex);
        ConstantObjectValue result = ConstantObjectValue.of(Quantifier.constant(), orderedLiteral.getConstantId(), literalValue.getResultType());
        this.addLiteralReference(result);
        return this.getFirstDuplicate(literal, tokenIndex, type).map(duplicate -> ConstantObjectValue.of(Quantifier.constant(), duplicate.getConstantId(), literalValue.getResultType())).orElse(result);
    }

    @Nonnull
    private Value processPreparedStatementParameter(@Nullable Object param, @Nullable Type type, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        if (param instanceof Array) {
            Assert.thatUnchecked(type == null || type.isArray(), ErrorCode.DATATYPE_MISMATCH, "Array type field required as prepared statement parameter");
            return this.processPreparedStatementArrayParameter((Array)param, (Type.Array)type, unnamedParameterIndex, parameterName, tokenIndex);
        }
        if (param instanceof Struct) {
            Assert.thatUnchecked(type == null || type.isRecord(), ErrorCode.DATATYPE_MISMATCH, "Required type field required as prepared statement parameter");
            return this.processPreparedStatementStructParameter((Struct)param, (Type.Record)type, unnamedParameterIndex, parameterName, tokenIndex);
        }
        if (param instanceof byte[]) {
            return this.processQueryLiteralOrParameter(Type.primitiveType(Type.TypeCode.BYTES), ZeroCopyByteString.wrap((byte[])param), unnamedParameterIndex, parameterName, tokenIndex);
        }
        return this.processQueryLiteralOrParameter(type == null ? Type.any() : type, param, unnamedParameterIndex, parameterName, tokenIndex);
    }

    public MutablePlanGenerationContext(@Nonnull PreparedParams preparedParams, @Nonnull PlanHashable.PlanHashMode planHashMode, @Nonnull String query, @Nonnull String canonicalQueryString, int parameterHash) {
        this.preparedParams = preparedParams;
        this.planHashMode = planHashMode;
        this.query = query;
        this.canonicalQueryString = canonicalQueryString;
        this.parameterHash = parameterHash;
        this.literalsBuilder = Literals.newBuilder();
        this.constantObjectValues = new LinkedList<ConstantObjectValue>();
        this.shouldProcessLiteral = true;
        this.forExplain = false;
        this.setContinuation(null);
        this.equalityConstraints = ImmutableList.builder();
    }

    @Nonnull
    public PreparedParams getPreparedParams() {
        return this.preparedParams;
    }

    public void startArrayLiteral() {
        this.literalsBuilder.startArrayLiteral();
    }

    public void finishArrayLiteral(@Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        this.literalsBuilder.finishArrayLiteral(unnamedParameterIndex, parameterName, this.shouldProcessLiteral, tokenIndex);
    }

    @Override
    @Nonnull
    public Literals getLiterals() {
        return this.literalsBuilder.build();
    }

    @Nonnull
    public Literals.Builder getLiteralsBuilder() {
        return this.literalsBuilder;
    }

    @Override
    @Nonnull
    public PlanHashable.PlanHashMode getPlanHashMode() {
        return this.planHashMode;
    }

    @Nonnull
    public String getQuery() {
        return this.query;
    }

    @Nonnull
    public String getCanonicalQueryString() {
        return this.canonicalQueryString;
    }

    public boolean isForDdl() {
        return !this.shouldProcessLiteral;
    }

    @Override
    @Nonnull
    public ExecuteProperties.Builder getExecutionPropertiesBuilder() {
        return ExecuteProperties.newBuilder();
    }

    @Override
    @Nullable
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"}, justification="Intentional")
    public byte[] getContinuation() {
        return this.continuation;
    }

    @Override
    public int getParameterHash() {
        return this.parameterHash;
    }

    @Override
    public boolean isForExplain() {
        return this.forExplain;
    }

    @Nonnull
    public QueryPlanConstraint getPlanConstraintsForLiteralReferences() {
        ImmutableList.Builder predicateBuilder = ImmutableList.builder();
        this.constantObjectValues.forEach(cov -> predicateBuilder.add(new ValuePredicate(OfTypeValue.from(cov), new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, true))));
        predicateBuilder.addAll((Iterable)this.equalityConstraints.build());
        EvaluationContext evaluationContext = this.getEvaluationContext();
        this.constantObjectValues.forEach(cov -> predicateBuilder.add(new ValuePredicate(EvaluatesToValue.of(cov, evaluationContext), new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, true))));
        return QueryPlanConstraint.ofPredicates(predicateBuilder.build());
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="Intentional")
    public void setContinuation(@Nullable byte[] continuation) {
        this.continuation = continuation;
    }

    public boolean shouldProcessLiteral() {
        return this.shouldProcessLiteral;
    }

    public void setForExplain(boolean forExplain) {
        this.forExplain = forExplain;
    }

    @Nonnull
    public Value processQueryLiteral(@Nonnull Type type, @Nullable Object literal, int tokenIndex) {
        return this.processQueryLiteralOrParameter(type, literal, null, null, tokenIndex);
    }

    @Nonnull
    public <T> T withDisabledLiteralProcessing(@Nonnull Supplier<T> supplier) {
        boolean oldShouldProcessLiteral = this.shouldProcessLiteral();
        this.setShouldProcessLiteral(false);
        T result = supplier.get();
        this.setShouldProcessLiteral(oldShouldProcessLiteral);
        return result;
    }

    @Nonnull
    public ConstantObjectValue processComplexLiteral(int tokenIndex, @Nonnull Type type) {
        String constantId = this.literalsBuilder.constructConstantId(tokenIndex);
        ConstantObjectValue result = ConstantObjectValue.of(Quantifier.constant(), constantId, type);
        if (this.shouldProcessLiteral()) {
            this.addLiteralReference(result);
        }
        return ConstantObjectValue.of(Quantifier.constant(), this.getFirstDuplicate(constantId).map(OrderedLiteral::getConstantId).orElse(constantId), type);
    }

    @Nonnull
    public Value processPreparedStatementStructParameter(@Nonnull Struct param, @Nullable Type.Record type, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex) {
        Object[] attributes;
        Type.Record resolvedType = type;
        this.startStructLiteral();
        try {
            if (type == null) {
                resolvedType = (Type.Record)DataTypeUtils.toRecordLayerType(((RelationalStruct)param).getMetaData().getRelationalDataType());
            }
            attributes = param.getAttributes();
        }
        catch (SQLException e) {
            throw new RelationalException(e).toUncheckedWrappedException();
        }
        Assert.thatUnchecked(resolvedType.getFields().size() == attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            this.processPreparedStatementParameter(attributes[i], resolvedType.getFields().get(i).getFieldType(), unnamedParameterIndex, parameterName, i);
        }
        this.finishStructLiteral(resolvedType, unnamedParameterIndex, parameterName, tokenIndex);
        return this.processComplexLiteral(tokenIndex, resolvedType);
    }

    public void importAuxiliaryLiterals(@Nonnull Literals auxiliaryLiterals) {
        List<OrderedLiteral> newLiterals = this.literalsBuilder.importLiteralsRetrieveNewLiterals(auxiliaryLiterals);
        for (OrderedLiteral literal : newLiterals) {
            LiteralValue<Object> literalValue = new LiteralValue<Object>(literal.getLiteralObject());
            Optional<OrderedLiteral> duplicateLiteralMaybe = this.literalsBuilder.getFirstValueDuplicateMaybe(literal.getLiteralObject());
            duplicateLiteralMaybe.ifPresent(prev -> this.addEqualityConstraint(prev.getConstantId(), literal.getConstantId(), literalValue.getResultType()));
            this.constantObjectValues.add(ConstantObjectValue.of(Quantifier.constant(), literal.getConstantId(), literalValue.getResultType()));
        }
    }

    @Nonnull
    public Value processNamedPreparedParam(@Nonnull String param, int tokenIndex) {
        Object value = this.preparedParams.namedParamValue(param);
        return this.processPreparedStatementParameter(value, null, null, param, tokenIndex);
    }

    @Nonnull
    public Value processUnnamedPreparedParam(int tokenIndex) {
        int currentUnnamedParameterIndex = this.preparedParams.currentUnnamedParamIndex();
        Object param = this.preparedParams.nextUnnamedParamValue();
        return this.processPreparedStatementParameter(param, null, currentUnnamedParameterIndex, null, tokenIndex);
    }
}

