/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class NormalizedQueryExecutionContext
implements QueryExecutionContext {
    @Nonnull
    private final Literals literals;
    @Nullable
    private final byte[] continuation;
    private final boolean isForExplain;
    private final int parameterHash;
    @Nonnull
    private final PlanHashable.PlanHashMode planHashMode;

    private NormalizedQueryExecutionContext(@Nonnull Literals literals, @Nullable byte[] continuation, int parameterHash, boolean isForExplain, @Nonnull PlanHashable.PlanHashMode planHashMode) {
        this.literals = literals;
        this.continuation = continuation;
        this.isForExplain = isForExplain;
        this.parameterHash = parameterHash;
        this.planHashMode = planHashMode;
    }

    @Override
    @Nonnull
    public Literals getLiterals() {
        return this.literals;
    }

    @Override
    @Nonnull
    public ExecuteProperties.Builder getExecutionPropertiesBuilder() {
        return ExecuteProperties.newBuilder();
    }

    @Override
    @Nullable
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"}, justification="Intentional")
    public byte[] getContinuation() {
        return this.continuation;
    }

    @Override
    public int getParameterHash() {
        return this.parameterHash;
    }

    @Override
    public boolean isForExplain() {
        return this.isForExplain;
    }

    @Override
    @Nonnull
    public PlanHashable.PlanHashMode getPlanHashMode() {
        return this.planHashMode;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nonnull
        private final Literals.Builder literalsBuilder = Literals.newBuilder();
        private boolean isForExplain = false;
        @Nullable
        private byte[] continuation = null;
        private int parameterHash;
        @Nullable
        private PlanHashable.PlanHashMode planHashMode = null;

        private Builder() {
        }

        @Nonnull
        public Builder setParameterHash(int parameterHash) {
            this.parameterHash = parameterHash;
            return this;
        }

        @Nonnull
        @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="Intentional")
        public Builder setContinuation(@Nullable byte[] continuation) {
            this.continuation = continuation;
            return this;
        }

        @Nonnull
        public Literals.Builder getLiteralsBuilder() {
            return this.literalsBuilder;
        }

        @Nonnull
        public Builder setForExplain(boolean isForExplain) {
            this.isForExplain = isForExplain;
            return this;
        }

        @Nonnull
        public Builder setPlanHashMode(@Nonnull PlanHashable.PlanHashMode planHashMode) {
            this.planHashMode = planHashMode;
            return this;
        }

        @Nonnull
        public NormalizedQueryExecutionContext build() {
            return new NormalizedQueryExecutionContext(this.literalsBuilder.build(), this.continuation, this.parameterHash, this.isForExplain, Objects.requireNonNull(this.planHashMode));
        }
    }
}

