/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public final class OptionsUtils {
    @Nonnull
    public static PlanHashable.PlanHashMode getCurrentPlanHashMode(@Nonnull Options options) {
        String planHashModeAsString = (String)options.getOption(Options.Name.CURRENT_PLAN_HASH_MODE);
        return planHashModeAsString == null ? PlanHashable.CURRENT_FOR_CONTINUATION : PlanHashable.PlanHashMode.valueOf(planHashModeAsString);
    }

    @Nonnull
    public static Set<PlanHashable.PlanHashMode> getValidPlanHashModes(@Nonnull Options options) {
        String planHashModesAsString = (String)options.getOption(Options.Name.VALID_PLAN_HASH_MODES);
        if (planHashModesAsString == null) {
            return ImmutableSet.of(PlanHashable.CURRENT_FOR_CONTINUATION);
        }
        return Arrays.stream(planHashModesAsString.split(",")).map(planHashModeAsString -> PlanHashable.PlanHashMode.valueOf(planHashModeAsString.trim())).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static IndexFetchMethod getIndexFetchMethod(@Nonnull Options options) {
        Options.IndexFetchMethod indexFetchMethod = (Options.IndexFetchMethod)((Object)options.getOption(Options.Name.INDEX_FETCH_METHOD));
        if (indexFetchMethod == null) {
            return IndexFetchMethod.USE_REMOTE_FETCH_WITH_FALLBACK;
        }
        switch (indexFetchMethod) {
            case SCAN_AND_FETCH: {
                return IndexFetchMethod.SCAN_AND_FETCH;
            }
            case USE_REMOTE_FETCH: {
                return IndexFetchMethod.USE_REMOTE_FETCH;
            }
            case USE_REMOTE_FETCH_WITH_FALLBACK: {
                return IndexFetchMethod.USE_REMOTE_FETCH_WITH_FALLBACK;
            }
        }
        throw new RelationalException("Can not convert index fetch method '" + indexFetchMethod.name() + "' to planner configuration", ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
    }
}

