/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.Star;
import com.apple.foundationdb.relational.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class OrderByExpression {
    @Nonnull
    private final Expression expression;
    private final boolean descending;
    private final boolean nullsLast;

    private OrderByExpression(@Nonnull Expression expression, boolean descending, boolean nullsLast) {
        this.expression = expression;
        this.descending = descending;
        this.nullsLast = nullsLast;
    }

    @Nonnull
    public Expression getExpression() {
        return this.expression;
    }

    @Nonnull
    private OrderByExpression withExpression(@Nonnull Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return new OrderByExpression(expression, this.descending, this.nullsLast);
    }

    @Nonnull
    public static OrderByExpression of(@Nonnull Expression expression, boolean descending, boolean nullsLast) {
        return new OrderByExpression(expression, descending, nullsLast);
    }

    @Nonnull
    public static Stream<OrderByExpression> pullUp(@Nonnull Stream<OrderByExpression> orderBys, @Nonnull Value value, @Nonnull CorrelationIdentifier correlationIdentifier, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull Optional<Identifier> qualifier) {
        AliasMap aliasMap = AliasMap.identitiesFor(value.getCorrelatedTo());
        Value simplifiedValue = value.simplify(EvaluationContext.empty(), aliasMap, constantAliases);
        return orderBys.flatMap(orderBy -> orderBy.getExpression() instanceof Star ? ((Star)orderBy.getExpression()).getExpansion().stream().map(orderBy::withExpression) : Stream.of(orderBy)).map(orderBy -> {
            Expression orderByExpression = orderBy.getExpression();
            Value underlying = orderByExpression.getUnderlying();
            Value pulledUpUnderlying = Assert.notNullUnchecked((Value)underlying.replace(subExpression -> {
                Map<Value, Value> pulledUpExpressionMap = simplifiedValue.pullUp(List.of(subExpression), EvaluationContext.empty(), aliasMap, constantAliases, correlationIdentifier);
                if (pulledUpExpressionMap.containsKey(subExpression)) {
                    return pulledUpExpressionMap.get(subExpression);
                }
                return subExpression;
            }));
            Expression pulledUpExpression = pulledUpUnderlying == underlying ? orderByExpression : orderByExpression.withUnderlying(pulledUpUnderlying);
            Expression qualifiedExpression = qualifier.map(pulledUpExpression::withName).orElseGet(pulledUpExpression::clearQualifier);
            if (qualifiedExpression == orderByExpression) {
                return orderBy;
            }
            return orderBy.withExpression(qualifiedExpression);
        });
    }

    @Nonnull
    public OrderingPart.RequestedSortOrder toSortOrder() {
        if (this.descending) {
            return this.nullsLast ? OrderingPart.RequestedSortOrder.DESCENDING : OrderingPart.RequestedSortOrder.DESCENDING_NULLS_FIRST;
        }
        return this.nullsLast ? OrderingPart.RequestedSortOrder.ASCENDING_NULLS_LAST : OrderingPart.RequestedSortOrder.ASCENDING;
    }

    @Nonnull
    public static Stream<OrderingPart.RequestedOrderingPart> toOrderingParts(@Nonnull Stream<OrderByExpression> orderBys, @Nonnull CorrelationIdentifier rebaseSource, @Nonnull CorrelationIdentifier rebaseTarget) {
        AliasMap aliasMap = AliasMap.ofAliases(rebaseSource, rebaseTarget);
        return orderBys.map(orderBy -> {
            Value rebased = orderBy.getExpression().getUnderlying().rebase(aliasMap);
            OrderingPart.RequestedSortOrder sortOrder = orderBy.toSortOrder();
            return new OrderingPart.RequestedOrderingPart(rebased, sortOrder);
        });
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.expression.toString());
        if (this.descending) {
            str.append(" DESC");
        }
        if (this.descending != this.nullsLast) {
            str.append(" NULLS ");
            str.append(this.nullsLast ? "LAST" : "FIRST");
        }
        return str.toString();
    }
}

